/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.AddTagsRequest;
import software.amazon.awssdk.services.opensearch.model.AddTagsResponse;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.opensearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListTagsRequest;
import software.amazon.awssdk.services.opensearch.model.ListTagsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse;
import software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher;
import software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher;

/**
 * Service client for accessing Amazon OpenSearch Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon OpenSearch Configuration Service</fullname>
 * <p>
 * Use the Amazon OpenSearch configuration API to create, configure, and manage Amazon OpenSearch Service domains.
 * </p>
 * <p>
 * For sample code that uses the configuration API, see the <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-configuration-samples.html">
 * Amazon OpenSearch Service Developer Guide</a>. The guide also contains <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/request-signing.html"> sample code for
 * sending signed HTTP requests to the OpenSearch APIs</a>.
 * </p>
 * <p>
 * The endpoint for configuration service requests is region-specific: es.<i>region</i>.amazonaws.com. For example,
 * es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a
 * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#service-regions" target="_blank">Regions and
 * Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OpenSearchAsyncClient extends SdkClient {
    String SERVICE_NAME = "es";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "es";

    /**
     * Create a {@link OpenSearchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OpenSearchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OpenSearchAsyncClient}.
     */
    static OpenSearchAsyncClientBuilder builder() {
        return new DefaultOpenSearchAsyncClientBuilder();
    }

    /**
     * <p>
     * Allows the remote domain owner to accept an inbound cross-cluster connection request.
     * </p>
     *
     * @param acceptInboundConnectionRequest
     *        Container for the parameters to the <code> <a>AcceptInboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the AcceptInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AcceptInboundConnection
     */
    default CompletableFuture<AcceptInboundConnectionResponse> acceptInboundConnection(
            AcceptInboundConnectionRequest acceptInboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the remote domain owner to accept an inbound cross-cluster connection request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptInboundConnectionRequest#builder()}
     * </p>
     *
     * @param acceptInboundConnectionRequest
     *        A {@link Consumer} that will call methods on {@link AcceptInboundConnectionRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>AcceptInboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the AcceptInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AcceptInboundConnection
     */
    default CompletableFuture<AcceptInboundConnectionResponse> acceptInboundConnection(
            Consumer<AcceptInboundConnectionRequest.Builder> acceptInboundConnectionRequest) {
        return acceptInboundConnection(AcceptInboundConnectionRequest.builder().applyMutation(acceptInboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to
     * 10 tags. See <a href=
     * "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon OpenSearch Service domains</a> for more information.
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code> <a>AddTags</a> </code> operation. Specifies the tags to attach
     *        to the domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to
     * 10 tags. See <a href=
     * "http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon OpenSearch Service domains</a> for more information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsRequest.Builder} to create a request. Container
     *        for the parameters to the <code> <a>AddTags</a> </code> operation. Specifies the tags to attach to the
     *        domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Associates a package with an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param associatePackageRequest
     *        Container for the request parameters to the <code> <a>AssociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the AssociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AssociatePackage
     */
    default CompletableFuture<AssociatePackageResponse> associatePackage(AssociatePackageRequest associatePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a package with an Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePackageRequest.Builder} avoiding the need
     * to create one manually via {@link AssociatePackageRequest#builder()}
     * </p>
     *
     * @param associatePackageRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePackageRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>AssociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the AssociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AssociatePackage
     */
    default CompletableFuture<AssociatePackageResponse> associatePackage(
            Consumer<AssociatePackageRequest.Builder> associatePackageRequest) {
        return associatePackage(AssociatePackageRequest.builder().applyMutation(associatePackageRequest).build());
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this
     * operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the
     * <code>PENDING_UPDATE</code> state.
     * </p>
     *
     * @param cancelServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code> <a>CancelServiceSoftwareUpdate</a> </code> operation. Specifies
     *        the name of the domain that you wish to cancel a service software update on.
     * @return A Java Future containing the result of the CancelServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CancelServiceSoftwareUpdate
     */
    default CompletableFuture<CancelServiceSoftwareUpdateResponse> cancelServiceSoftwareUpdate(
            CancelServiceSoftwareUpdateRequest cancelServiceSoftwareUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this
     * operation before the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the
     * <code>PENDING_UPDATE</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelServiceSoftwareUpdateRequest.Builder}
     * avoiding the need to create one manually via {@link CancelServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param cancelServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on {@link CancelServiceSoftwareUpdateRequest.Builder} to create
     *        a request. Container for the parameters to the <code> <a>CancelServiceSoftwareUpdate</a> </code>
     *        operation. Specifies the name of the domain that you wish to cancel a service software update on.
     * @return A Java Future containing the result of the CancelServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CancelServiceSoftwareUpdate
     */
    default CompletableFuture<CancelServiceSoftwareUpdateResponse> cancelServiceSoftwareUpdate(
            Consumer<CancelServiceSoftwareUpdateRequest.Builder> cancelServiceSoftwareUpdateRequest) {
        return cancelServiceSoftwareUpdate(CancelServiceSoftwareUpdateRequest.builder()
                .applyMutation(cancelServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon OpenSearch Service domain. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html"
     * target="_blank">Creating and managing Amazon OpenSearch Service domains </a> in the <i>Amazon OpenSearch Service
     * Developer Guide</i>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateDomain
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon OpenSearch Service domain. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html"
     * target="_blank">Creating and managing Amazon OpenSearch Service domains </a> in the <i>Amazon OpenSearch Service
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateDomain
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.
     * </p>
     *
     * @param createOutboundConnectionRequest
     *        Container for the parameters to the <code> <a>CreateOutboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the CreateOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateOutboundConnection
     */
    default CompletableFuture<CreateOutboundConnectionResponse> createOutboundConnection(
            CreateOutboundConnectionRequest createOutboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOutboundConnectionRequest#builder()}
     * </p>
     *
     * @param createOutboundConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateOutboundConnectionRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>CreateOutboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the CreateOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateOutboundConnection
     */
    default CompletableFuture<CreateOutboundConnectionResponse> createOutboundConnection(
            Consumer<CreateOutboundConnectionRequest.Builder> createOutboundConnectionRequest) {
        return createOutboundConnection(CreateOutboundConnectionRequest.builder().applyMutation(createOutboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Create a package for use with Amazon OpenSearch Service domains.
     * </p>
     *
     * @param createPackageRequest
     *        Container for request parameters to the <code> <a>CreatePackage</a> </code> operation.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreatePackage
     */
    default CompletableFuture<CreatePackageResponse> createPackage(CreatePackageRequest createPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a package for use with Amazon OpenSearch Service domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePackageRequest#builder()}
     * </p>
     *
     * @param createPackageRequest
     *        A {@link Consumer} that will call methods on {@link CreatePackageRequest.Builder} to create a request.
     *        Container for request parameters to the <code> <a>CreatePackage</a> </code> operation.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreatePackage
     */
    default CompletableFuture<CreatePackageResponse> createPackage(Consumer<CreatePackageRequest.Builder> createPackageRequest) {
        return createPackage(CreatePackageRequest.builder().applyMutation(createPackageRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered.
     * </p>
     *
     * @param deleteDomainRequest
     *        Container for the parameters to the <code> <a>DeleteDomain</a> </code> operation. Specifies the name of
     *        the domain you want to delete.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteDomain
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>DeleteDomain</a> </code> operation. Specifies the name of
     *        the domain you want to delete.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteDomain
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Allows the remote domain owner to delete an existing inbound cross-cluster connection.
     * </p>
     *
     * @param deleteInboundConnectionRequest
     *        Container for the parameters to the <code> <a>DeleteInboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the DeleteInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteInboundConnection
     */
    default CompletableFuture<DeleteInboundConnectionResponse> deleteInboundConnection(
            DeleteInboundConnectionRequest deleteInboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the remote domain owner to delete an existing inbound cross-cluster connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInboundConnectionRequest#builder()}
     * </p>
     *
     * @param deleteInboundConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInboundConnectionRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>DeleteInboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the DeleteInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteInboundConnection
     */
    default CompletableFuture<DeleteInboundConnectionResponse> deleteInboundConnection(
            Consumer<DeleteInboundConnectionRequest.Builder> deleteInboundConnectionRequest) {
        return deleteInboundConnection(DeleteInboundConnectionRequest.builder().applyMutation(deleteInboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Allows the local domain owner to delete an existing outbound cross-cluster connection.
     * </p>
     *
     * @param deleteOutboundConnectionRequest
     *        Container for the parameters to the <code> <a>DeleteOutboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the DeleteOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteOutboundConnection
     */
    default CompletableFuture<DeleteOutboundConnectionResponse> deleteOutboundConnection(
            DeleteOutboundConnectionRequest deleteOutboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the local domain owner to delete an existing outbound cross-cluster connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOutboundConnectionRequest#builder()}
     * </p>
     *
     * @param deleteOutboundConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOutboundConnectionRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>DeleteOutboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the DeleteOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteOutboundConnection
     */
    default CompletableFuture<DeleteOutboundConnectionResponse> deleteOutboundConnection(
            Consumer<DeleteOutboundConnectionRequest.Builder> deleteOutboundConnectionRequest) {
        return deleteOutboundConnection(DeleteOutboundConnectionRequest.builder().applyMutation(deleteOutboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the package.
     * </p>
     *
     * @param deletePackageRequest
     *        Container for the request parameters to the <code> <a>DeletePackage</a> </code> operation.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeletePackage
     */
    default CompletableFuture<DeletePackageResponse> deletePackage(DeletePackageRequest deletePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePackageRequest#builder()}
     * </p>
     *
     * @param deletePackageRequest
     *        A {@link Consumer} that will call methods on {@link DeletePackageRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>DeletePackage</a> </code> operation.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeletePackage
     */
    default CompletableFuture<DeletePackageResponse> deletePackage(Consumer<DeletePackageRequest.Builder> deletePackageRequest) {
        return deletePackage(DeletePackageRequest.builder().applyMutation(deletePackageRequest).build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified domain, including the domain ID, domain endpoint,
     * and domain ARN.
     * </p>
     *
     * @param describeDomainRequest
     *        Container for the parameters to the <code> <a>DescribeDomain</a> </code> operation.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomain
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified domain, including the domain ID, domain endpoint,
     * and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>DescribeDomain</a> </code> operation.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomain
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest) {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity,
     * and scheduled date.
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainAutoTunes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default CompletableFuture<DescribeDomainAutoTunesResponse> describeDomainAutoTunes(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity,
     * and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainAutoTunesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainAutoTunesRequest#builder()}
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainAutoTunesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainAutoTunes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default CompletableFuture<DescribeDomainAutoTunesResponse> describeDomainAutoTunes(
            Consumer<DescribeDomainAutoTunesRequest.Builder> describeDomainAutoTunesRequest) {
        return describeDomainAutoTunes(DescribeDomainAutoTunesRequest.builder().applyMutation(describeDomainAutoTunesRequest)
                .build());
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity,
     * and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesPublisher describeDomainAutoTunesPaginator(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity,
     * and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainAutoTunesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainAutoTunesRequest#builder()}
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainAutoTunesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesPublisher describeDomainAutoTunesPaginator(
            Consumer<DescribeDomainAutoTunesRequest.Builder> describeDomainAutoTunesRequest) {
        return describeDomainAutoTunesPaginator(DescribeDomainAutoTunesRequest.builder()
                .applyMutation(describeDomainAutoTunesRequest).build());
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified domain, such as the state, creation date, update
     * version, and update date for cluster options.
     * </p>
     *
     * @param describeDomainConfigRequest
     *        Container for the parameters to the <code>DescribeDomainConfig</code> operation. Specifies the domain name
     *        for which you want configuration information.
     * @return A Java Future containing the result of the DescribeDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainConfig
     */
    default CompletableFuture<DescribeDomainConfigResponse> describeDomainConfig(
            DescribeDomainConfigRequest describeDomainConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified domain, such as the state, creation date, update
     * version, and update date for cluster options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDomainConfigRequest#builder()}
     * </p>
     *
     * @param describeDomainConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainConfigRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainConfig</code> operation. Specifies the
     *        domain name for which you want configuration information.
     * @return A Java Future containing the result of the DescribeDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainConfig
     */
    default CompletableFuture<DescribeDomainConfigResponse> describeDomainConfig(
            Consumer<DescribeDomainConfigRequest.Builder> describeDomainConfigRequest) {
        return describeDomainConfig(DescribeDomainConfigRequest.builder().applyMutation(describeDomainConfigRequest).build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified domains, including the domain ID, domain endpoint,
     * and domain ARN.
     * </p>
     *
     * @param describeDomainsRequest
     *        Container for the parameters to the <code> <a>DescribeDomains</a> </code> operation. By default, the API
     *        returns the status of all domains.
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified domains, including the domain ID, domain endpoint,
     * and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDomainsRequest#builder()}
     * </p>
     *
     * @param describeDomainsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainsRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>DescribeDomains</a> </code> operation. By default, the API
     *        returns the status of all domains.
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains(
            Consumer<DescribeDomainsRequest.Builder> describeDomainsRequest) {
        return describeDomains(DescribeDomainsRequest.builder().applyMutation(describeDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster connections for a remote domain.
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        Container for the parameters to the <code> <a>DescribeInboundConnections</a> </code> operation.
     * @return A Java Future containing the result of the DescribeInboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default CompletableFuture<DescribeInboundConnectionsResponse> describeInboundConnections(
            DescribeInboundConnectionsRequest describeInboundConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster connections for a remote domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInboundConnectionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>DescribeInboundConnections</a> </code> operation.
     * @return A Java Future containing the result of the DescribeInboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default CompletableFuture<DescribeInboundConnectionsResponse> describeInboundConnections(
            Consumer<DescribeInboundConnectionsRequest.Builder> describeInboundConnectionsRequest) {
        return describeInboundConnections(DescribeInboundConnectionsRequest.builder()
                .applyMutation(describeInboundConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster connections for a remote domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        Container for the parameters to the <code> <a>DescribeInboundConnections</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default DescribeInboundConnectionsPublisher describeInboundConnectionsPaginator(
            DescribeInboundConnectionsRequest describeInboundConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster connections for a remote domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInboundConnectionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>DescribeInboundConnections</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default DescribeInboundConnectionsPublisher describeInboundConnectionsPaginator(
            Consumer<DescribeInboundConnectionsRequest.Builder> describeInboundConnectionsRequest) {
        return describeInboundConnectionsPaginator(DescribeInboundConnectionsRequest.builder()
                .applyMutation(describeInboundConnectionsRequest).build());
    }

    /**
     * <p>
     * Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing
     * domain, specify the <code> <a>DomainName</a> </code> to see which limits you can modify.
     * </p>
     *
     * @param describeInstanceTypeLimitsRequest
     *        Container for the parameters to the <code> <a>DescribeInstanceTypeLimits</a> </code> operation.
     * @return A Java Future containing the result of the DescribeInstanceTypeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInstanceTypeLimits
     */
    default CompletableFuture<DescribeInstanceTypeLimitsResponse> describeInstanceTypeLimits(
            DescribeInstanceTypeLimitsRequest describeInstanceTypeLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing
     * domain, specify the <code> <a>DomainName</a> </code> to see which limits you can modify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceTypeLimitsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceTypeLimitsRequest#builder()}
     * </p>
     *
     * @param describeInstanceTypeLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceTypeLimitsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>DescribeInstanceTypeLimits</a> </code> operation.
     * @return A Java Future containing the result of the DescribeInstanceTypeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInstanceTypeLimits
     */
    default CompletableFuture<DescribeInstanceTypeLimitsResponse> describeInstanceTypeLimits(
            Consumer<DescribeInstanceTypeLimitsRequest.Builder> describeInstanceTypeLimitsRequest) {
        return describeInstanceTypeLimits(DescribeInstanceTypeLimitsRequest.builder()
                .applyMutation(describeInstanceTypeLimitsRequest).build());
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local domain.
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        Container for the parameters to the <code> <a>DescribeOutboundConnections</a> </code> operation.
     * @return A Java Future containing the result of the DescribeOutboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default CompletableFuture<DescribeOutboundConnectionsResponse> describeOutboundConnections(
            DescribeOutboundConnectionsRequest describeOutboundConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOutboundConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOutboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOutboundConnectionsRequest.Builder} to create
     *        a request. Container for the parameters to the <code> <a>DescribeOutboundConnections</a> </code>
     *        operation.
     * @return A Java Future containing the result of the DescribeOutboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default CompletableFuture<DescribeOutboundConnectionsResponse> describeOutboundConnections(
            Consumer<DescribeOutboundConnectionsRequest.Builder> describeOutboundConnectionsRequest) {
        return describeOutboundConnections(DescribeOutboundConnectionsRequest.builder()
                .applyMutation(describeOutboundConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        Container for the parameters to the <code> <a>DescribeOutboundConnections</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default DescribeOutboundConnectionsPublisher describeOutboundConnectionsPaginator(
            DescribeOutboundConnectionsRequest describeOutboundConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOutboundConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOutboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOutboundConnectionsRequest.Builder} to create
     *        a request. Container for the parameters to the <code> <a>DescribeOutboundConnections</a> </code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default DescribeOutboundConnectionsPublisher describeOutboundConnectionsPaginator(
            Consumer<DescribeOutboundConnectionsRequest.Builder> describeOutboundConnectionsRequest) {
        return describeOutboundConnectionsPaginator(DescribeOutboundConnectionsRequest.builder()
                .applyMutation(describeOutboundConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting
     * the number of results, and pagination.
     * </p>
     *
     * @param describePackagesRequest
     *        Container for the request parameters to the <code> <a>DescribePackage</a> </code> operation.
     * @return A Java Future containing the result of the DescribePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default CompletableFuture<DescribePackagesResponse> describePackages(DescribePackagesRequest describePackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting
     * the number of results, and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackagesRequest#builder()}
     * </p>
     *
     * @param describePackagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackagesRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>DescribePackage</a> </code> operation.
     * @return A Java Future containing the result of the DescribePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default CompletableFuture<DescribePackagesResponse> describePackages(
            Consumer<DescribePackagesRequest.Builder> describePackagesRequest) {
        return describePackages(DescribePackagesRequest.builder().applyMutation(describePackagesRequest).build());
    }

    /**
     * <p>
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting
     * the number of results, and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePackagesRequest
     *        Container for the request parameters to the <code> <a>DescribePackage</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default DescribePackagesPublisher describePackagesPaginator(DescribePackagesRequest describePackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting
     * the number of results, and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackagesRequest#builder()}
     * </p>
     *
     * @param describePackagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackagesRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>DescribePackage</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default DescribePackagesPublisher describePackagesPaginator(Consumer<DescribePackagesRequest.Builder> describePackagesRequest) {
        return describePackagesPaginator(DescribePackagesRequest.builder().applyMutation(describePackagesRequest).build());
    }

    /**
     * <p>
     * Lists available reserved OpenSearch instance offerings.
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedInstanceOfferings</code>
     * @return A Java Future containing the result of the DescribeReservedInstanceOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default CompletableFuture<DescribeReservedInstanceOfferingsResponse> describeReservedInstanceOfferings(
            DescribeReservedInstanceOfferingsRequest describeReservedInstanceOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved OpenSearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstanceOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedInstanceOfferingsRequest.Builder} to
     *        create a request. Container for parameters to <code>DescribeReservedInstanceOfferings</code>
     * @return A Java Future containing the result of the DescribeReservedInstanceOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default CompletableFuture<DescribeReservedInstanceOfferingsResponse> describeReservedInstanceOfferings(
            Consumer<DescribeReservedInstanceOfferingsRequest.Builder> describeReservedInstanceOfferingsRequest) {
        return describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsRequest.builder()
                .applyMutation(describeReservedInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved OpenSearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedInstanceOfferings</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default DescribeReservedInstanceOfferingsPublisher describeReservedInstanceOfferingsPaginator(
            DescribeReservedInstanceOfferingsRequest describeReservedInstanceOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved OpenSearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstanceOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedInstanceOfferingsRequest.Builder} to
     *        create a request. Container for parameters to <code>DescribeReservedInstanceOfferings</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default DescribeReservedInstanceOfferingsPublisher describeReservedInstanceOfferingsPaginator(
            Consumer<DescribeReservedInstanceOfferingsRequest.Builder> describeReservedInstanceOfferingsRequest) {
        return describeReservedInstanceOfferingsPaginator(DescribeReservedInstanceOfferingsRequest.builder()
                .applyMutation(describeReservedInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved OpenSearch instances for this account.
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Container for parameters to <code>DescribeReservedInstances</code>
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default CompletableFuture<DescribeReservedInstancesResponse> describeReservedInstances(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved OpenSearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedInstancesRequest.Builder} to create a
     *        request. Container for parameters to <code>DescribeReservedInstances</code>
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default CompletableFuture<DescribeReservedInstancesResponse> describeReservedInstances(
            Consumer<DescribeReservedInstancesRequest.Builder> describeReservedInstancesRequest) {
        return describeReservedInstances(DescribeReservedInstancesRequest.builder()
                .applyMutation(describeReservedInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved OpenSearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Container for parameters to <code>DescribeReservedInstances</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default DescribeReservedInstancesPublisher describeReservedInstancesPaginator(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved OpenSearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedInstancesRequest.Builder} to create a
     *        request. Container for parameters to <code>DescribeReservedInstances</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default DescribeReservedInstancesPublisher describeReservedInstancesPaginator(
            Consumer<DescribeReservedInstancesRequest.Builder> describeReservedInstancesRequest) {
        return describeReservedInstancesPaginator(DescribeReservedInstancesRequest.builder()
                .applyMutation(describeReservedInstancesRequest).build());
    }

    /**
     * <p>
     * Dissociates a package from the Amazon OpenSearch Service domain.
     * </p>
     *
     * @param dissociatePackageRequest
     *        Container for the request parameters to the <code> <a>DissociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the DissociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DissociatePackage
     */
    default CompletableFuture<DissociatePackageResponse> dissociatePackage(DissociatePackageRequest dissociatePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dissociates a package from the Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DissociatePackageRequest.Builder} avoiding the need
     * to create one manually via {@link DissociatePackageRequest#builder()}
     * </p>
     *
     * @param dissociatePackageRequest
     *        A {@link Consumer} that will call methods on {@link DissociatePackageRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>DissociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the DissociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DissociatePackage
     */
    default CompletableFuture<DissociatePackageResponse> dissociatePackage(
            Consumer<DissociatePackageRequest.Builder> dissociatePackageRequest) {
        return dissociatePackage(DissociatePackageRequest.builder().applyMutation(dissociatePackageRequest).build());
    }

    /**
     * <p>
     * Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that
     * specific domain.
     * </p>
     *
     * @param getCompatibleVersionsRequest
     *        Container for the request parameters to <code> <a>GetCompatibleVersions</a> </code> operation.
     * @return A Java Future containing the result of the GetCompatibleVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetCompatibleVersions
     */
    default CompletableFuture<GetCompatibleVersionsResponse> getCompatibleVersions(
            GetCompatibleVersionsRequest getCompatibleVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that
     * specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompatibleVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCompatibleVersionsRequest#builder()}
     * </p>
     *
     * @param getCompatibleVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCompatibleVersionsRequest.Builder} to create a
     *        request. Container for the request parameters to <code> <a>GetCompatibleVersions</a> </code> operation.
     * @return A Java Future containing the result of the GetCompatibleVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetCompatibleVersions
     */
    default CompletableFuture<GetCompatibleVersionsResponse> getCompatibleVersions(
            Consumer<GetCompatibleVersionsRequest.Builder> getCompatibleVersionsRequest) {
        return getCompatibleVersions(GetCompatibleVersionsRequest.builder().applyMutation(getCompatibleVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of package versions, along with their creation time and commit message.
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for the request parameters to the <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetPackageVersionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default CompletableFuture<GetPackageVersionHistoryResponse> getPackageVersionHistory(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of package versions, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionHistoryRequest#builder()}
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionHistoryRequest.Builder} to create a
     *        request. Container for the request parameters to the <code> <a>GetPackageVersionHistory</a> </code>
     *        operation.
     * @return A Java Future containing the result of the GetPackageVersionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default CompletableFuture<GetPackageVersionHistoryResponse> getPackageVersionHistory(
            Consumer<GetPackageVersionHistoryRequest.Builder> getPackageVersionHistoryRequest) {
        return getPackageVersionHistory(GetPackageVersionHistoryRequest.builder().applyMutation(getPackageVersionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of package versions, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for the request parameters to the <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryPublisher getPackageVersionHistoryPaginator(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of package versions, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionHistoryRequest#builder()}
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionHistoryRequest.Builder} to create a
     *        request. Container for the request parameters to the <code> <a>GetPackageVersionHistory</a> </code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryPublisher getPackageVersionHistoryPaginator(
            Consumer<GetPackageVersionHistoryRequest.Builder> getPackageVersionHistoryRequest) {
        return getPackageVersionHistoryPaginator(GetPackageVersionHistoryRequest.builder()
                .applyMutation(getPackageVersionHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for the request parameters to the <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeHistoryRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) {
        return getUpgradeHistory(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for the request parameters to the <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeHistoryRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) {
        return getUpgradeHistoryPaginator(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for the request parameters to the <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeStatus
     */
    default CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeStatusRequest#builder()}
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeStatusRequest.Builder} to create a request.
     *        Container for the request parameters to the <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeStatus
     */
    default CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(
            Consumer<GetUpgradeStatusRequest.Builder> getUpgradeStatusRequest) {
        return getUpgradeStatus(GetUpgradeStatusRequest.builder().applyMutation(getUpgradeStatusRequest).build());
    }

    /**
     * <p>
     * Returns the names of all domains owned by the current user's account.
     * </p>
     *
     * @param listDomainNamesRequest
     *        Container for the parameters to the <code><a>ListDomainNames</a></code> operation.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the names of all domains owned by the current user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainNamesRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>ListDomainNames</a></code> operation.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(
            Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest) {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with the package.
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for the request parameters to the <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A Java Future containing the result of the ListDomainsForPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default CompletableFuture<ListDomainsForPackageResponse> listDomainsForPackage(
            ListDomainsForPackageRequest listDomainsForPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsForPackageRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainsForPackageRequest#builder()}
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsForPackageRequest.Builder} to create a
     *        request. Container for the request parameters to the <code> <a>ListDomainsForPackage</a> </code>
     *        operation.
     * @return A Java Future containing the result of the ListDomainsForPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default CompletableFuture<ListDomainsForPackageResponse> listDomainsForPackage(
            Consumer<ListDomainsForPackageRequest.Builder> listDomainsForPackageRequest) {
        return listDomainsForPackage(ListDomainsForPackageRequest.builder().applyMutation(listDomainsForPackageRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for the request parameters to the <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default ListDomainsForPackagePublisher listDomainsForPackagePaginator(
            ListDomainsForPackageRequest listDomainsForPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsForPackageRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainsForPackageRequest#builder()}
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsForPackageRequest.Builder} to create a
     *        request. Container for the request parameters to the <code> <a>ListDomainsForPackage</a> </code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default ListDomainsForPackagePublisher listDomainsForPackagePaginator(
            Consumer<ListDomainsForPackageRequest.Builder> listDomainsForPackageRequest) {
        return listDomainsForPackagePaginator(ListDomainsForPackageRequest.builder().applyMutation(listDomainsForPackageRequest)
                .build());
    }

    /**
     * Invokes the ListInstanceTypeDetails operation asynchronously.
     *
     * @param listInstanceTypeDetailsRequest
     * @return A Java Future containing the result of the ListInstanceTypeDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default CompletableFuture<ListInstanceTypeDetailsResponse> listInstanceTypeDetails(
            ListInstanceTypeDetailsRequest listInstanceTypeDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ListInstanceTypeDetails operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypeDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceTypeDetailsRequest#builder()}
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceTypeDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInstanceTypeDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default CompletableFuture<ListInstanceTypeDetailsResponse> listInstanceTypeDetails(
            Consumer<ListInstanceTypeDetailsRequest.Builder> listInstanceTypeDetailsRequest) {
        return listInstanceTypeDetails(ListInstanceTypeDetailsRequest.builder().applyMutation(listInstanceTypeDetailsRequest)
                .build());
    }

    /**
     * Invokes the ListInstanceTypeDetails operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default ListInstanceTypeDetailsPublisher listInstanceTypeDetailsPaginator(
            ListInstanceTypeDetailsRequest listInstanceTypeDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ListInstanceTypeDetails operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypeDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceTypeDetailsRequest#builder()}
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceTypeDetailsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default ListInstanceTypeDetailsPublisher listInstanceTypeDetailsPaginator(
            Consumer<ListInstanceTypeDetailsRequest.Builder> listInstanceTypeDetailsRequest) {
        return listInstanceTypeDetailsPaginator(ListInstanceTypeDetailsRequest.builder()
                .applyMutation(listInstanceTypeDetailsRequest).build());
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for the request parameters to the <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A Java Future containing the result of the ListPackagesForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default CompletableFuture<ListPackagesForDomainResponse> listPackagesForDomain(
            ListPackagesForDomainRequest listPackagesForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagesForDomainRequest#builder()}
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagesForDomainRequest.Builder} to create a
     *        request. Container for the request parameters to the <code> <a>ListPackagesForDomain</a> </code>
     *        operation.
     * @return A Java Future containing the result of the ListPackagesForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default CompletableFuture<ListPackagesForDomainResponse> listPackagesForDomain(
            Consumer<ListPackagesForDomainRequest.Builder> listPackagesForDomainRequest) {
        return listPackagesForDomain(ListPackagesForDomainRequest.builder().applyMutation(listPackagesForDomainRequest).build());
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for the request parameters to the <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default ListPackagesForDomainPublisher listPackagesForDomainPaginator(
            ListPackagesForDomainRequest listPackagesForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagesForDomainRequest#builder()}
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagesForDomainRequest.Builder} to create a
     *        request. Container for the request parameters to the <code> <a>ListPackagesForDomain</a> </code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default ListPackagesForDomainPublisher listPackagesForDomainPaginator(
            Consumer<ListPackagesForDomainRequest.Builder> listPackagesForDomainRequest) {
        return listPackagesForDomainPaginator(ListPackagesForDomainRequest.builder().applyMutation(listPackagesForDomainRequest)
                .build());
    }

    /**
     * <p>
     * Returns all tags for the given domain.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code> <a>ListTags</a> </code> operation. Specify the <code>ARN</code>
     *        of the domain that the tags you want to view are attached to.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListTags
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all tags for the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>ListTags</a> </code> operation. Specify the <code>ARN</code>
     *        of the domain that the tags you want to view are attached to.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListTags
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * List all supported versions of OpenSearch and Elasticsearch.
     * </p>
     *
     * @param listVersionsRequest
     *        Container for the parameters to the <code> <a>ListVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, there are no more results to retrieve.
     *        </p>
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default CompletableFuture<ListVersionsResponse> listVersions(ListVersionsRequest listVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all supported versions of OpenSearch and Elasticsearch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListVersionsRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>ListVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, there are no more results to retrieve.
     *        </p>
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default CompletableFuture<ListVersionsResponse> listVersions(Consumer<ListVersionsRequest.Builder> listVersionsRequest) {
        return listVersions(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * <p>
     * List all supported versions of OpenSearch and Elasticsearch.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listVersionsRequest
     *        Container for the parameters to the <code> <a>ListVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, there are no more results to retrieve.
     *        </p>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default ListVersionsPublisher listVersionsPaginator(ListVersionsRequest listVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all supported versions of OpenSearch and Elasticsearch.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListVersionsRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>ListVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, there are no more results to retrieve.
     *        </p>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default ListVersionsPublisher listVersionsPaginator(Consumer<ListVersionsRequest.Builder> listVersionsRequest) {
        return listVersionsPaginator(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * <p>
     * Allows you to purchase reserved OpenSearch instances.
     * </p>
     *
     * @param purchaseReservedInstanceOfferingRequest
     *        Container for parameters to <code>PurchaseReservedInstanceOffering</code>
     * @return A Java Future containing the result of the PurchaseReservedInstanceOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.PurchaseReservedInstanceOffering
     */
    default CompletableFuture<PurchaseReservedInstanceOfferingResponse> purchaseReservedInstanceOffering(
            PurchaseReservedInstanceOfferingRequest purchaseReservedInstanceOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase reserved OpenSearch instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseReservedInstanceOfferingRequest.Builder}
     * avoiding the need to create one manually via {@link PurchaseReservedInstanceOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedInstanceOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseReservedInstanceOfferingRequest.Builder} to
     *        create a request. Container for parameters to <code>PurchaseReservedInstanceOffering</code>
     * @return A Java Future containing the result of the PurchaseReservedInstanceOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.PurchaseReservedInstanceOffering
     */
    default CompletableFuture<PurchaseReservedInstanceOfferingResponse> purchaseReservedInstanceOffering(
            Consumer<PurchaseReservedInstanceOfferingRequest.Builder> purchaseReservedInstanceOfferingRequest) {
        return purchaseReservedInstanceOffering(PurchaseReservedInstanceOfferingRequest.builder()
                .applyMutation(purchaseReservedInstanceOfferingRequest).build());
    }

    /**
     * <p>
     * Allows the remote domain owner to reject an inbound cross-cluster connection request.
     * </p>
     *
     * @param rejectInboundConnectionRequest
     *        Container for the parameters to the <code> <a>RejectInboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the RejectInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RejectInboundConnection
     */
    default CompletableFuture<RejectInboundConnectionResponse> rejectInboundConnection(
            RejectInboundConnectionRequest rejectInboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the remote domain owner to reject an inbound cross-cluster connection request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectInboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link RejectInboundConnectionRequest#builder()}
     * </p>
     *
     * @param rejectInboundConnectionRequest
     *        A {@link Consumer} that will call methods on {@link RejectInboundConnectionRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>RejectInboundConnection</a> </code> operation.
     * @return A Java Future containing the result of the RejectInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RejectInboundConnection
     */
    default CompletableFuture<RejectInboundConnectionResponse> rejectInboundConnection(
            Consumer<RejectInboundConnectionRequest.Builder> rejectInboundConnectionRequest) {
        return rejectInboundConnection(RejectInboundConnectionRequest.builder().applyMutation(rejectInboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Removes the specified set of tags from the given domain.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the parameters to the <code> <a>RemoveTags</a> </code> operation. Specify the
     *        <code>ARN</code> for the domain from which you want to remove the specified <code>TagKey</code>.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RemoveTags
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified set of tags from the given domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code> <a>RemoveTags</a> </code> operation. Specify the
     *        <code>ARN</code> for the domain from which you want to remove the specified <code>TagKey</code>.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RemoveTags
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param startServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code> <a>StartServiceSoftwareUpdate</a> </code> operation. Specifies
     *        the name of the domain to schedule a service software update for.
     * @return A Java Future containing the result of the StartServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.StartServiceSoftwareUpdate
     */
    default CompletableFuture<StartServiceSoftwareUpdateResponse> startServiceSoftwareUpdate(
            StartServiceSoftwareUpdateRequest startServiceSoftwareUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartServiceSoftwareUpdateRequest.Builder} avoiding
     * the need to create one manually via {@link StartServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param startServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on {@link StartServiceSoftwareUpdateRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>StartServiceSoftwareUpdate</a> </code> operation.
     *        Specifies the name of the domain to schedule a service software update for.
     * @return A Java Future containing the result of the StartServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.StartServiceSoftwareUpdate
     */
    default CompletableFuture<StartServiceSoftwareUpdateResponse> startServiceSoftwareUpdate(
            Consumer<StartServiceSoftwareUpdateRequest.Builder> startServiceSoftwareUpdateRequest) {
        return startServiceSoftwareUpdate(StartServiceSoftwareUpdateRequest.builder()
                .applyMutation(startServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of
     * instances.
     * </p>
     *
     * @param updateDomainConfigRequest
     *        Container for the parameters to the <code> <a>UpdateDomain</a> </code> operation. Specifies the type and
     *        number of instances in the domain cluster.
     * @return A Java Future containing the result of the UpdateDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateDomainConfig
     */
    default CompletableFuture<UpdateDomainConfigResponse> updateDomainConfig(UpdateDomainConfigRequest updateDomainConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of
     * instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainConfigRequest#builder()}
     * </p>
     *
     * @param updateDomainConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainConfigRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>UpdateDomain</a> </code> operation. Specifies the
     *        type and number of instances in the domain cluster.
     * @return A Java Future containing the result of the UpdateDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateDomainConfig
     */
    default CompletableFuture<UpdateDomainConfigResponse> updateDomainConfig(
            Consumer<UpdateDomainConfigRequest.Builder> updateDomainConfigRequest) {
        return updateDomainConfig(UpdateDomainConfigRequest.builder().applyMutation(updateDomainConfigRequest).build());
    }

    /**
     * <p>
     * Updates a package for use with Amazon OpenSearch Service domains.
     * </p>
     *
     * @param updatePackageRequest
     *        Container for request parameters to the <code> <a>UpdatePackage</a> </code> operation.
     * @return A Java Future containing the result of the UpdatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdatePackage
     */
    default CompletableFuture<UpdatePackageResponse> updatePackage(UpdatePackageRequest updatePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a package for use with Amazon OpenSearch Service domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePackageRequest#builder()}
     * </p>
     *
     * @param updatePackageRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePackageRequest.Builder} to create a request.
     *        Container for request parameters to the <code> <a>UpdatePackage</a> </code> operation.
     * @return A Java Future containing the result of the UpdatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdatePackage
     */
    default CompletableFuture<UpdatePackageResponse> updatePackage(Consumer<UpdatePackageRequest.Builder> updatePackageRequest) {
        return updatePackage(UpdatePackageRequest.builder().applyMutation(updatePackageRequest).build());
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of
     * OpenSearch or Elasticsearch.
     * </p>
     *
     * @param upgradeDomainRequest
     *        Container for the request parameters to <code> <a>UpgradeDomain</a> </code> operation.
     * @return A Java Future containing the result of the UpgradeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpgradeDomain
     */
    default CompletableFuture<UpgradeDomainResponse> upgradeDomain(UpgradeDomainRequest upgradeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of
     * OpenSearch or Elasticsearch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpgradeDomainRequest#builder()}
     * </p>
     *
     * @param upgradeDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpgradeDomainRequest.Builder} to create a request.
     *        Container for the request parameters to <code> <a>UpgradeDomain</a> </code> operation.
     * @return A Java Future containing the result of the UpgradeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpgradeDomain
     */
    default CompletableFuture<UpgradeDomainResponse> upgradeDomain(Consumer<UpgradeDomainRequest.Builder> upgradeDomainRequest) {
        return upgradeDomain(UpgradeDomainRequest.builder().applyMutation(upgradeDomainRequest).build());
    }
}
