/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the Cognito options for the specified domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoOptionsStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CognitoOptionsStatus.Builder, CognitoOptionsStatus> {
    private static final SdkField<CognitoOptions> OPTIONS_FIELD = SdkField.<CognitoOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(CognitoOptionsStatus::options)).setter(setter(Builder::options))
            .constructor(CognitoOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.<OptionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(CognitoOptionsStatus::status)).setter(setter(Builder::status))
            .constructor(OptionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CognitoOptions options;

    private final OptionStatus status;

    private CognitoOptionsStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    /**
     * <p>
     * Cognito options for the specified domain.
     * </p>
     * 
     * @return Cognito options for the specified domain.
     */
    public final CognitoOptions options() {
        return options;
    }

    /**
     * <p>
     * The status of the Cognito options for the specified domain.
     * </p>
     * 
     * @return The status of the Cognito options for the specified domain.
     */
    public final OptionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoOptionsStatus)) {
            return false;
        }
        CognitoOptionsStatus other = (CognitoOptionsStatus) obj;
        return Objects.equals(options(), other.options()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CognitoOptionsStatus").add("Options", options()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoOptionsStatus, T> g) {
        return obj -> g.apply((CognitoOptionsStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoOptionsStatus> {
        /**
         * <p>
         * Cognito options for the specified domain.
         * </p>
         * 
         * @param options
         *        Cognito options for the specified domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(CognitoOptions options);

        /**
         * <p>
         * Cognito options for the specified domain.
         * </p>
         * This is a convenience that creates an instance of the {@link CognitoOptions.Builder} avoiding the need to
         * create one manually via {@link CognitoOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CognitoOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #options(CognitoOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link CognitoOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(CognitoOptions)
         */
        default Builder options(Consumer<CognitoOptions.Builder> options) {
            return options(CognitoOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The status of the Cognito options for the specified domain.
         * </p>
         * 
         * @param status
         *        The status of the Cognito options for the specified domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OptionStatus status);

        /**
         * <p>
         * The status of the Cognito options for the specified domain.
         * </p>
         * This is a convenience that creates an instance of the {@link OptionStatus.Builder} avoiding the need to
         * create one manually via {@link OptionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link OptionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(OptionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link OptionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(OptionStatus)
         */
        default Builder status(Consumer<OptionStatus.Builder> status) {
            return status(OptionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CognitoOptions options;

        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoOptionsStatus model) {
            options(model.options);
            status(model.status);
        }

        public final CognitoOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(CognitoOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(CognitoOptions options) {
            this.options = options;
            return this;
        }

        public final OptionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public CognitoOptionsStatus build() {
            return new CognitoOptionsStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
