/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeDomainConfig</code> request. Contains the configuration information of the requested
 * domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainConfigResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeDomainConfigResponse.Builder, DescribeDomainConfigResponse> {
    private static final SdkField<DomainConfig> DOMAIN_CONFIG_FIELD = SdkField.<DomainConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DomainConfig").getter(getter(DescribeDomainConfigResponse::domainConfig))
            .setter(setter(Builder::domainConfig)).constructor(DomainConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIG_FIELD));

    private final DomainConfig domainConfig;

    private DescribeDomainConfigResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfig = builder.domainConfig;
    }

    /**
     * <p>
     * The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
     * </p>
     * 
     * @return The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
     */
    public final DomainConfig domainConfig() {
        return domainConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainConfigResponse)) {
            return false;
        }
        DescribeDomainConfigResponse other = (DescribeDomainConfigResponse) obj;
        return Objects.equals(domainConfig(), other.domainConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainConfigResponse").add("DomainConfig", domainConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainConfig":
            return Optional.ofNullable(clazz.cast(domainConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainConfigResponse, T> g) {
        return obj -> g.apply((DescribeDomainConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainConfigResponse> {
        /**
         * <p>
         * The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
         * </p>
         * 
         * @param domainConfig
         *        The configuration information of the domain requested in the <code>DescribeDomainConfig</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfig(DomainConfig domainConfig);

        /**
         * <p>
         * The configuration information of the domain requested in the <code>DescribeDomainConfig</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainConfig.Builder} avoiding the need to
         * create one manually via {@link DomainConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #domainConfig(DomainConfig)}.
         * 
         * @param domainConfig
         *        a consumer that will call methods on {@link DomainConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainConfig(DomainConfig)
         */
        default Builder domainConfig(Consumer<DomainConfig.Builder> domainConfig) {
            return domainConfig(DomainConfig.builder().applyMutation(domainConfig).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private DomainConfig domainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainConfigResponse model) {
            super(model);
            domainConfig(model.domainConfig);
        }

        public final DomainConfig.Builder getDomainConfig() {
            return domainConfig != null ? domainConfig.toBuilder() : null;
        }

        public final void setDomainConfig(DomainConfig.BuilderImpl domainConfig) {
            this.domainConfig = domainConfig != null ? domainConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder domainConfig(DomainConfig domainConfig) {
            this.domainConfig = domainConfig;
            return this;
        }

        @Override
        public DescribeDomainConfigResponse build() {
            return new DescribeDomainConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
