/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainStatus implements SdkPojo, Serializable, ToCopyableBuilder<DomainStatus.Builder, DomainStatus> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DomainStatus::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DomainStatus::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(DomainStatus::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<Boolean> CREATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Created").getter(getter(DomainStatus::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Deleted").getter(getter(DomainStatus::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(DomainStatus::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Endpoints")
            .getter(getter(DomainStatus::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> PROCESSING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Processing").getter(getter(DomainStatus::processing)).setter(setter(Builder::processing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processing").build()).build();

    private static final SdkField<Boolean> UPGRADE_PROCESSING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UpgradeProcessing").getter(getter(DomainStatus::upgradeProcessing))
            .setter(setter(Builder::upgradeProcessing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeProcessing").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DomainStatus::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<ClusterConfig> CLUSTER_CONFIG_FIELD = SdkField
            .<ClusterConfig> builder(MarshallingType.SDK_POJO).memberName("ClusterConfig")
            .getter(getter(DomainStatus::clusterConfig)).setter(setter(Builder::clusterConfig))
            .constructor(ClusterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()).build();

    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.<EBSOptions> builder(MarshallingType.SDK_POJO)
            .memberName("EBSOptions").getter(getter(DomainStatus::ebsOptions)).setter(setter(Builder::ebsOptions))
            .constructor(EBSOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()).build();

    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPolicies").getter(getter(DomainStatus::accessPolicies)).setter(setter(Builder::accessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField
            .<SnapshotOptions> builder(MarshallingType.SDK_POJO).memberName("SnapshotOptions")
            .getter(getter(DomainStatus::snapshotOptions)).setter(setter(Builder::snapshotOptions))
            .constructor(SnapshotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()).build();

    private static final SdkField<VPCDerivedInfo> VPC_OPTIONS_FIELD = SdkField.<VPCDerivedInfo> builder(MarshallingType.SDK_POJO)
            .memberName("VPCOptions").getter(getter(DomainStatus::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCDerivedInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()).build();

    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField
            .<CognitoOptions> builder(MarshallingType.SDK_POJO).memberName("CognitoOptions")
            .getter(getter(DomainStatus::cognitoOptions)).setter(setter(Builder::cognitoOptions))
            .constructor(CognitoOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()).build();

    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<EncryptionAtRestOptions> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions")
            .getter(getter(DomainStatus::encryptionAtRestOptions)).setter(setter(Builder::encryptionAtRestOptions))
            .constructor(EncryptionAtRestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<NodeToNodeEncryptionOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NodeToNodeEncryptionOptions")
            .getter(getter(DomainStatus::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(NodeToNodeEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdvancedOptions")
            .getter(getter(DomainStatus::advancedOptions))
            .setter(setter(Builder::advancedOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<Map<String, LogPublishingOption>> builder(MarshallingType.MAP)
            .memberName("LogPublishingOptions")
            .getter(getter(DomainStatus::logPublishingOptionsAsStrings))
            .setter(setter(Builder::logPublishingOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogPublishingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogPublishingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ServiceSoftwareOptions> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField
            .<ServiceSoftwareOptions> builder(MarshallingType.SDK_POJO).memberName("ServiceSoftwareOptions")
            .getter(getter(DomainStatus::serviceSoftwareOptions)).setter(setter(Builder::serviceSoftwareOptions))
            .constructor(ServiceSoftwareOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build())
            .build();

    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<DomainEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(DomainStatus::domainEndpointOptions)).setter(setter(Builder::domainEndpointOptions))
            .constructor(DomainEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<AdvancedSecurityOptions> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField
            .<AdvancedSecurityOptions> builder(MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions")
            .getter(getter(DomainStatus::advancedSecurityOptions)).setter(setter(Builder::advancedSecurityOptions))
            .constructor(AdvancedSecurityOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build())
            .build();

    private static final SdkField<AutoTuneOptionsOutput> AUTO_TUNE_OPTIONS_FIELD = SdkField
            .<AutoTuneOptionsOutput> builder(MarshallingType.SDK_POJO).memberName("AutoTuneOptions")
            .getter(getter(DomainStatus::autoTuneOptions)).setter(setter(Builder::autoTuneOptions))
            .constructor(AutoTuneOptionsOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            DOMAIN_NAME_FIELD, ARN_FIELD, CREATED_FIELD, DELETED_FIELD, ENDPOINT_FIELD, ENDPOINTS_FIELD, PROCESSING_FIELD,
            UPGRADE_PROCESSING_FIELD, ENGINE_VERSION_FIELD, CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD,
            SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD,
            NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD,
            SERVICE_SOFTWARE_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD,
            AUTO_TUNE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainId;

    private final String domainName;

    private final String arn;

    private final Boolean created;

    private final Boolean deleted;

    private final String endpoint;

    private final Map<String, String> endpoints;

    private final Boolean processing;

    private final Boolean upgradeProcessing;

    private final String engineVersion;

    private final ClusterConfig clusterConfig;

    private final EBSOptions ebsOptions;

    private final String accessPolicies;

    private final SnapshotOptions snapshotOptions;

    private final VPCDerivedInfo vpcOptions;

    private final CognitoOptions cognitoOptions;

    private final EncryptionAtRestOptions encryptionAtRestOptions;

    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

    private final Map<String, String> advancedOptions;

    private final Map<String, LogPublishingOption> logPublishingOptions;

    private final ServiceSoftwareOptions serviceSoftwareOptions;

    private final DomainEndpointOptions domainEndpointOptions;

    private final AdvancedSecurityOptions advancedSecurityOptions;

    private final AutoTuneOptionsOutput autoTuneOptions;

    private DomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.processing = builder.processing;
        this.upgradeProcessing = builder.upgradeProcessing;
        this.engineVersion = builder.engineVersion;
        this.clusterConfig = builder.clusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
    }

    /**
     * <p>
     * The unique identifier for the specified domain.
     * </p>
     * 
     * @return The unique identifier for the specified domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain
     * names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and -
     * (hyphen).
     * </p>
     * 
     * @return The name of a domain. Domain names are unique across the domains owned by an account within an AWS
     *         region. Domain names start with a letter or number and can contain the following characters: a-z
     *         (lowercase), 0-9, and - (hyphen).
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a domain. See <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html" target="_blank">IAM
     * identifiers </a> in the <i>AWS Identity and Access Management User Guide</i> for more information.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a domain. See <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html" target="_blank">IAM
     *         identifiers </a> in the <i>AWS Identity and Access Management User Guide</i> for more information.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The domain creation status. <code>True</code> if the creation of a domain is complete. <code> False </code> if
     * domain creation is still in progress.
     * </p>
     * 
     * @return The domain creation status. <code>True</code> if the creation of a domain is complete.
     *         <code> False </code> if domain creation is still in progress.
     */
    public final Boolean created() {
        return created;
    }

    /**
     * <p>
     * The domain deletion status. <code>True</code> if a delete request has been received for the domain but resource
     * cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain deletion is
     * complete, the status of the domain is no longer returned.
     * </p>
     * 
     * @return The domain deletion status. <code>True</code> if a delete request has been received for the domain but
     *         resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain
     *         deletion is complete, the status of the domain is no longer returned.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * The domain endpoint that you use to submit index and search requests.
     * </p>
     * 
     * @return The domain endpoint that you use to submit index and search requests.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map containing the domain endpoints used to submit index and search requests. Example <code>key, value</code>:
     * <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return Map containing the domain endpoints used to submit index and search requests. Example
     *         <code>key, value</code>:
     *         <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.
     */
    public final Map<String, String> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * The status of the domain configuration. <code>True</code> if Amazon OpenSearch Service is processing
     * configuration changes. <code>False</code> if the configuration is active.
     * </p>
     * 
     * @return The status of the domain configuration. <code>True</code> if Amazon OpenSearch Service is processing
     *         configuration changes. <code>False</code> if the configuration is active.
     */
    public final Boolean processing() {
        return processing;
    }

    /**
     * <p>
     * The status of a domain version upgrade. <code>True</code> if Amazon OpenSearch Service is undergoing a version
     * upgrade. <code>False</code> if the configuration is active.
     * </p>
     * 
     * @return The status of a domain version upgrade. <code>True</code> if Amazon OpenSearch Service is undergoing a
     *         version upgrade. <code>False</code> if the configuration is active.
     */
    public final Boolean upgradeProcessing() {
        return upgradeProcessing;
    }

    /**
     * Returns the value of the EngineVersion property for this object.
     * 
     * @return The value of the EngineVersion property for this object.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The type and number of instances in the domain.
     * </p>
     * 
     * @return The type and number of instances in the domain.
     */
    public final ClusterConfig clusterConfig() {
        return clusterConfig;
    }

    /**
     * <p>
     * The <code>EBSOptions</code> for the specified domain.
     * </p>
     * 
     * @return The <code>EBSOptions</code> for the specified domain.
     */
    public final EBSOptions ebsOptions() {
        return ebsOptions;
    }

    /**
     * <p>
     * IAM access policy as a JSON-formatted string.
     * </p>
     * 
     * @return IAM access policy as a JSON-formatted string.
     */
    public final String accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * The status of the <code>SnapshotOptions</code>.
     * </p>
     * 
     * @return The status of the <code>SnapshotOptions</code>.
     */
    public final SnapshotOptions snapshotOptions() {
        return snapshotOptions;
    }

    /**
     * <p>
     * The <code>VPCOptions</code> for the specified domain. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank"> Launching
     * your Amazon OpenSearch Service domains using a VPC</a>.
     * </p>
     * 
     * @return The <code>VPCOptions</code> for the specified domain. For more information, see <a
     *         href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">
     *         Launching your Amazon OpenSearch Service domains using a VPC</a>.
     */
    public final VPCDerivedInfo vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * The <code>CognitoOptions</code> for the specified domain. For more information, see <a
     * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     * </p>
     * 
     * @return The <code>CognitoOptions</code> for the specified domain. For more information, see <a
     *         href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
     *         target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
     */
    public final CognitoOptions cognitoOptions() {
        return cognitoOptions;
    }

    /**
     * <p>
     * The status of the <code>EncryptionAtRestOptions</code>.
     * </p>
     * 
     * @return The status of the <code>EncryptionAtRestOptions</code>.
     */
    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * The status of the <code>NodeToNodeEncryptionOptions</code>.
     * </p>
     * 
     * @return The status of the <code>NodeToNodeEncryptionOptions</code>.
     */
    public final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdvancedOptions() {
        return advancedOptions != null && !(advancedOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The status of the <code>AdvancedOptions</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedOptions} method.
     * </p>
     * 
     * @return The status of the <code>AdvancedOptions</code>.
     */
    public final Map<String, String> advancedOptions() {
        return advancedOptions;
    }

    /**
     * <p>
     * Log publishing options for the given domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPublishingOptions} method.
     * </p>
     * 
     * @return Log publishing options for the given domain.
     */
    public final Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(logPublishingOptions);
    }

    /**
     * For responses, this returns true if the service returned a value for the LogPublishingOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogPublishingOptions() {
        return logPublishingOptions != null && !(logPublishingOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Log publishing options for the given domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPublishingOptions} method.
     * </p>
     * 
     * @return Log publishing options for the given domain.
     */
    public final Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * The current status of the domain's service software.
     * </p>
     * 
     * @return The current status of the domain's service software.
     */
    public final ServiceSoftwareOptions serviceSoftwareOptions() {
        return serviceSoftwareOptions;
    }

    /**
     * <p>
     * The current status of the domain's endpoint options.
     * </p>
     * 
     * @return The current status of the domain's endpoint options.
     */
    public final DomainEndpointOptions domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * The current status of the domain's advanced security options.
     * </p>
     * 
     * @return The current status of the domain's advanced security options.
     */
    public final AdvancedSecurityOptions advancedSecurityOptions() {
        return advancedSecurityOptions;
    }

    /**
     * <p>
     * The current status of the domain's Auto-Tune options.
     * </p>
     * 
     * @return The current status of the domain's Auto-Tune options.
     */
    public final AutoTuneOptionsOutput autoTuneOptions() {
        return autoTuneOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(processing());
        hashCode = 31 * hashCode + Objects.hashCode(upgradeProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedOptions() ? advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogPublishingOptions() ? logPublishingOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(autoTuneOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStatus)) {
            return false;
        }
        DomainStatus other = (DomainStatus) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(created(), other.created())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(endpoint(), other.endpoint())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(processing(), other.processing())
                && Objects.equals(upgradeProcessing(), other.upgradeProcessing())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(clusterConfig(), other.clusterConfig()) && Objects.equals(ebsOptions(), other.ebsOptions())
                && Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(snapshotOptions(), other.snapshotOptions()) && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(cognitoOptions(), other.cognitoOptions())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && hasAdvancedOptions() == other.hasAdvancedOptions()
                && Objects.equals(advancedOptions(), other.advancedOptions())
                && hasLogPublishingOptions() == other.hasLogPublishingOptions()
                && Objects.equals(logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings())
                && Objects.equals(serviceSoftwareOptions(), other.serviceSoftwareOptions())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(advancedSecurityOptions(), other.advancedSecurityOptions())
                && Objects.equals(autoTuneOptions(), other.autoTuneOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainStatus").add("DomainId", domainId()).add("DomainName", domainName()).add("ARN", arn())
                .add("Created", created()).add("Deleted", deleted()).add("Endpoint", endpoint())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("Processing", processing())
                .add("UpgradeProcessing", upgradeProcessing()).add("EngineVersion", engineVersion())
                .add("ClusterConfig", clusterConfig()).add("EBSOptions", ebsOptions()).add("AccessPolicies", accessPolicies())
                .add("SnapshotOptions", snapshotOptions()).add("VPCOptions", vpcOptions())
                .add("CognitoOptions", cognitoOptions()).add("EncryptionAtRestOptions", encryptionAtRestOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions())
                .add("AdvancedOptions", hasAdvancedOptions() ? advancedOptions() : null)
                .add("LogPublishingOptions", hasLogPublishingOptions() ? logPublishingOptionsAsStrings() : null)
                .add("ServiceSoftwareOptions", serviceSoftwareOptions()).add("DomainEndpointOptions", domainEndpointOptions())
                .add("AdvancedSecurityOptions", advancedSecurityOptions()).add("AutoTuneOptions", autoTuneOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "Processing":
            return Optional.ofNullable(clazz.cast(processing()));
        case "UpgradeProcessing":
            return Optional.ofNullable(clazz.cast(upgradeProcessing()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "ClusterConfig":
            return Optional.ofNullable(clazz.cast(clusterConfig()));
        case "EBSOptions":
            return Optional.ofNullable(clazz.cast(ebsOptions()));
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "SnapshotOptions":
            return Optional.ofNullable(clazz.cast(snapshotOptions()));
        case "VPCOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "CognitoOptions":
            return Optional.ofNullable(clazz.cast(cognitoOptions()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "AdvancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptionsAsStrings()));
        case "ServiceSoftwareOptions":
            return Optional.ofNullable(clazz.cast(serviceSoftwareOptions()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "AdvancedSecurityOptions":
            return Optional.ofNullable(clazz.cast(advancedSecurityOptions()));
        case "AutoTuneOptions":
            return Optional.ofNullable(clazz.cast(autoTuneOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainStatus, T> g) {
        return obj -> g.apply((DomainStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainStatus> {
        /**
         * <p>
         * The unique identifier for the specified domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier for the specified domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of a domain. Domain names are unique across the domains owned by an account within an AWS region.
         * Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9,
         * and - (hyphen).
         * </p>
         * 
         * @param domainName
         *        The name of a domain. Domain names are unique across the domains owned by an account within an AWS
         *        region. Domain names start with a letter or number and can contain the following characters: a-z
         *        (lowercase), 0-9, and - (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a domain. See <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html" target="_blank">IAM
         * identifiers </a> in the <i>AWS Identity and Access Management User Guide</i> for more information.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of a domain. See <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html" target="_blank">IAM
         *        identifiers </a> in the <i>AWS Identity and Access Management User Guide</i> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The domain creation status. <code>True</code> if the creation of a domain is complete. <code> False </code>
         * if domain creation is still in progress.
         * </p>
         * 
         * @param created
         *        The domain creation status. <code>True</code> if the creation of a domain is complete.
         *        <code> False </code> if domain creation is still in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Boolean created);

        /**
         * <p>
         * The domain deletion status. <code>True</code> if a delete request has been received for the domain but
         * resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once domain
         * deletion is complete, the status of the domain is no longer returned.
         * </p>
         * 
         * @param deleted
         *        The domain deletion status. <code>True</code> if a delete request has been received for the domain but
         *        resource cleanup is still in progress. <code>False</code> if the domain has not been deleted. Once
         *        domain deletion is complete, the status of the domain is no longer returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * The domain endpoint that you use to submit index and search requests.
         * </p>
         * 
         * @param endpoint
         *        The domain endpoint that you use to submit index and search requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Map containing the domain endpoints used to submit index and search requests. Example <code>key, value</code>: <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.
         * </p>
         * 
         * @param endpoints
         *        Map containing the domain endpoints used to submit index and search requests. Example
         *        <code>key, value</code>:
         *        <code>'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Map<String, String> endpoints);

        /**
         * <p>
         * The status of the domain configuration. <code>True</code> if Amazon OpenSearch Service is processing
         * configuration changes. <code>False</code> if the configuration is active.
         * </p>
         * 
         * @param processing
         *        The status of the domain configuration. <code>True</code> if Amazon OpenSearch Service is processing
         *        configuration changes. <code>False</code> if the configuration is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processing(Boolean processing);

        /**
         * <p>
         * The status of a domain version upgrade. <code>True</code> if Amazon OpenSearch Service is undergoing a
         * version upgrade. <code>False</code> if the configuration is active.
         * </p>
         * 
         * @param upgradeProcessing
         *        The status of a domain version upgrade. <code>True</code> if Amazon OpenSearch Service is undergoing a
         *        version upgrade. <code>False</code> if the configuration is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeProcessing(Boolean upgradeProcessing);

        /**
         * Sets the value of the EngineVersion property for this object.
         *
         * @param engineVersion
         *        The new value for the EngineVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The type and number of instances in the domain.
         * </p>
         * 
         * @param clusterConfig
         *        The type and number of instances in the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterConfig(ClusterConfig clusterConfig);

        /**
         * <p>
         * The type and number of instances in the domain.
         * </p>
         * This is a convenience that creates an instance of the {@link ClusterConfig.Builder} avoiding the need to
         * create one manually via {@link ClusterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterConfig(ClusterConfig)}.
         * 
         * @param clusterConfig
         *        a consumer that will call methods on {@link ClusterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterConfig(ClusterConfig)
         */
        default Builder clusterConfig(Consumer<ClusterConfig.Builder> clusterConfig) {
            return clusterConfig(ClusterConfig.builder().applyMutation(clusterConfig).build());
        }

        /**
         * <p>
         * The <code>EBSOptions</code> for the specified domain.
         * </p>
         * 
         * @param ebsOptions
         *        The <code>EBSOptions</code> for the specified domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptions(EBSOptions ebsOptions);

        /**
         * <p>
         * The <code>EBSOptions</code> for the specified domain.
         * </p>
         * This is a convenience that creates an instance of the {@link EBSOptions.Builder} avoiding the need to create
         * one manually via {@link EBSOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EBSOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #ebsOptions(EBSOptions)}.
         * 
         * @param ebsOptions
         *        a consumer that will call methods on {@link EBSOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsOptions(EBSOptions)
         */
        default Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return ebsOptions(EBSOptions.builder().applyMutation(ebsOptions).build());
        }

        /**
         * <p>
         * IAM access policy as a JSON-formatted string.
         * </p>
         * 
         * @param accessPolicies
         *        IAM access policy as a JSON-formatted string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(String accessPolicies);

        /**
         * <p>
         * The status of the <code>SnapshotOptions</code>.
         * </p>
         * 
         * @param snapshotOptions
         *        The status of the <code>SnapshotOptions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotOptions(SnapshotOptions snapshotOptions);

        /**
         * <p>
         * The status of the <code>SnapshotOptions</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link SnapshotOptions.Builder} avoiding the need to
         * create one manually via {@link SnapshotOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnapshotOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotOptions(SnapshotOptions)}.
         * 
         * @param snapshotOptions
         *        a consumer that will call methods on {@link SnapshotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotOptions(SnapshotOptions)
         */
        default Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return snapshotOptions(SnapshotOptions.builder().applyMutation(snapshotOptions).build());
        }

        /**
         * <p>
         * The <code>VPCOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">
         * Launching your Amazon OpenSearch Service domains using a VPC</a>.
         * </p>
         * 
         * @param vpcOptions
         *        The <code>VPCOptions</code> for the specified domain. For more information, see <a
         *        href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">
         *        Launching your Amazon OpenSearch Service domains using a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCDerivedInfo vpcOptions);

        /**
         * <p>
         * The <code>VPCOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html" target="_blank">
         * Launching your Amazon OpenSearch Service domains using a VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VPCDerivedInfo.Builder} avoiding the need to
         * create one manually via {@link VPCDerivedInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPCDerivedInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcOptions(VPCDerivedInfo)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCDerivedInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCDerivedInfo)
         */
        default Builder vpcOptions(Consumer<VPCDerivedInfo.Builder> vpcOptions) {
            return vpcOptions(VPCDerivedInfo.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * The <code>CognitoOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
         * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
         * </p>
         * 
         * @param cognitoOptions
         *        The <code>CognitoOptions</code> for the specified domain. For more information, see <a
         *        href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
         *        target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoOptions(CognitoOptions cognitoOptions);

        /**
         * <p>
         * The <code>CognitoOptions</code> for the specified domain. For more information, see <a
         * href="http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
         * target="_blank">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link CognitoOptions.Builder} avoiding the need to
         * create one manually via {@link CognitoOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CognitoOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #cognitoOptions(CognitoOptions)}.
         * 
         * @param cognitoOptions
         *        a consumer that will call methods on {@link CognitoOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoOptions(CognitoOptions)
         */
        default Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return cognitoOptions(CognitoOptions.builder().applyMutation(cognitoOptions).build());
        }

        /**
         * <p>
         * The status of the <code>EncryptionAtRestOptions</code>.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        The status of the <code>EncryptionAtRestOptions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions);

        /**
         * <p>
         * The status of the <code>EncryptionAtRestOptions</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionAtRestOptions.Builder} avoiding the
         * need to create one manually via {@link EncryptionAtRestOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionAtRestOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionAtRestOptions(EncryptionAtRestOptions)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link EncryptionAtRestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(EncryptionAtRestOptions)
         */
        default Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * The status of the <code>NodeToNodeEncryptionOptions</code>.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        The status of the <code>NodeToNodeEncryptionOptions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions);

        /**
         * <p>
         * The status of the <code>NodeToNodeEncryptionOptions</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeToNodeEncryptionOptions.Builder} avoiding
         * the need to create one manually via {@link NodeToNodeEncryptionOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeToNodeEncryptionOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on {@link NodeToNodeEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions)
         */
        default Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)
                    .build());
        }

        /**
         * <p>
         * The status of the <code>AdvancedOptions</code>.
         * </p>
         * 
         * @param advancedOptions
         *        The status of the <code>AdvancedOptions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(Map<String, String> advancedOptions);

        /**
         * <p>
         * Log publishing options for the given domain.
         * </p>
         * 
         * @param logPublishingOptions
         *        Log publishing options for the given domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions);

        /**
         * <p>
         * Log publishing options for the given domain.
         * </p>
         * 
         * @param logPublishingOptions
         *        Log publishing options for the given domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions);

        /**
         * <p>
         * The current status of the domain's service software.
         * </p>
         * 
         * @param serviceSoftwareOptions
         *        The current status of the domain's service software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions);

        /**
         * <p>
         * The current status of the domain's service software.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceSoftwareOptions.Builder} avoiding the
         * need to create one manually via {@link ServiceSoftwareOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceSoftwareOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceSoftwareOptions(ServiceSoftwareOptions)}.
         * 
         * @param serviceSoftwareOptions
         *        a consumer that will call methods on {@link ServiceSoftwareOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSoftwareOptions(ServiceSoftwareOptions)
         */
        default Builder serviceSoftwareOptions(Consumer<ServiceSoftwareOptions.Builder> serviceSoftwareOptions) {
            return serviceSoftwareOptions(ServiceSoftwareOptions.builder().applyMutation(serviceSoftwareOptions).build());
        }

        /**
         * <p>
         * The current status of the domain's endpoint options.
         * </p>
         * 
         * @param domainEndpointOptions
         *        The current status of the domain's endpoint options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions);

        /**
         * <p>
         * The current status of the domain's endpoint options.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainEndpointOptions.Builder} avoiding the need
         * to create one manually via {@link DomainEndpointOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainEndpointOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #domainEndpointOptions(DomainEndpointOptions)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link DomainEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(DomainEndpointOptions)
         */
        default Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return domainEndpointOptions(DomainEndpointOptions.builder().applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * The current status of the domain's advanced security options.
         * </p>
         * 
         * @param advancedSecurityOptions
         *        The current status of the domain's advanced security options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedSecurityOptions(AdvancedSecurityOptions advancedSecurityOptions);

        /**
         * <p>
         * The current status of the domain's advanced security options.
         * </p>
         * This is a convenience that creates an instance of the {@link AdvancedSecurityOptions.Builder} avoiding the
         * need to create one manually via {@link AdvancedSecurityOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AdvancedSecurityOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #advancedSecurityOptions(AdvancedSecurityOptions)}.
         * 
         * @param advancedSecurityOptions
         *        a consumer that will call methods on {@link AdvancedSecurityOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedSecurityOptions(AdvancedSecurityOptions)
         */
        default Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptions.Builder> advancedSecurityOptions) {
            return advancedSecurityOptions(AdvancedSecurityOptions.builder().applyMutation(advancedSecurityOptions).build());
        }

        /**
         * <p>
         * The current status of the domain's Auto-Tune options.
         * </p>
         * 
         * @param autoTuneOptions
         *        The current status of the domain's Auto-Tune options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTuneOptions(AutoTuneOptionsOutput autoTuneOptions);

        /**
         * <p>
         * The current status of the domain's Auto-Tune options.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoTuneOptionsOutput.Builder} avoiding the need
         * to create one manually via {@link AutoTuneOptionsOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoTuneOptionsOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #autoTuneOptions(AutoTuneOptionsOutput)}.
         * 
         * @param autoTuneOptions
         *        a consumer that will call methods on {@link AutoTuneOptionsOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTuneOptions(AutoTuneOptionsOutput)
         */
        default Builder autoTuneOptions(Consumer<AutoTuneOptionsOutput.Builder> autoTuneOptions) {
            return autoTuneOptions(AutoTuneOptionsOutput.builder().applyMutation(autoTuneOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainId;

        private String domainName;

        private String arn;

        private Boolean created;

        private Boolean deleted;

        private String endpoint;

        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();

        private Boolean processing;

        private Boolean upgradeProcessing;

        private String engineVersion;

        private ClusterConfig clusterConfig;

        private EBSOptions ebsOptions;

        private String accessPolicies;

        private SnapshotOptions snapshotOptions;

        private VPCDerivedInfo vpcOptions;

        private CognitoOptions cognitoOptions;

        private EncryptionAtRestOptions encryptionAtRestOptions;

        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();

        private ServiceSoftwareOptions serviceSoftwareOptions;

        private DomainEndpointOptions domainEndpointOptions;

        private AdvancedSecurityOptions advancedSecurityOptions;

        private AutoTuneOptionsOutput autoTuneOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStatus model) {
            domainId(model.domainId);
            domainName(model.domainName);
            arn(model.arn);
            created(model.created);
            deleted(model.deleted);
            endpoint(model.endpoint);
            endpoints(model.endpoints);
            processing(model.processing);
            upgradeProcessing(model.upgradeProcessing);
            engineVersion(model.engineVersion);
            clusterConfig(model.clusterConfig);
            ebsOptions(model.ebsOptions);
            accessPolicies(model.accessPolicies);
            snapshotOptions(model.snapshotOptions);
            vpcOptions(model.vpcOptions);
            cognitoOptions(model.cognitoOptions);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            advancedOptions(model.advancedOptions);
            logPublishingOptionsWithStrings(model.logPublishingOptions);
            serviceSoftwareOptions(model.serviceSoftwareOptions);
            domainEndpointOptions(model.domainEndpointOptions);
            advancedSecurityOptions(model.advancedSecurityOptions);
            autoTuneOptions(model.autoTuneOptions);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getCreated() {
            return created;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        @Transient
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Map<String, String> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return endpoints;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
        }

        @Override
        @Transient
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
            return this;
        }

        public final Boolean getProcessing() {
            return processing;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        @Override
        @Transient
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final Boolean getUpgradeProcessing() {
            return upgradeProcessing;
        }

        public final void setUpgradeProcessing(Boolean upgradeProcessing) {
            this.upgradeProcessing = upgradeProcessing;
        }

        @Override
        @Transient
        public final Builder upgradeProcessing(Boolean upgradeProcessing) {
            this.upgradeProcessing = upgradeProcessing;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ClusterConfig.Builder getClusterConfig() {
            return clusterConfig != null ? clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(ClusterConfig.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder clusterConfig(ClusterConfig clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return ebsOptions != null ? ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final String getAccessPolicies() {
            return accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        @Transient
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return snapshotOptions != null ? snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCDerivedInfo.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfo.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcOptions(VPCDerivedInfo vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return cognitoOptions != null ? cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        @Transient
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            Map<String, LogPublishingOption.Builder> result = LogPublishingOptionsCopier.copyToBuilder(this.logPublishingOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        @Override
        @Transient
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        @Transient
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final ServiceSoftwareOptions.Builder getServiceSoftwareOptions() {
            return serviceSoftwareOptions != null ? serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(ServiceSoftwareOptions.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptions.Builder getAdvancedSecurityOptions() {
            return advancedSecurityOptions != null ? advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptions.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder advancedSecurityOptions(AdvancedSecurityOptions advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final AutoTuneOptionsOutput.Builder getAutoTuneOptions() {
            return autoTuneOptions != null ? autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsOutput.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder autoTuneOptions(AutoTuneOptionsOutput autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        @Override
        public DomainStatus build() {
            return new DomainStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
