/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Limits for a given InstanceType and for each of its roles. <br/>
 * Limits contains the following: <code> <a>StorageTypes</a> </code>, <code> <a>InstanceLimits</a> </code>, and
 * <code> <a>AdditionalLimits</a> </code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Limits implements SdkPojo, Serializable, ToCopyableBuilder<Limits.Builder, Limits> {
    private static final SdkField<List<StorageType>> STORAGE_TYPES_FIELD = SdkField
            .<List<StorageType>> builder(MarshallingType.LIST)
            .memberName("StorageTypes")
            .getter(getter(Limits::storageTypes))
            .setter(setter(Builder::storageTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageType> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceLimits> INSTANCE_LIMITS_FIELD = SdkField
            .<InstanceLimits> builder(MarshallingType.SDK_POJO).memberName("InstanceLimits")
            .getter(getter(Limits::instanceLimits)).setter(setter(Builder::instanceLimits)).constructor(InstanceLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLimits").build()).build();

    private static final SdkField<List<AdditionalLimit>> ADDITIONAL_LIMITS_FIELD = SdkField
            .<List<AdditionalLimit>> builder(MarshallingType.LIST)
            .memberName("AdditionalLimits")
            .getter(getter(Limits::additionalLimits))
            .setter(setter(Builder::additionalLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPES_FIELD,
            INSTANCE_LIMITS_FIELD, ADDITIONAL_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StorageType> storageTypes;

    private final InstanceLimits instanceLimits;

    private final List<AdditionalLimit> additionalLimits;

    private Limits(BuilderImpl builder) {
        this.storageTypes = builder.storageTypes;
        this.instanceLimits = builder.instanceLimits;
        this.additionalLimits = builder.additionalLimits;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageTypes() {
        return storageTypes != null && !(storageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Storage-related types and attributes that are available for a given InstanceType.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageTypes} method.
     * </p>
     * 
     * @return Storage-related types and attributes that are available for a given InstanceType.
     */
    public final List<StorageType> storageTypes() {
        return storageTypes;
    }

    /**
     * Returns the value of the InstanceLimits property for this object.
     * 
     * @return The value of the InstanceLimits property for this object.
     */
    public final InstanceLimits instanceLimits() {
        return instanceLimits;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalLimits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalLimits() {
        return additionalLimits != null && !(additionalLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of additional limits that are specific to a given InstanceType and for each of its
     * <code> <a>InstanceRole</a> </code> .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalLimits} method.
     * </p>
     * 
     * @return List of additional limits that are specific to a given InstanceType and for each of its
     *         <code> <a>InstanceRole</a> </code> .
     */
    public final List<AdditionalLimit> additionalLimits() {
        return additionalLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageTypes() ? storageTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceLimits());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalLimits() ? additionalLimits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limits)) {
            return false;
        }
        Limits other = (Limits) obj;
        return hasStorageTypes() == other.hasStorageTypes() && Objects.equals(storageTypes(), other.storageTypes())
                && Objects.equals(instanceLimits(), other.instanceLimits())
                && hasAdditionalLimits() == other.hasAdditionalLimits()
                && Objects.equals(additionalLimits(), other.additionalLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Limits").add("StorageTypes", hasStorageTypes() ? storageTypes() : null)
                .add("InstanceLimits", instanceLimits())
                .add("AdditionalLimits", hasAdditionalLimits() ? additionalLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageTypes":
            return Optional.ofNullable(clazz.cast(storageTypes()));
        case "InstanceLimits":
            return Optional.ofNullable(clazz.cast(instanceLimits()));
        case "AdditionalLimits":
            return Optional.ofNullable(clazz.cast(additionalLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Limits, T> g) {
        return obj -> g.apply((Limits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Limits> {
        /**
         * <p>
         * Storage-related types and attributes that are available for a given InstanceType.
         * </p>
         * 
         * @param storageTypes
         *        Storage-related types and attributes that are available for a given InstanceType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageTypes(Collection<StorageType> storageTypes);

        /**
         * <p>
         * Storage-related types and attributes that are available for a given InstanceType.
         * </p>
         * 
         * @param storageTypes
         *        Storage-related types and attributes that are available for a given InstanceType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageTypes(StorageType... storageTypes);

        /**
         * <p>
         * Storage-related types and attributes that are available for a given InstanceType.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StorageType>.Builder} avoiding the need to
         * create one manually via {@link List<StorageType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageType>.Builder#build()} is called immediately and its
         * result is passed to {@link #storageTypes(List<StorageType>)}.
         * 
         * @param storageTypes
         *        a consumer that will call methods on {@link List<StorageType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageTypes(List<StorageType>)
         */
        Builder storageTypes(Consumer<StorageType.Builder>... storageTypes);

        /**
         * Sets the value of the InstanceLimits property for this object.
         *
         * @param instanceLimits
         *        The new value for the InstanceLimits property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceLimits(InstanceLimits instanceLimits);

        /**
         * Sets the value of the InstanceLimits property for this object.
         *
         * This is a convenience that creates an instance of the {@link InstanceLimits.Builder} avoiding the need to
         * create one manually via {@link InstanceLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceLimits(InstanceLimits)}.
         * 
         * @param instanceLimits
         *        a consumer that will call methods on {@link InstanceLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceLimits(InstanceLimits)
         */
        default Builder instanceLimits(Consumer<InstanceLimits.Builder> instanceLimits) {
            return instanceLimits(InstanceLimits.builder().applyMutation(instanceLimits).build());
        }

        /**
         * <p>
         * List of additional limits that are specific to a given InstanceType and for each of its
         * <code> <a>InstanceRole</a> </code> .
         * </p>
         * 
         * @param additionalLimits
         *        List of additional limits that are specific to a given InstanceType and for each of its
         *        <code> <a>InstanceRole</a> </code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLimits(Collection<AdditionalLimit> additionalLimits);

        /**
         * <p>
         * List of additional limits that are specific to a given InstanceType and for each of its
         * <code> <a>InstanceRole</a> </code> .
         * </p>
         * 
         * @param additionalLimits
         *        List of additional limits that are specific to a given InstanceType and for each of its
         *        <code> <a>InstanceRole</a> </code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalLimits(AdditionalLimit... additionalLimits);

        /**
         * <p>
         * List of additional limits that are specific to a given InstanceType and for each of its
         * <code> <a>InstanceRole</a> </code> .
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdditionalLimit>.Builder} avoiding the need
         * to create one manually via {@link List<AdditionalLimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalLimit>.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalLimits(List<AdditionalLimit>)}.
         * 
         * @param additionalLimits
         *        a consumer that will call methods on {@link List<AdditionalLimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalLimits(List<AdditionalLimit>)
         */
        Builder additionalLimits(Consumer<AdditionalLimit.Builder>... additionalLimits);
    }

    static final class BuilderImpl implements Builder {
        private List<StorageType> storageTypes = DefaultSdkAutoConstructList.getInstance();

        private InstanceLimits instanceLimits;

        private List<AdditionalLimit> additionalLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Limits model) {
            storageTypes(model.storageTypes);
            instanceLimits(model.instanceLimits);
            additionalLimits(model.additionalLimits);
        }

        public final List<StorageType.Builder> getStorageTypes() {
            List<StorageType.Builder> result = StorageTypeListCopier.copyToBuilder(this.storageTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageTypes(Collection<StorageType.BuilderImpl> storageTypes) {
            this.storageTypes = StorageTypeListCopier.copyFromBuilder(storageTypes);
        }

        @Override
        @Transient
        public final Builder storageTypes(Collection<StorageType> storageTypes) {
            this.storageTypes = StorageTypeListCopier.copy(storageTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storageTypes(StorageType... storageTypes) {
            storageTypes(Arrays.asList(storageTypes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storageTypes(Consumer<StorageType.Builder>... storageTypes) {
            storageTypes(Stream.of(storageTypes).map(c -> StorageType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceLimits.Builder getInstanceLimits() {
            return instanceLimits != null ? instanceLimits.toBuilder() : null;
        }

        public final void setInstanceLimits(InstanceLimits.BuilderImpl instanceLimits) {
            this.instanceLimits = instanceLimits != null ? instanceLimits.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceLimits(InstanceLimits instanceLimits) {
            this.instanceLimits = instanceLimits;
            return this;
        }

        public final List<AdditionalLimit.Builder> getAdditionalLimits() {
            List<AdditionalLimit.Builder> result = AdditionalLimitListCopier.copyToBuilder(this.additionalLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalLimits(Collection<AdditionalLimit.BuilderImpl> additionalLimits) {
            this.additionalLimits = AdditionalLimitListCopier.copyFromBuilder(additionalLimits);
        }

        @Override
        @Transient
        public final Builder additionalLimits(Collection<AdditionalLimit> additionalLimits) {
            this.additionalLimits = AdditionalLimitListCopier.copy(additionalLimits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalLimits(AdditionalLimit... additionalLimits) {
            additionalLimits(Arrays.asList(additionalLimits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalLimits(Consumer<AdditionalLimit.Builder>... additionalLimits) {
            additionalLimits(Stream.of(additionalLimits).map(c -> AdditionalLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Limits build() {
            return new Limits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
