/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class LogPublishingOptionsCopier {
    static Map<String, LogPublishingOption> copy(Map<String, ? extends LogPublishingOption> logPublishingOptionsParam) {
        Map<String, LogPublishingOption> map;
        if (logPublishingOptionsParam == null || logPublishingOptionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LogPublishingOption> modifiableMap = new LinkedHashMap<>();
            logPublishingOptionsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LogPublishingOption> copyFromBuilder(
            Map<String, ? extends LogPublishingOption.Builder> logPublishingOptionsParam) {
        Map<String, LogPublishingOption> map;
        if (logPublishingOptionsParam == null || logPublishingOptionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LogPublishingOption> modifiableMap = new LinkedHashMap<>();
            logPublishingOptionsParam.forEach((key, value) -> {
                LogPublishingOption member = value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LogPublishingOption.Builder> copyToBuilder(
            Map<String, ? extends LogPublishingOption> logPublishingOptionsParam) {
        Map<String, LogPublishingOption.Builder> map;
        if (logPublishingOptionsParam == null || logPublishingOptionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LogPublishingOption.Builder> modifiableMap = new LinkedHashMap<>();
            logPublishingOptionsParam.forEach((key, value) -> {
                LogPublishingOption.Builder member = value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, LogPublishingOption> copyEnumToString(Map<LogType, ? extends LogPublishingOption> logPublishingOptionsParam) {
        Map<String, LogPublishingOption> map;
        if (logPublishingOptionsParam == null || logPublishingOptionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, LogPublishingOption> modifiableMap = new LinkedHashMap<>();
            logPublishingOptionsParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<LogType, LogPublishingOption> copyStringToEnum(Map<String, ? extends LogPublishingOption> logPublishingOptionsParam) {
        Map<LogType, LogPublishingOption> map;
        if (logPublishingOptionsParam == null || logPublishingOptionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<LogType, LogPublishingOption> modifiableMap = new LinkedHashMap<>();
            logPublishingOptionsParam.forEach((key, value) -> {
                LogType result = LogType.fromValue(key);
                if (result != LogType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
