/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code> <a>RejectInboundConnection</a> </code> operation. Contains details about the rejected inbound
 * connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectInboundConnectionResponse extends OpenSearchResponse implements
        ToCopyableBuilder<RejectInboundConnectionResponse.Builder, RejectInboundConnectionResponse> {
    private static final SdkField<InboundConnection> CONNECTION_FIELD = SdkField
            .<InboundConnection> builder(MarshallingType.SDK_POJO).memberName("Connection")
            .getter(getter(RejectInboundConnectionResponse::connection)).setter(setter(Builder::connection))
            .constructor(InboundConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FIELD));

    private final InboundConnection connection;

    private RejectInboundConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connection = builder.connection;
    }

    /**
     * <p>
     * The <code> <a>InboundConnection</a> </code> of the rejected inbound connection.
     * </p>
     * 
     * @return The <code> <a>InboundConnection</a> </code> of the rejected inbound connection.
     */
    public final InboundConnection connection() {
        return connection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectInboundConnectionResponse)) {
            return false;
        }
        RejectInboundConnectionResponse other = (RejectInboundConnectionResponse) obj;
        return Objects.equals(connection(), other.connection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectInboundConnectionResponse").add("Connection", connection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connection":
            return Optional.ofNullable(clazz.cast(connection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectInboundConnectionResponse, T> g) {
        return obj -> g.apply((RejectInboundConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RejectInboundConnectionResponse> {
        /**
         * <p>
         * The <code> <a>InboundConnection</a> </code> of the rejected inbound connection.
         * </p>
         * 
         * @param connection
         *        The <code> <a>InboundConnection</a> </code> of the rejected inbound connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(InboundConnection connection);

        /**
         * <p>
         * The <code> <a>InboundConnection</a> </code> of the rejected inbound connection.
         * </p>
         * This is a convenience that creates an instance of the {@link InboundConnection.Builder} avoiding the need to
         * create one manually via {@link InboundConnection#builder()}.
         *
         * When the {@link Consumer} completes, {@link InboundConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #connection(InboundConnection)}.
         * 
         * @param connection
         *        a consumer that will call methods on {@link InboundConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connection(InboundConnection)
         */
        default Builder connection(Consumer<InboundConnection.Builder> connection) {
            return connection(InboundConnection.builder().applyMutation(connection).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private InboundConnection connection;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectInboundConnectionResponse model) {
            super(model);
            connection(model.connection);
        }

        public final InboundConnection.Builder getConnection() {
            return connection != null ? connection.toBuilder() : null;
        }

        public final void setConnection(InboundConnection.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        @Transient
        public final Builder connection(InboundConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public RejectInboundConnectionResponse build() {
            return new RejectInboundConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
