/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to the <code> <a>UpdatePackage</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageRequest extends OpenSearchRequest implements
        ToCopyableBuilder<UpdatePackageRequest.Builder, UpdatePackageRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(UpdatePackageRequest::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField
            .<PackageSource> builder(MarshallingType.SDK_POJO).memberName("PackageSource")
            .getter(getter(UpdatePackageRequest::packageSource)).setter(setter(Builder::packageSource))
            .constructor(PackageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()).build();

    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageDescription").getter(getter(UpdatePackageRequest::packageDescription))
            .setter(setter(Builder::packageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build())
            .build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitMessage").getter(getter(UpdatePackageRequest::commitMessage))
            .setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_SOURCE_FIELD, PACKAGE_DESCRIPTION_FIELD, COMMIT_MESSAGE_FIELD));

    private final String packageID;

    private final PackageSource packageSource;

    private final String packageDescription;

    private final String commitMessage;

    private UpdatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.packageSource = builder.packageSource;
        this.packageDescription = builder.packageDescription;
        this.commitMessage = builder.commitMessage;
    }

    /**
     * <p>
     * The unique identifier for the package.
     * </p>
     * 
     * @return The unique identifier for the package.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * Returns the value of the PackageSource property for this object.
     * 
     * @return The value of the PackageSource property for this object.
     */
    public final PackageSource packageSource() {
        return packageSource;
    }

    /**
     * <p>
     * A new description of the package.
     * </p>
     * 
     * @return A new description of the package.
     */
    public final String packageDescription() {
        return packageDescription;
    }

    /**
     * <p>
     * A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>.
     * </p>
     * 
     * @return A commit message for the new version which is shown as part of
     *         <code>GetPackageVersionHistoryResponse</code>.
     */
    public final String commitMessage() {
        return commitMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(packageSource());
        hashCode = 31 * hashCode + Objects.hashCode(packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageRequest)) {
            return false;
        }
        UpdatePackageRequest other = (UpdatePackageRequest) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(packageSource(), other.packageSource())
                && Objects.equals(packageDescription(), other.packageDescription())
                && Objects.equals(commitMessage(), other.commitMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageRequest").add("PackageID", packageID()).add("PackageSource", packageSource())
                .add("PackageDescription", packageDescription()).add("CommitMessage", commitMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "PackageSource":
            return Optional.ofNullable(clazz.cast(packageSource()));
        case "PackageDescription":
            return Optional.ofNullable(clazz.cast(packageDescription()));
        case "CommitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageRequest, T> g) {
        return obj -> g.apply((UpdatePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageRequest> {
        /**
         * <p>
         * The unique identifier for the package.
         * </p>
         * 
         * @param packageID
         *        The unique identifier for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * Sets the value of the PackageSource property for this object.
         *
         * @param packageSource
         *        The new value for the PackageSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageSource(PackageSource packageSource);

        /**
         * Sets the value of the PackageSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link PackageSource.Builder} avoiding the need to
         * create one manually via {@link PackageSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageSource.Builder#build()} is called immediately and its
         * result is passed to {@link #packageSource(PackageSource)}.
         * 
         * @param packageSource
         *        a consumer that will call methods on {@link PackageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageSource(PackageSource)
         */
        default Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return packageSource(PackageSource.builder().applyMutation(packageSource).build());
        }

        /**
         * <p>
         * A new description of the package.
         * </p>
         * 
         * @param packageDescription
         *        A new description of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDescription(String packageDescription);

        /**
         * <p>
         * A commit message for the new version which is shown as part of <code>GetPackageVersionHistoryResponse</code>.
         * </p>
         * 
         * @param commitMessage
         *        A commit message for the new version which is shown as part of
         *        <code>GetPackageVersionHistoryResponse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String packageID;

        private PackageSource packageSource;

        private String packageDescription;

        private String commitMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageRequest model) {
            super(model);
            packageID(model.packageID);
            packageSource(model.packageSource);
            packageDescription(model.packageDescription);
            commitMessage(model.commitMessage);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        @Transient
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return packageSource != null ? packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        @Transient
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        public final String getPackageDescription() {
            return packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        @Transient
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        @Transient
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageRequest build() {
            return new UpdatePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
