/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response returned by <code> <a>UpgradeDomain</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeDomainResponse extends OpenSearchResponse implements
        ToCopyableBuilder<UpgradeDomainResponse.Builder, UpgradeDomainResponse> {
    private static final SdkField<String> UPGRADE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpgradeId").getter(getter(UpgradeDomainResponse::upgradeId)).setter(setter(Builder::upgradeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpgradeDomainResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetVersion").getter(getter(UpgradeDomainResponse::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()).build();

    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformCheckOnly").getter(getter(UpgradeDomainResponse::performCheckOnly))
            .setter(setter(Builder::performCheckOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()).build();

    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdvancedOptions")
            .getter(getter(UpgradeDomainResponse::advancedOptions))
            .setter(setter(Builder::advancedOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_ID_FIELD,
            DOMAIN_NAME_FIELD, TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD, ADVANCED_OPTIONS_FIELD));

    private final String upgradeId;

    private final String domainName;

    private final String targetVersion;

    private final Boolean performCheckOnly;

    private final Map<String, String> advancedOptions;

    private UpgradeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.upgradeId = builder.upgradeId;
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
        this.advancedOptions = builder.advancedOptions;
    }

    /**
     * Returns the value of the UpgradeId property for this object.
     * 
     * @return The value of the UpgradeId property for this object.
     */
    public final String upgradeId() {
        return upgradeId;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The version of OpenSearch that you intend to upgrade the domain to.
     * </p>
     * 
     * @return The version of OpenSearch that you intend to upgrade the domain to.
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the
     * upgrade.
     * </p>
     * 
     * @return When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform
     *         the upgrade.
     */
    public final Boolean performCheckOnly() {
        return performCheckOnly;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdvancedOptions() {
        return advancedOptions != null && !(advancedOptions instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the AdvancedOptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedOptions} method.
     * </p>
     * 
     * @return The value of the AdvancedOptions property for this object.
     */
    public final Map<String, String> advancedOptions() {
        return advancedOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(upgradeId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(performCheckOnly());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedOptions() ? advancedOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeDomainResponse)) {
            return false;
        }
        UpgradeDomainResponse other = (UpgradeDomainResponse) obj;
        return Objects.equals(upgradeId(), other.upgradeId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(performCheckOnly(), other.performCheckOnly())
                && hasAdvancedOptions() == other.hasAdvancedOptions()
                && Objects.equals(advancedOptions(), other.advancedOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradeDomainResponse").add("UpgradeId", upgradeId()).add("DomainName", domainName())
                .add("TargetVersion", targetVersion()).add("PerformCheckOnly", performCheckOnly())
                .add("AdvancedOptions", hasAdvancedOptions() ? advancedOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpgradeId":
            return Optional.ofNullable(clazz.cast(upgradeId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "TargetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "PerformCheckOnly":
            return Optional.ofNullable(clazz.cast(performCheckOnly()));
        case "AdvancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeDomainResponse, T> g) {
        return obj -> g.apply((UpgradeDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpgradeDomainResponse> {
        /**
         * Sets the value of the UpgradeId property for this object.
         *
         * @param upgradeId
         *        The new value for the UpgradeId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeId(String upgradeId);

        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The version of OpenSearch that you intend to upgrade the domain to.
         * </p>
         * 
         * @param targetVersion
         *        The version of OpenSearch that you intend to upgrade the domain to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the
         * upgrade.
         * </p>
         * 
         * @param performCheckOnly
         *        When true, indicates that an upgrade eligibility check needs to be performed. Does not actually
         *        perform the upgrade.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performCheckOnly(Boolean performCheckOnly);

        /**
         * Sets the value of the AdvancedOptions property for this object.
         *
         * @param advancedOptions
         *        The new value for the AdvancedOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(Map<String, String> advancedOptions);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String upgradeId;

        private String domainName;

        private String targetVersion;

        private Boolean performCheckOnly;

        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeDomainResponse model) {
            super(model);
            upgradeId(model.upgradeId);
            domainName(model.domainName);
            targetVersion(model.targetVersion);
            performCheckOnly(model.performCheckOnly);
            advancedOptions(model.advancedOptions);
        }

        public final String getUpgradeId() {
            return upgradeId;
        }

        public final void setUpgradeId(String upgradeId) {
            this.upgradeId = upgradeId;
        }

        @Override
        @Transient
        public final Builder upgradeId(String upgradeId) {
            this.upgradeId = upgradeId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        @Transient
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Boolean getPerformCheckOnly() {
            return performCheckOnly;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        @Transient
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        @Transient
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        @Override
        public UpgradeDomainResponse build() {
            return new UpgradeDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
