/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code> <a>CreateOutboundConnection</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOutboundConnectionRequest extends OpenSearchRequest implements
        ToCopyableBuilder<CreateOutboundConnectionRequest.Builder, CreateOutboundConnectionRequest> {
    private static final SdkField<DomainInformationContainer> LOCAL_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformationContainer> builder(MarshallingType.SDK_POJO).memberName("LocalDomainInfo")
            .getter(getter(CreateOutboundConnectionRequest::localDomainInfo)).setter(setter(Builder::localDomainInfo))
            .constructor(DomainInformationContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDomainInfo").build()).build();

    private static final SdkField<DomainInformationContainer> REMOTE_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformationContainer> builder(MarshallingType.SDK_POJO).memberName("RemoteDomainInfo")
            .getter(getter(CreateOutboundConnectionRequest::remoteDomainInfo)).setter(setter(Builder::remoteDomainInfo))
            .constructor(DomainInformationContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainInfo").build()).build();

    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionAlias").getter(getter(CreateOutboundConnectionRequest::connectionAlias))
            .setter(setter(Builder::connectionAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DOMAIN_INFO_FIELD,
            REMOTE_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD));

    private final DomainInformationContainer localDomainInfo;

    private final DomainInformationContainer remoteDomainInfo;

    private final String connectionAlias;

    private CreateOutboundConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.localDomainInfo = builder.localDomainInfo;
        this.remoteDomainInfo = builder.remoteDomainInfo;
        this.connectionAlias = builder.connectionAlias;
    }

    /**
     * <p>
     * The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
     * </p>
     * 
     * @return The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
     */
    public final DomainInformationContainer localDomainInfo() {
        return localDomainInfo;
    }

    /**
     * <p>
     * The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
     * </p>
     * 
     * @return The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
     */
    public final DomainInformationContainer remoteDomainInfo() {
        return remoteDomainInfo;
    }

    /**
     * <p>
     * The connection alias used used by the customer for this cross-cluster connection.
     * </p>
     * 
     * @return The connection alias used used by the customer for this cross-cluster connection.
     */
    public final String connectionAlias() {
        return connectionAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(connectionAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundConnectionRequest)) {
            return false;
        }
        CreateOutboundConnectionRequest other = (CreateOutboundConnectionRequest) obj;
        return Objects.equals(localDomainInfo(), other.localDomainInfo())
                && Objects.equals(remoteDomainInfo(), other.remoteDomainInfo())
                && Objects.equals(connectionAlias(), other.connectionAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOutboundConnectionRequest").add("LocalDomainInfo", localDomainInfo())
                .add("RemoteDomainInfo", remoteDomainInfo()).add("ConnectionAlias", connectionAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalDomainInfo":
            return Optional.ofNullable(clazz.cast(localDomainInfo()));
        case "RemoteDomainInfo":
            return Optional.ofNullable(clazz.cast(remoteDomainInfo()));
        case "ConnectionAlias":
            return Optional.ofNullable(clazz.cast(connectionAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundConnectionRequest, T> g) {
        return obj -> g.apply((CreateOutboundConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOutboundConnectionRequest> {
        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
         * </p>
         * 
         * @param localDomainInfo
         *        The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDomainInfo(DomainInformationContainer localDomainInfo);

        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformationContainer.Builder}
         * avoiding the need to create one manually via {@link DomainInformationContainer#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainInformationContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #localDomainInfo(DomainInformationContainer)}.
         * 
         * @param localDomainInfo
         *        a consumer that will call methods on {@link DomainInformationContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localDomainInfo(DomainInformationContainer)
         */
        default Builder localDomainInfo(Consumer<DomainInformationContainer.Builder> localDomainInfo) {
            return localDomainInfo(DomainInformationContainer.builder().applyMutation(localDomainInfo).build());
        }

        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
         * </p>
         * 
         * @param remoteDomainInfo
         *        The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo);

        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformationContainer.Builder}
         * avoiding the need to create one manually via {@link DomainInformationContainer#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainInformationContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #remoteDomainInfo(DomainInformationContainer)}.
         * 
         * @param remoteDomainInfo
         *        a consumer that will call methods on {@link DomainInformationContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteDomainInfo(DomainInformationContainer)
         */
        default Builder remoteDomainInfo(Consumer<DomainInformationContainer.Builder> remoteDomainInfo) {
            return remoteDomainInfo(DomainInformationContainer.builder().applyMutation(remoteDomainInfo).build());
        }

        /**
         * <p>
         * The connection alias used used by the customer for this cross-cluster connection.
         * </p>
         * 
         * @param connectionAlias
         *        The connection alias used used by the customer for this cross-cluster connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAlias(String connectionAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private DomainInformationContainer localDomainInfo;

        private DomainInformationContainer remoteDomainInfo;

        private String connectionAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundConnectionRequest model) {
            super(model);
            localDomainInfo(model.localDomainInfo);
            remoteDomainInfo(model.remoteDomainInfo);
            connectionAlias(model.connectionAlias);
        }

        public final DomainInformationContainer.Builder getLocalDomainInfo() {
            return localDomainInfo != null ? localDomainInfo.toBuilder() : null;
        }

        public final void setLocalDomainInfo(DomainInformationContainer.BuilderImpl localDomainInfo) {
            this.localDomainInfo = localDomainInfo != null ? localDomainInfo.build() : null;
        }

        @Override
        public final Builder localDomainInfo(DomainInformationContainer localDomainInfo) {
            this.localDomainInfo = localDomainInfo;
            return this;
        }

        public final DomainInformationContainer.Builder getRemoteDomainInfo() {
            return remoteDomainInfo != null ? remoteDomainInfo.toBuilder() : null;
        }

        public final void setRemoteDomainInfo(DomainInformationContainer.BuilderImpl remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo != null ? remoteDomainInfo.build() : null;
        }

        @Override
        public final Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo;
            return this;
        }

        public final String getConnectionAlias() {
            return connectionAlias;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOutboundConnectionRequest build() {
            return new CreateOutboundConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
