/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the request parameters to the <code> <a>DescribePackage</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackagesRequest extends OpenSearchRequest implements
        ToCopyableBuilder<DescribePackagesRequest.Builder, DescribePackagesRequest> {
    private static final SdkField<List<DescribePackagesFilter>> FILTERS_FIELD = SdkField
            .<List<DescribePackagesFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribePackagesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DescribePackagesFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribePackagesFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribePackagesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePackagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DescribePackagesFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribePackagesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Only returns packages that match the <code>DescribePackagesFilterList</code> values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Only returns packages that match the <code>DescribePackagesFilterList</code> values.
     */
    public final List<DescribePackagesFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Limits results to a maximum number of packages.
     * </p>
     * 
     * @return Limits results to a maximum number of packages.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
     * returns results for the next page.
     * </p>
     * 
     * @return Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If
     *         provided, returns results for the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackagesRequest)) {
            return false;
        }
        DescribePackagesRequest other = (DescribePackagesRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackagesRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackagesRequest, T> g) {
        return obj -> g.apply((DescribePackagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePackagesRequest> {
        /**
         * <p>
         * Only returns packages that match the <code>DescribePackagesFilterList</code> values.
         * </p>
         * 
         * @param filters
         *        Only returns packages that match the <code>DescribePackagesFilterList</code> values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DescribePackagesFilter> filters);

        /**
         * <p>
         * Only returns packages that match the <code>DescribePackagesFilterList</code> values.
         * </p>
         * 
         * @param filters
         *        Only returns packages that match the <code>DescribePackagesFilterList</code> values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribePackagesFilter... filters);

        /**
         * <p>
         * Only returns packages that match the <code>DescribePackagesFilterList</code> values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DescribePackagesFilter>.Builder}
         * avoiding the need to create one manually via {@link List<DescribePackagesFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DescribePackagesFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<DescribePackagesFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<DescribePackagesFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<DescribePackagesFilter>)
         */
        Builder filters(Consumer<DescribePackagesFilter.Builder>... filters);

        /**
         * <p>
         * Limits results to a maximum number of packages.
         * </p>
         * 
         * @param maxResults
         *        Limits results to a maximum number of packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided,
         * returns results for the next page.
         * </p>
         * 
         * @param nextToken
         *        Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If
         *        provided, returns results for the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private List<DescribePackagesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackagesRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<DescribePackagesFilter.Builder> getFilters() {
            List<DescribePackagesFilter.Builder> result = DescribePackagesFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DescribePackagesFilter.BuilderImpl> filters) {
            this.filters = DescribePackagesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DescribePackagesFilter> filters) {
            this.filters = DescribePackagesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DescribePackagesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DescribePackagesFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DescribePackagesFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePackagesRequest build() {
            return new DescribePackagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
