/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on a package associated with a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainPackageDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainPackageDetails.Builder, DomainPackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(DomainPackageDetails::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(DomainPackageDetails::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(DomainPackageDetails::packageTypeAsString))
            .setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(DomainPackageDetails::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DomainPackageDetails::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> DOMAIN_PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainPackageStatus").getter(getter(DomainPackageDetails::domainPackageStatusAsString))
            .setter(setter(Builder::domainPackageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageStatus").build())
            .build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(DomainPackageDetails::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> REFERENCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferencePath").getter(getter(DomainPackageDetails::referencePath))
            .setter(setter(Builder::referencePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePath").build()).build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetails").getter(getter(DomainPackageDetails::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, LAST_UPDATED_FIELD, DOMAIN_NAME_FIELD, DOMAIN_PACKAGE_STATUS_FIELD,
            PACKAGE_VERSION_FIELD, REFERENCE_PATH_FIELD, ERROR_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String packageID;

    private final String packageName;

    private final String packageType;

    private final Instant lastUpdated;

    private final String domainName;

    private final String domainPackageStatus;

    private final String packageVersion;

    private final String referencePath;

    private final ErrorDetails errorDetails;

    private DomainPackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.lastUpdated = builder.lastUpdated;
        this.domainName = builder.domainName;
        this.domainPackageStatus = builder.domainPackageStatus;
        this.packageVersion = builder.packageVersion;
        this.referencePath = builder.referencePath;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The internal ID of the package.
     * </p>
     * 
     * @return The internal ID of the package.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * <p>
     * User-specified name of the package.
     * </p>
     * 
     * @return User-specified name of the package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * Currently supports only TXT-DICTIONARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return Currently supports only TXT-DICTIONARY.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * Currently supports only TXT-DICTIONARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return Currently supports only TXT-DICTIONARY.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * The timestamp of the most recent update to the package association status.
     * </p>
     * 
     * @return The timestamp of the most recent update to the package association status.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The name of the domain you've associated a package with.
     * </p>
     * 
     * @return The name of the domain you've associated a package with.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
     * DISSOCIATION_FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainPackageStatus} will return {@link DomainPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #domainPackageStatusAsString}.
     * </p>
     * 
     * @return State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
     *         DISSOCIATION_FAILED.
     * @see DomainPackageStatus
     */
    public final DomainPackageStatus domainPackageStatus() {
        return DomainPackageStatus.fromValue(domainPackageStatus);
    }

    /**
     * <p>
     * State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
     * DISSOCIATION_FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainPackageStatus} will return {@link DomainPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #domainPackageStatusAsString}.
     * </p>
     * 
     * @return State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
     *         DISSOCIATION_FAILED.
     * @see DomainPackageStatus
     */
    public final String domainPackageStatusAsString() {
        return domainPackageStatus;
    }

    /**
     * Returns the value of the PackageVersion property for this object.
     * 
     * @return The value of the PackageVersion property for this object.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the package is a
     * synonym file.
     * </p>
     * 
     * @return The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the package
     *         is a synonym file.
     */
    public final String referencePath() {
        return referencePath;
    }

    /**
     * <p>
     * Additional information if the package is in an error state. Null otherwise.
     * </p>
     * 
     * @return Additional information if the package is in an error state. Null otherwise.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(referencePath());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainPackageDetails)) {
            return false;
        }
        DomainPackageDetails other = (DomainPackageDetails) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(packageName(), other.packageName())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(domainPackageStatusAsString(), other.domainPackageStatusAsString())
                && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(referencePath(), other.referencePath()) && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainPackageDetails").add("PackageID", packageID()).add("PackageName", packageName())
                .add("PackageType", packageTypeAsString()).add("LastUpdated", lastUpdated()).add("DomainName", domainName())
                .add("DomainPackageStatus", domainPackageStatusAsString()).add("PackageVersion", packageVersion())
                .add("ReferencePath", referencePath()).add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainPackageStatus":
            return Optional.ofNullable(clazz.cast(domainPackageStatusAsString()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "ReferencePath":
            return Optional.ofNullable(clazz.cast(referencePath()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainPackageDetails, T> g) {
        return obj -> g.apply((DomainPackageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainPackageDetails> {
        /**
         * <p>
         * The internal ID of the package.
         * </p>
         * 
         * @param packageID
         *        The internal ID of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * User-specified name of the package.
         * </p>
         * 
         * @param packageName
         *        User-specified name of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * Currently supports only TXT-DICTIONARY.
         * </p>
         * 
         * @param packageType
         *        Currently supports only TXT-DICTIONARY.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * Currently supports only TXT-DICTIONARY.
         * </p>
         * 
         * @param packageType
         *        Currently supports only TXT-DICTIONARY.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * The timestamp of the most recent update to the package association status.
         * </p>
         * 
         * @param lastUpdated
         *        The timestamp of the most recent update to the package association status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The name of the domain you've associated a package with.
         * </p>
         * 
         * @param domainName
         *        The name of the domain you've associated a package with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
         * DISSOCIATION_FAILED.
         * </p>
         * 
         * @param domainPackageStatus
         *        State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
         *        DISSOCIATION_FAILED.
         * @see DomainPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainPackageStatus
         */
        Builder domainPackageStatus(String domainPackageStatus);

        /**
         * <p>
         * State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
         * DISSOCIATION_FAILED.
         * </p>
         * 
         * @param domainPackageStatus
         *        State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and
         *        DISSOCIATION_FAILED.
         * @see DomainPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainPackageStatus
         */
        Builder domainPackageStatus(DomainPackageStatus domainPackageStatus);

        /**
         * Sets the value of the PackageVersion property for this object.
         *
         * @param packageVersion
         *        The new value for the PackageVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the package is a
         * synonym file.
         * </p>
         * 
         * @param referencePath
         *        The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the
         *        package is a synonym file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencePath(String referencePath);

        /**
         * <p>
         * Additional information if the package is in an error state. Null otherwise.
         * </p>
         * 
         * @param errorDetails
         *        Additional information if the package is in an error state. Null otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * <p>
         * Additional information if the package is in an error state. Null otherwise.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String packageID;

        private String packageName;

        private String packageType;

        private Instant lastUpdated;

        private String domainName;

        private String domainPackageStatus;

        private String packageVersion;

        private String referencePath;

        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainPackageDetails model) {
            packageID(model.packageID);
            packageName(model.packageName);
            packageType(model.packageType);
            lastUpdated(model.lastUpdated);
            domainName(model.domainName);
            domainPackageStatus(model.domainPackageStatus);
            packageVersion(model.packageVersion);
            referencePath(model.referencePath);
            errorDetails(model.errorDetails);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainPackageStatus() {
            return domainPackageStatus;
        }

        public final void setDomainPackageStatus(String domainPackageStatus) {
            this.domainPackageStatus = domainPackageStatus;
        }

        @Override
        public final Builder domainPackageStatus(String domainPackageStatus) {
            this.domainPackageStatus = domainPackageStatus;
            return this;
        }

        @Override
        public final Builder domainPackageStatus(DomainPackageStatus domainPackageStatus) {
            this.domainPackageStatus(domainPackageStatus == null ? null : domainPackageStatus.toString());
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getReferencePath() {
            return referencePath;
        }

        public final void setReferencePath(String referencePath) {
            this.referencePath = referencePath;
        }

        @Override
        public final Builder referencePath(String referencePath) {
            this.referencePath = referencePath;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public DomainPackageDetails build() {
            return new DomainPackageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
