/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the response returned by the <code> <a>GetUpgradeHistory</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUpgradeHistoryResponse extends OpenSearchResponse implements
        ToCopyableBuilder<GetUpgradeHistoryResponse.Builder, GetUpgradeHistoryResponse> {
    private static final SdkField<List<UpgradeHistory>> UPGRADE_HISTORIES_FIELD = SdkField
            .<List<UpgradeHistory>> builder(MarshallingType.LIST)
            .memberName("UpgradeHistories")
            .getter(getter(GetUpgradeHistoryResponse::upgradeHistories))
            .setter(setter(Builder::upgradeHistories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeHistories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpgradeHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpgradeHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetUpgradeHistoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_HISTORIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<UpgradeHistory> upgradeHistories;

    private final String nextToken;

    private GetUpgradeHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.upgradeHistories = builder.upgradeHistories;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpgradeHistories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpgradeHistories() {
        return upgradeHistories != null && !(upgradeHistories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade eligibility check
     * performed on a domain returned as part of the <code> <a>GetUpgradeHistoryResponse</a> </code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpgradeHistories} method.
     * </p>
     * 
     * @return A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade
     *         eligibility check performed on a domain returned as part of the
     *         <code> <a>GetUpgradeHistoryResponse</a> </code> object.
     */
    public final List<UpgradeHistory> upgradeHistories() {
        return upgradeHistories;
    }

    /**
     * <p>
     * Pagination token that needs to be supplied to the next call to get the next page of results.
     * </p>
     * 
     * @return Pagination token that needs to be supplied to the next call to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUpgradeHistories() ? upgradeHistories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUpgradeHistoryResponse)) {
            return false;
        }
        GetUpgradeHistoryResponse other = (GetUpgradeHistoryResponse) obj;
        return hasUpgradeHistories() == other.hasUpgradeHistories()
                && Objects.equals(upgradeHistories(), other.upgradeHistories()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUpgradeHistoryResponse")
                .add("UpgradeHistories", hasUpgradeHistories() ? upgradeHistories() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpgradeHistories":
            return Optional.ofNullable(clazz.cast(upgradeHistories()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUpgradeHistoryResponse, T> g) {
        return obj -> g.apply((GetUpgradeHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUpgradeHistoryResponse> {
        /**
         * <p>
         * A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade eligibility
         * check performed on a domain returned as part of the <code> <a>GetUpgradeHistoryResponse</a> </code> object.
         * </p>
         * 
         * @param upgradeHistories
         *        A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade
         *        eligibility check performed on a domain returned as part of the
         *        <code> <a>GetUpgradeHistoryResponse</a> </code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeHistories(Collection<UpgradeHistory> upgradeHistories);

        /**
         * <p>
         * A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade eligibility
         * check performed on a domain returned as part of the <code> <a>GetUpgradeHistoryResponse</a> </code> object.
         * </p>
         * 
         * @param upgradeHistories
         *        A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade
         *        eligibility check performed on a domain returned as part of the
         *        <code> <a>GetUpgradeHistoryResponse</a> </code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeHistories(UpgradeHistory... upgradeHistories);

        /**
         * <p>
         * A list of <code> <a>UpgradeHistory</a> </code> objects corresponding to each upgrade or upgrade eligibility
         * check performed on a domain returned as part of the <code> <a>GetUpgradeHistoryResponse</a> </code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UpgradeHistory>.Builder} avoiding
         * the need to create one manually via {@link List<UpgradeHistory>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpgradeHistory>.Builder#build()} is called immediately and
         * its result is passed to {@link #upgradeHistories(List<UpgradeHistory>)}.
         * 
         * @param upgradeHistories
         *        a consumer that will call methods on {@link List<UpgradeHistory>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upgradeHistories(List<UpgradeHistory>)
         */
        Builder upgradeHistories(Consumer<UpgradeHistory.Builder>... upgradeHistories);

        /**
         * <p>
         * Pagination token that needs to be supplied to the next call to get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Pagination token that needs to be supplied to the next call to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<UpgradeHistory> upgradeHistories = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUpgradeHistoryResponse model) {
            super(model);
            upgradeHistories(model.upgradeHistories);
            nextToken(model.nextToken);
        }

        public final List<UpgradeHistory.Builder> getUpgradeHistories() {
            List<UpgradeHistory.Builder> result = UpgradeHistoryListCopier.copyToBuilder(this.upgradeHistories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpgradeHistories(Collection<UpgradeHistory.BuilderImpl> upgradeHistories) {
            this.upgradeHistories = UpgradeHistoryListCopier.copyFromBuilder(upgradeHistories);
        }

        @Override
        public final Builder upgradeHistories(Collection<UpgradeHistory> upgradeHistories) {
            this.upgradeHistories = UpgradeHistoryListCopier.copy(upgradeHistories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upgradeHistories(UpgradeHistory... upgradeHistories) {
            upgradeHistories(Arrays.asList(upgradeHistories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upgradeHistories(Consumer<UpgradeHistory.Builder>... upgradeHistories) {
            upgradeHistories(Stream.of(upgradeHistories).map(c -> UpgradeHistory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetUpgradeHistoryResponse build() {
            return new GetUpgradeHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
