/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the response returned by the <code> <a>GetUpgradeStatus</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUpgradeStatusResponse extends OpenSearchResponse implements
        ToCopyableBuilder<GetUpgradeStatusResponse.Builder, GetUpgradeStatusResponse> {
    private static final SdkField<String> UPGRADE_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpgradeStep").getter(getter(GetUpgradeStatusResponse::upgradeStepAsString))
            .setter(setter(Builder::upgradeStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStep").build()).build();

    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepStatus").getter(getter(GetUpgradeStatusResponse::stepStatusAsString))
            .setter(setter(Builder::stepStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStatus").build()).build();

    private static final SdkField<String> UPGRADE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpgradeName").getter(getter(GetUpgradeStatusResponse::upgradeName)).setter(setter(Builder::upgradeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_STEP_FIELD,
            STEP_STATUS_FIELD, UPGRADE_NAME_FIELD));

    private final String upgradeStep;

    private final String stepStatus;

    private final String upgradeName;

    private GetUpgradeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.upgradeStep = builder.upgradeStep;
        this.stepStatus = builder.stepStatus;
        this.upgradeName = builder.upgradeName;
    }

    /**
     * <p>
     * One of three steps an upgrade or upgrade eligibility check goes through:
     * <ul>
     * <li>PreUpgradeCheck</li>
     * <li>Snapshot</li>
     * <li>Upgrade</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upgradeStep} will
     * return {@link UpgradeStep#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upgradeStepAsString}.
     * </p>
     * 
     * @return One of three steps an upgrade or upgrade eligibility check goes through:
     *         <ul>
     *         <li>PreUpgradeCheck</li>
     *         <li>Snapshot</li>
     *         <li>Upgrade</li>
     *         </ul>
     * @see UpgradeStep
     */
    public final UpgradeStep upgradeStep() {
        return UpgradeStep.fromValue(upgradeStep);
    }

    /**
     * <p>
     * One of three steps an upgrade or upgrade eligibility check goes through:
     * <ul>
     * <li>PreUpgradeCheck</li>
     * <li>Snapshot</li>
     * <li>Upgrade</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upgradeStep} will
     * return {@link UpgradeStep#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upgradeStepAsString}.
     * </p>
     * 
     * @return One of three steps an upgrade or upgrade eligibility check goes through:
     *         <ul>
     *         <li>PreUpgradeCheck</li>
     *         <li>Snapshot</li>
     *         <li>Upgrade</li>
     *         </ul>
     * @see UpgradeStep
     */
    public final String upgradeStepAsString() {
        return upgradeStep;
    }

    /**
     * <p>
     * One of four statuses an upgrade have, returned as part of the <code> <a>GetUpgradeStatusResponse</a> </code>
     * object. The status can take one of the following values:
     * <ul>
     * <li>In Progress</li>
     * <li>Succeeded</li>
     * <li>Succeeded with Issues</li>
     * <li>Failed</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepStatus} will
     * return {@link UpgradeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepStatusAsString}.
     * </p>
     * 
     * @return One of four statuses an upgrade have, returned as part of the
     *         <code> <a>GetUpgradeStatusResponse</a> </code> object. The status can take one of the following values:
     *         <ul>
     *         <li>In Progress</li>
     *         <li>Succeeded</li>
     *         <li>Succeeded with Issues</li>
     *         <li>Failed</li>
     *         </ul>
     * @see UpgradeStatus
     */
    public final UpgradeStatus stepStatus() {
        return UpgradeStatus.fromValue(stepStatus);
    }

    /**
     * <p>
     * One of four statuses an upgrade have, returned as part of the <code> <a>GetUpgradeStatusResponse</a> </code>
     * object. The status can take one of the following values:
     * <ul>
     * <li>In Progress</li>
     * <li>Succeeded</li>
     * <li>Succeeded with Issues</li>
     * <li>Failed</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepStatus} will
     * return {@link UpgradeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepStatusAsString}.
     * </p>
     * 
     * @return One of four statuses an upgrade have, returned as part of the
     *         <code> <a>GetUpgradeStatusResponse</a> </code> object. The status can take one of the following values:
     *         <ul>
     *         <li>In Progress</li>
     *         <li>Succeeded</li>
     *         <li>Succeeded with Issues</li>
     *         <li>Failed</li>
     *         </ul>
     * @see UpgradeStatus
     */
    public final String stepStatusAsString() {
        return stepStatus;
    }

    /**
     * <p>
     * A string that briefly describes the update.
     * </p>
     * 
     * @return A string that briefly describes the update.
     */
    public final String upgradeName() {
        return upgradeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(upgradeStepAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upgradeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUpgradeStatusResponse)) {
            return false;
        }
        GetUpgradeStatusResponse other = (GetUpgradeStatusResponse) obj;
        return Objects.equals(upgradeStepAsString(), other.upgradeStepAsString())
                && Objects.equals(stepStatusAsString(), other.stepStatusAsString())
                && Objects.equals(upgradeName(), other.upgradeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUpgradeStatusResponse").add("UpgradeStep", upgradeStepAsString())
                .add("StepStatus", stepStatusAsString()).add("UpgradeName", upgradeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpgradeStep":
            return Optional.ofNullable(clazz.cast(upgradeStepAsString()));
        case "StepStatus":
            return Optional.ofNullable(clazz.cast(stepStatusAsString()));
        case "UpgradeName":
            return Optional.ofNullable(clazz.cast(upgradeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUpgradeStatusResponse, T> g) {
        return obj -> g.apply((GetUpgradeStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUpgradeStatusResponse> {
        /**
         * <p>
         * One of three steps an upgrade or upgrade eligibility check goes through:
         * <ul>
         * <li>PreUpgradeCheck</li>
         * <li>Snapshot</li>
         * <li>Upgrade</li>
         * </ul>
         * </p>
         * 
         * @param upgradeStep
         *        One of three steps an upgrade or upgrade eligibility check goes through:
         *        <ul>
         *        <li>PreUpgradeCheck</li>
         *        <li>Snapshot</li>
         *        <li>Upgrade</li>
         *        </ul>
         * @see UpgradeStep
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStep
         */
        Builder upgradeStep(String upgradeStep);

        /**
         * <p>
         * One of three steps an upgrade or upgrade eligibility check goes through:
         * <ul>
         * <li>PreUpgradeCheck</li>
         * <li>Snapshot</li>
         * <li>Upgrade</li>
         * </ul>
         * </p>
         * 
         * @param upgradeStep
         *        One of three steps an upgrade or upgrade eligibility check goes through:
         *        <ul>
         *        <li>PreUpgradeCheck</li>
         *        <li>Snapshot</li>
         *        <li>Upgrade</li>
         *        </ul>
         * @see UpgradeStep
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStep
         */
        Builder upgradeStep(UpgradeStep upgradeStep);

        /**
         * <p>
         * One of four statuses an upgrade have, returned as part of the <code> <a>GetUpgradeStatusResponse</a> </code>
         * object. The status can take one of the following values:
         * <ul>
         * <li>In Progress</li>
         * <li>Succeeded</li>
         * <li>Succeeded with Issues</li>
         * <li>Failed</li>
         * </ul>
         * </p>
         * 
         * @param stepStatus
         *        One of four statuses an upgrade have, returned as part of the
         *        <code> <a>GetUpgradeStatusResponse</a> </code> object. The status can take one of the following
         *        values:
         *        <ul>
         *        <li>In Progress</li>
         *        <li>Succeeded</li>
         *        <li>Succeeded with Issues</li>
         *        <li>Failed</li>
         *        </ul>
         * @see UpgradeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStatus
         */
        Builder stepStatus(String stepStatus);

        /**
         * <p>
         * One of four statuses an upgrade have, returned as part of the <code> <a>GetUpgradeStatusResponse</a> </code>
         * object. The status can take one of the following values:
         * <ul>
         * <li>In Progress</li>
         * <li>Succeeded</li>
         * <li>Succeeded with Issues</li>
         * <li>Failed</li>
         * </ul>
         * </p>
         * 
         * @param stepStatus
         *        One of four statuses an upgrade have, returned as part of the
         *        <code> <a>GetUpgradeStatusResponse</a> </code> object. The status can take one of the following
         *        values:
         *        <ul>
         *        <li>In Progress</li>
         *        <li>Succeeded</li>
         *        <li>Succeeded with Issues</li>
         *        <li>Failed</li>
         *        </ul>
         * @see UpgradeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStatus
         */
        Builder stepStatus(UpgradeStatus stepStatus);

        /**
         * <p>
         * A string that briefly describes the update.
         * </p>
         * 
         * @param upgradeName
         *        A string that briefly describes the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeName(String upgradeName);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String upgradeStep;

        private String stepStatus;

        private String upgradeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUpgradeStatusResponse model) {
            super(model);
            upgradeStep(model.upgradeStep);
            stepStatus(model.stepStatus);
            upgradeName(model.upgradeName);
        }

        public final String getUpgradeStep() {
            return upgradeStep;
        }

        public final void setUpgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
        }

        @Override
        public final Builder upgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
            return this;
        }

        @Override
        public final Builder upgradeStep(UpgradeStep upgradeStep) {
            this.upgradeStep(upgradeStep == null ? null : upgradeStep.toString());
            return this;
        }

        public final String getStepStatus() {
            return stepStatus;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(UpgradeStatus stepStatus) {
            this.stepStatus(stepStatus == null ? null : stepStatus.toString());
            return this;
        }

        public final String getUpgradeName() {
            return upgradeName;
        }

        public final void setUpgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
        }

        @Override
        public final Builder upgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
            return this;
        }

        @Override
        public GetUpgradeStatusResponse build() {
            return new GetUpgradeStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
