/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * StorageTypes represents the list of storage-related types and their attributes that are available for a given
 * InstanceType.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageType implements SdkPojo, Serializable, ToCopyableBuilder<StorageType.Builder, StorageType> {
    private static final SdkField<String> STORAGE_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageTypeName").getter(getter(StorageType::storageTypeName)).setter(setter(Builder::storageTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTypeName").build()).build();

    private static final SdkField<String> STORAGE_SUB_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageSubTypeName").getter(getter(StorageType::storageSubTypeName))
            .setter(setter(Builder::storageSubTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSubTypeName").build())
            .build();

    private static final SdkField<List<StorageTypeLimit>> STORAGE_TYPE_LIMITS_FIELD = SdkField
            .<List<StorageTypeLimit>> builder(MarshallingType.LIST)
            .memberName("StorageTypeLimits")
            .getter(getter(StorageType::storageTypeLimits))
            .setter(setter(Builder::storageTypeLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTypeLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageTypeLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageTypeLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_NAME_FIELD,
            STORAGE_SUB_TYPE_NAME_FIELD, STORAGE_TYPE_LIMITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String storageTypeName;

    private final String storageSubTypeName;

    private final List<StorageTypeLimit> storageTypeLimits;

    private StorageType(BuilderImpl builder) {
        this.storageTypeName = builder.storageTypeName;
        this.storageSubTypeName = builder.storageSubTypeName;
        this.storageTypeLimits = builder.storageTypeLimits;
    }

    /**
     * Returns the value of the StorageTypeName property for this object.
     * 
     * @return The value of the StorageTypeName property for this object.
     */
    public final String storageTypeName() {
        return storageTypeName;
    }

    /**
     * Returns the value of the StorageSubTypeName property for this object.
     * 
     * @return The value of the StorageSubTypeName property for this object.
     */
    public final String storageSubTypeName() {
        return storageSubTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageTypeLimits property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageTypeLimits() {
        return storageTypeLimits != null && !(storageTypeLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Limits that are applicable for the given storage type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageTypeLimits} method.
     * </p>
     * 
     * @return Limits that are applicable for the given storage type.
     */
    public final List<StorageTypeLimit> storageTypeLimits() {
        return storageTypeLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(storageSubTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageTypeLimits() ? storageTypeLimits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageType)) {
            return false;
        }
        StorageType other = (StorageType) obj;
        return Objects.equals(storageTypeName(), other.storageTypeName())
                && Objects.equals(storageSubTypeName(), other.storageSubTypeName())
                && hasStorageTypeLimits() == other.hasStorageTypeLimits()
                && Objects.equals(storageTypeLimits(), other.storageTypeLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageType").add("StorageTypeName", storageTypeName())
                .add("StorageSubTypeName", storageSubTypeName())
                .add("StorageTypeLimits", hasStorageTypeLimits() ? storageTypeLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageTypeName":
            return Optional.ofNullable(clazz.cast(storageTypeName()));
        case "StorageSubTypeName":
            return Optional.ofNullable(clazz.cast(storageSubTypeName()));
        case "StorageTypeLimits":
            return Optional.ofNullable(clazz.cast(storageTypeLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageType, T> g) {
        return obj -> g.apply((StorageType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageType> {
        /**
         * Sets the value of the StorageTypeName property for this object.
         *
         * @param storageTypeName
         *        The new value for the StorageTypeName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageTypeName(String storageTypeName);

        /**
         * Sets the value of the StorageSubTypeName property for this object.
         *
         * @param storageSubTypeName
         *        The new value for the StorageSubTypeName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSubTypeName(String storageSubTypeName);

        /**
         * <p>
         * Limits that are applicable for the given storage type.
         * </p>
         * 
         * @param storageTypeLimits
         *        Limits that are applicable for the given storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageTypeLimits(Collection<StorageTypeLimit> storageTypeLimits);

        /**
         * <p>
         * Limits that are applicable for the given storage type.
         * </p>
         * 
         * @param storageTypeLimits
         *        Limits that are applicable for the given storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageTypeLimits(StorageTypeLimit... storageTypeLimits);

        /**
         * <p>
         * Limits that are applicable for the given storage type.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StorageTypeLimit>.Builder} avoiding
         * the need to create one manually via {@link List<StorageTypeLimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageTypeLimit>.Builder#build()} is called immediately and
         * its result is passed to {@link #storageTypeLimits(List<StorageTypeLimit>)}.
         * 
         * @param storageTypeLimits
         *        a consumer that will call methods on {@link List<StorageTypeLimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageTypeLimits(List<StorageTypeLimit>)
         */
        Builder storageTypeLimits(Consumer<StorageTypeLimit.Builder>... storageTypeLimits);
    }

    static final class BuilderImpl implements Builder {
        private String storageTypeName;

        private String storageSubTypeName;

        private List<StorageTypeLimit> storageTypeLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StorageType model) {
            storageTypeName(model.storageTypeName);
            storageSubTypeName(model.storageSubTypeName);
            storageTypeLimits(model.storageTypeLimits);
        }

        public final String getStorageTypeName() {
            return storageTypeName;
        }

        public final void setStorageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
        }

        @Override
        public final Builder storageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
            return this;
        }

        public final String getStorageSubTypeName() {
            return storageSubTypeName;
        }

        public final void setStorageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
        }

        @Override
        public final Builder storageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
            return this;
        }

        public final List<StorageTypeLimit.Builder> getStorageTypeLimits() {
            List<StorageTypeLimit.Builder> result = StorageTypeLimitListCopier.copyToBuilder(this.storageTypeLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageTypeLimits(Collection<StorageTypeLimit.BuilderImpl> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copyFromBuilder(storageTypeLimits);
        }

        @Override
        public final Builder storageTypeLimits(Collection<StorageTypeLimit> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copy(storageTypeLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypeLimits(StorageTypeLimit... storageTypeLimits) {
            storageTypeLimits(Arrays.asList(storageTypeLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypeLimits(Consumer<StorageTypeLimit.Builder>... storageTypeLimits) {
            storageTypeLimits(Stream.of(storageTypeLimits).map(c -> StorageTypeLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StorageType build() {
            return new StorageType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
