/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of an <code>UpdateDomain</code> request. Contains the status of the domain being updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainConfigResponse extends OpenSearchResponse implements
        ToCopyableBuilder<UpdateDomainConfigResponse.Builder, UpdateDomainConfigResponse> {
    private static final SdkField<DomainConfig> DOMAIN_CONFIG_FIELD = SdkField.<DomainConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DomainConfig").getter(getter(UpdateDomainConfigResponse::domainConfig))
            .setter(setter(Builder::domainConfig)).constructor(DomainConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConfig").build()).build();

    private static final SdkField<DryRunResults> DRY_RUN_RESULTS_FIELD = SdkField
            .<DryRunResults> builder(MarshallingType.SDK_POJO).memberName("DryRunResults")
            .getter(getter(UpdateDomainConfigResponse::dryRunResults)).setter(setter(Builder::dryRunResults))
            .constructor(DryRunResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIG_FIELD,
            DRY_RUN_RESULTS_FIELD));

    private final DomainConfig domainConfig;

    private final DryRunResults dryRunResults;

    private UpdateDomainConfigResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfig = builder.domainConfig;
        this.dryRunResults = builder.dryRunResults;
    }

    /**
     * <p>
     * The status of the updated domain.
     * </p>
     * 
     * @return The status of the updated domain.
     */
    public final DomainConfig domainConfig() {
        return domainConfig;
    }

    /**
     * <p>
     * Contains result of DryRun.
     * </p>
     * 
     * @return Contains result of DryRun.
     */
    public final DryRunResults dryRunResults() {
        return dryRunResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dryRunResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainConfigResponse)) {
            return false;
        }
        UpdateDomainConfigResponse other = (UpdateDomainConfigResponse) obj;
        return Objects.equals(domainConfig(), other.domainConfig()) && Objects.equals(dryRunResults(), other.dryRunResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainConfigResponse").add("DomainConfig", domainConfig())
                .add("DryRunResults", dryRunResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainConfig":
            return Optional.ofNullable(clazz.cast(domainConfig()));
        case "DryRunResults":
            return Optional.ofNullable(clazz.cast(dryRunResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainConfigResponse, T> g) {
        return obj -> g.apply((UpdateDomainConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainConfigResponse> {
        /**
         * <p>
         * The status of the updated domain.
         * </p>
         * 
         * @param domainConfig
         *        The status of the updated domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfig(DomainConfig domainConfig);

        /**
         * <p>
         * The status of the updated domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainConfig.Builder} avoiding the need
         * to create one manually via {@link DomainConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #domainConfig(DomainConfig)}.
         * 
         * @param domainConfig
         *        a consumer that will call methods on {@link DomainConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainConfig(DomainConfig)
         */
        default Builder domainConfig(Consumer<DomainConfig.Builder> domainConfig) {
            return domainConfig(DomainConfig.builder().applyMutation(domainConfig).build());
        }

        /**
         * <p>
         * Contains result of DryRun.
         * </p>
         * 
         * @param dryRunResults
         *        Contains result of DryRun.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunResults(DryRunResults dryRunResults);

        /**
         * <p>
         * Contains result of DryRun.
         * </p>
         * This is a convenience method that creates an instance of the {@link DryRunResults.Builder} avoiding the need
         * to create one manually via {@link DryRunResults#builder()}.
         *
         * When the {@link Consumer} completes, {@link DryRunResults.Builder#build()} is called immediately and its
         * result is passed to {@link #dryRunResults(DryRunResults)}.
         * 
         * @param dryRunResults
         *        a consumer that will call methods on {@link DryRunResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dryRunResults(DryRunResults)
         */
        default Builder dryRunResults(Consumer<DryRunResults.Builder> dryRunResults) {
            return dryRunResults(DryRunResults.builder().applyMutation(dryRunResults).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private DomainConfig domainConfig;

        private DryRunResults dryRunResults;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainConfigResponse model) {
            super(model);
            domainConfig(model.domainConfig);
            dryRunResults(model.dryRunResults);
        }

        public final DomainConfig.Builder getDomainConfig() {
            return domainConfig != null ? domainConfig.toBuilder() : null;
        }

        public final void setDomainConfig(DomainConfig.BuilderImpl domainConfig) {
            this.domainConfig = domainConfig != null ? domainConfig.build() : null;
        }

        @Override
        public final Builder domainConfig(DomainConfig domainConfig) {
            this.domainConfig = domainConfig;
            return this;
        }

        public final DryRunResults.Builder getDryRunResults() {
            return dryRunResults != null ? dryRunResults.toBuilder() : null;
        }

        public final void setDryRunResults(DryRunResults.BuilderImpl dryRunResults) {
            this.dryRunResults = dryRunResults != null ? dryRunResults.build() : null;
        }

        @Override
        public final Builder dryRunResults(DryRunResults dryRunResults) {
            this.dryRunResults = dryRunResults;
            return this;
        }

        @Override
        public UpdateDomainConfigResponse build() {
            return new UpdateDomainConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
