/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code> <a>CreateOutboundConnection</a> </code> request. Contains the details about the newly created
 * cross-cluster connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOutboundConnectionResponse extends OpenSearchResponse implements
        ToCopyableBuilder<CreateOutboundConnectionResponse.Builder, CreateOutboundConnectionResponse> {
    private static final SdkField<DomainInformationContainer> LOCAL_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformationContainer> builder(MarshallingType.SDK_POJO).memberName("LocalDomainInfo")
            .getter(getter(CreateOutboundConnectionResponse::localDomainInfo)).setter(setter(Builder::localDomainInfo))
            .constructor(DomainInformationContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDomainInfo").build()).build();

    private static final SdkField<DomainInformationContainer> REMOTE_DOMAIN_INFO_FIELD = SdkField
            .<DomainInformationContainer> builder(MarshallingType.SDK_POJO).memberName("RemoteDomainInfo")
            .getter(getter(CreateOutboundConnectionResponse::remoteDomainInfo)).setter(setter(Builder::remoteDomainInfo))
            .constructor(DomainInformationContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainInfo").build()).build();

    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionAlias").getter(getter(CreateOutboundConnectionResponse::connectionAlias))
            .setter(setter(Builder::connectionAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()).build();

    private static final SdkField<OutboundConnectionStatus> CONNECTION_STATUS_FIELD = SdkField
            .<OutboundConnectionStatus> builder(MarshallingType.SDK_POJO).memberName("ConnectionStatus")
            .getter(getter(CreateOutboundConnectionResponse::connectionStatus)).setter(setter(Builder::connectionStatus))
            .constructor(OutboundConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId").getter(getter(CreateOutboundConnectionResponse::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DOMAIN_INFO_FIELD,
            REMOTE_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD, CONNECTION_STATUS_FIELD, CONNECTION_ID_FIELD));

    private final DomainInformationContainer localDomainInfo;

    private final DomainInformationContainer remoteDomainInfo;

    private final String connectionAlias;

    private final OutboundConnectionStatus connectionStatus;

    private final String connectionId;

    private CreateOutboundConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.localDomainInfo = builder.localDomainInfo;
        this.remoteDomainInfo = builder.remoteDomainInfo;
        this.connectionAlias = builder.connectionAlias;
        this.connectionStatus = builder.connectionStatus;
        this.connectionId = builder.connectionId;
    }

    /**
     * <p>
     * The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
     * </p>
     * 
     * @return The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
     */
    public final DomainInformationContainer localDomainInfo() {
        return localDomainInfo;
    }

    /**
     * <p>
     * The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
     * </p>
     * 
     * @return The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
     */
    public final DomainInformationContainer remoteDomainInfo() {
        return remoteDomainInfo;
    }

    /**
     * <p>
     * The connection alias provided during the create connection request.
     * </p>
     * 
     * @return The connection alias provided during the create connection request.
     */
    public final String connectionAlias() {
        return connectionAlias;
    }

    /**
     * <p>
     * The <code> <a>OutboundConnectionStatus</a> </code> for the newly created connection.
     * </p>
     * 
     * @return The <code> <a>OutboundConnectionStatus</a> </code> for the newly created connection.
     */
    public final OutboundConnectionStatus connectionStatus() {
        return connectionStatus;
    }

    /**
     * <p>
     * The unique ID for the created outbound connection, which is used for subsequent operations on the connection.
     * </p>
     * 
     * @return The unique ID for the created outbound connection, which is used for subsequent operations on the
     *         connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(connectionAlias());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundConnectionResponse)) {
            return false;
        }
        CreateOutboundConnectionResponse other = (CreateOutboundConnectionResponse) obj;
        return Objects.equals(localDomainInfo(), other.localDomainInfo())
                && Objects.equals(remoteDomainInfo(), other.remoteDomainInfo())
                && Objects.equals(connectionAlias(), other.connectionAlias())
                && Objects.equals(connectionStatus(), other.connectionStatus())
                && Objects.equals(connectionId(), other.connectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOutboundConnectionResponse").add("LocalDomainInfo", localDomainInfo())
                .add("RemoteDomainInfo", remoteDomainInfo()).add("ConnectionAlias", connectionAlias())
                .add("ConnectionStatus", connectionStatus()).add("ConnectionId", connectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalDomainInfo":
            return Optional.ofNullable(clazz.cast(localDomainInfo()));
        case "RemoteDomainInfo":
            return Optional.ofNullable(clazz.cast(remoteDomainInfo()));
        case "ConnectionAlias":
            return Optional.ofNullable(clazz.cast(connectionAlias()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatus()));
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundConnectionResponse, T> g) {
        return obj -> g.apply((CreateOutboundConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOutboundConnectionResponse> {
        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
         * </p>
         * 
         * @param localDomainInfo
         *        The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDomainInfo(DomainInformationContainer localDomainInfo);

        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the local OpenSearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformationContainer.Builder}
         * avoiding the need to create one manually via {@link DomainInformationContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformationContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #localDomainInfo(DomainInformationContainer)}.
         * 
         * @param localDomainInfo
         *        a consumer that will call methods on {@link DomainInformationContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localDomainInfo(DomainInformationContainer)
         */
        default Builder localDomainInfo(Consumer<DomainInformationContainer.Builder> localDomainInfo) {
            return localDomainInfo(DomainInformationContainer.builder().applyMutation(localDomainInfo).build());
        }

        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
         * </p>
         * 
         * @param remoteDomainInfo
         *        The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo);

        /**
         * <p>
         * The <code> <a>AWSDomainInformation</a> </code> for the remote OpenSearch domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainInformationContainer.Builder}
         * avoiding the need to create one manually via {@link DomainInformationContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainInformationContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #remoteDomainInfo(DomainInformationContainer)}.
         * 
         * @param remoteDomainInfo
         *        a consumer that will call methods on {@link DomainInformationContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteDomainInfo(DomainInformationContainer)
         */
        default Builder remoteDomainInfo(Consumer<DomainInformationContainer.Builder> remoteDomainInfo) {
            return remoteDomainInfo(DomainInformationContainer.builder().applyMutation(remoteDomainInfo).build());
        }

        /**
         * <p>
         * The connection alias provided during the create connection request.
         * </p>
         * 
         * @param connectionAlias
         *        The connection alias provided during the create connection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionAlias(String connectionAlias);

        /**
         * <p>
         * The <code> <a>OutboundConnectionStatus</a> </code> for the newly created connection.
         * </p>
         * 
         * @param connectionStatus
         *        The <code> <a>OutboundConnectionStatus</a> </code> for the newly created connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatus(OutboundConnectionStatus connectionStatus);

        /**
         * <p>
         * The <code> <a>OutboundConnectionStatus</a> </code> for the newly created connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundConnectionStatus.Builder}
         * avoiding the need to create one manually via {@link OutboundConnectionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundConnectionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionStatus(OutboundConnectionStatus)}.
         * 
         * @param connectionStatus
         *        a consumer that will call methods on {@link OutboundConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionStatus(OutboundConnectionStatus)
         */
        default Builder connectionStatus(Consumer<OutboundConnectionStatus.Builder> connectionStatus) {
            return connectionStatus(OutboundConnectionStatus.builder().applyMutation(connectionStatus).build());
        }

        /**
         * <p>
         * The unique ID for the created outbound connection, which is used for subsequent operations on the connection.
         * </p>
         * 
         * @param connectionId
         *        The unique ID for the created outbound connection, which is used for subsequent operations on the
         *        connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private DomainInformationContainer localDomainInfo;

        private DomainInformationContainer remoteDomainInfo;

        private String connectionAlias;

        private OutboundConnectionStatus connectionStatus;

        private String connectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundConnectionResponse model) {
            super(model);
            localDomainInfo(model.localDomainInfo);
            remoteDomainInfo(model.remoteDomainInfo);
            connectionAlias(model.connectionAlias);
            connectionStatus(model.connectionStatus);
            connectionId(model.connectionId);
        }

        public final DomainInformationContainer.Builder getLocalDomainInfo() {
            return localDomainInfo != null ? localDomainInfo.toBuilder() : null;
        }

        public final void setLocalDomainInfo(DomainInformationContainer.BuilderImpl localDomainInfo) {
            this.localDomainInfo = localDomainInfo != null ? localDomainInfo.build() : null;
        }

        @Override
        public final Builder localDomainInfo(DomainInformationContainer localDomainInfo) {
            this.localDomainInfo = localDomainInfo;
            return this;
        }

        public final DomainInformationContainer.Builder getRemoteDomainInfo() {
            return remoteDomainInfo != null ? remoteDomainInfo.toBuilder() : null;
        }

        public final void setRemoteDomainInfo(DomainInformationContainer.BuilderImpl remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo != null ? remoteDomainInfo.build() : null;
        }

        @Override
        public final Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo;
            return this;
        }

        public final String getConnectionAlias() {
            return connectionAlias;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        public final OutboundConnectionStatus.Builder getConnectionStatus() {
            return connectionStatus != null ? connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(OutboundConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(OutboundConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @Override
        public CreateOutboundConnectionResponse build() {
            return new CreateOutboundConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
