/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceTypeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceTypeDetails.Builder, InstanceTypeDetails> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(InstanceTypeDetails::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Boolean> ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EncryptionEnabled").getter(getter(InstanceTypeDetails::encryptionEnabled))
            .setter(setter(Builder::encryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionEnabled").build()).build();

    private static final SdkField<Boolean> COGNITO_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CognitoEnabled").getter(getter(InstanceTypeDetails::cognitoEnabled))
            .setter(setter(Builder::cognitoEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoEnabled").build()).build();

    private static final SdkField<Boolean> APP_LOGS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AppLogsEnabled").getter(getter(InstanceTypeDetails::appLogsEnabled))
            .setter(setter(Builder::appLogsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLogsEnabled").build()).build();

    private static final SdkField<Boolean> ADVANCED_SECURITY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AdvancedSecurityEnabled").getter(getter(InstanceTypeDetails::advancedSecurityEnabled))
            .setter(setter(Builder::advancedSecurityEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityEnabled").build())
            .build();

    private static final SdkField<Boolean> WARM_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WarmEnabled").getter(getter(InstanceTypeDetails::warmEnabled)).setter(setter(Builder::warmEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmEnabled").build()).build();

    private static final SdkField<List<String>> INSTANCE_ROLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceRole")
            .getter(getter(InstanceTypeDetails::instanceRole))
            .setter(setter(Builder::instanceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRole").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            ENCRYPTION_ENABLED_FIELD, COGNITO_ENABLED_FIELD, APP_LOGS_ENABLED_FIELD, ADVANCED_SECURITY_ENABLED_FIELD,
            WARM_ENABLED_FIELD, INSTANCE_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Boolean encryptionEnabled;

    private final Boolean cognitoEnabled;

    private final Boolean appLogsEnabled;

    private final Boolean advancedSecurityEnabled;

    private final Boolean warmEnabled;

    private final List<String> instanceRole;

    private InstanceTypeDetails(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.encryptionEnabled = builder.encryptionEnabled;
        this.cognitoEnabled = builder.cognitoEnabled;
        this.appLogsEnabled = builder.appLogsEnabled;
        this.advancedSecurityEnabled = builder.advancedSecurityEnabled;
        this.warmEnabled = builder.warmEnabled;
        this.instanceRole = builder.instanceRole;
    }

    /**
     * Returns the value of the InstanceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link OpenSearchPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The value of the InstanceType property for this object.
     * @see OpenSearchPartitionInstanceType
     */
    public final OpenSearchPartitionInstanceType instanceType() {
        return OpenSearchPartitionInstanceType.fromValue(instanceType);
    }

    /**
     * Returns the value of the InstanceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link OpenSearchPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The value of the InstanceType property for this object.
     * @see OpenSearchPartitionInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * Returns the value of the EncryptionEnabled property for this object.
     * 
     * @return The value of the EncryptionEnabled property for this object.
     */
    public final Boolean encryptionEnabled() {
        return encryptionEnabled;
    }

    /**
     * Returns the value of the CognitoEnabled property for this object.
     * 
     * @return The value of the CognitoEnabled property for this object.
     */
    public final Boolean cognitoEnabled() {
        return cognitoEnabled;
    }

    /**
     * Returns the value of the AppLogsEnabled property for this object.
     * 
     * @return The value of the AppLogsEnabled property for this object.
     */
    public final Boolean appLogsEnabled() {
        return appLogsEnabled;
    }

    /**
     * Returns the value of the AdvancedSecurityEnabled property for this object.
     * 
     * @return The value of the AdvancedSecurityEnabled property for this object.
     */
    public final Boolean advancedSecurityEnabled() {
        return advancedSecurityEnabled;
    }

    /**
     * Returns the value of the WarmEnabled property for this object.
     * 
     * @return The value of the WarmEnabled property for this object.
     */
    public final Boolean warmEnabled() {
        return warmEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceRole property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceRole() {
        return instanceRole != null && !(instanceRole instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the InstanceRole property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceRole} method.
     * </p>
     * 
     * @return The value of the InstanceRole property for this object.
     */
    public final List<String> instanceRole() {
        return instanceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(appLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(warmEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceRole() ? instanceRole() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeDetails)) {
            return false;
        }
        InstanceTypeDetails other = (InstanceTypeDetails) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(encryptionEnabled(), other.encryptionEnabled())
                && Objects.equals(cognitoEnabled(), other.cognitoEnabled())
                && Objects.equals(appLogsEnabled(), other.appLogsEnabled())
                && Objects.equals(advancedSecurityEnabled(), other.advancedSecurityEnabled())
                && Objects.equals(warmEnabled(), other.warmEnabled()) && hasInstanceRole() == other.hasInstanceRole()
                && Objects.equals(instanceRole(), other.instanceRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceTypeDetails").add("InstanceType", instanceTypeAsString())
                .add("EncryptionEnabled", encryptionEnabled()).add("CognitoEnabled", cognitoEnabled())
                .add("AppLogsEnabled", appLogsEnabled()).add("AdvancedSecurityEnabled", advancedSecurityEnabled())
                .add("WarmEnabled", warmEnabled()).add("InstanceRole", hasInstanceRole() ? instanceRole() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "EncryptionEnabled":
            return Optional.ofNullable(clazz.cast(encryptionEnabled()));
        case "CognitoEnabled":
            return Optional.ofNullable(clazz.cast(cognitoEnabled()));
        case "AppLogsEnabled":
            return Optional.ofNullable(clazz.cast(appLogsEnabled()));
        case "AdvancedSecurityEnabled":
            return Optional.ofNullable(clazz.cast(advancedSecurityEnabled()));
        case "WarmEnabled":
            return Optional.ofNullable(clazz.cast(warmEnabled()));
        case "InstanceRole":
            return Optional.ofNullable(clazz.cast(instanceRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeDetails, T> g) {
        return obj -> g.apply((InstanceTypeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceTypeDetails> {
        /**
         * Sets the value of the InstanceType property for this object.
         *
         * @param instanceType
         *        The new value for the InstanceType property for this object.
         * @see OpenSearchPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenSearchPartitionInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * Sets the value of the InstanceType property for this object.
         *
         * @param instanceType
         *        The new value for the InstanceType property for this object.
         * @see OpenSearchPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenSearchPartitionInstanceType
         */
        Builder instanceType(OpenSearchPartitionInstanceType instanceType);

        /**
         * Sets the value of the EncryptionEnabled property for this object.
         *
         * @param encryptionEnabled
         *        The new value for the EncryptionEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionEnabled(Boolean encryptionEnabled);

        /**
         * Sets the value of the CognitoEnabled property for this object.
         *
         * @param cognitoEnabled
         *        The new value for the CognitoEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoEnabled(Boolean cognitoEnabled);

        /**
         * Sets the value of the AppLogsEnabled property for this object.
         *
         * @param appLogsEnabled
         *        The new value for the AppLogsEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appLogsEnabled(Boolean appLogsEnabled);

        /**
         * Sets the value of the AdvancedSecurityEnabled property for this object.
         *
         * @param advancedSecurityEnabled
         *        The new value for the AdvancedSecurityEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedSecurityEnabled(Boolean advancedSecurityEnabled);

        /**
         * Sets the value of the WarmEnabled property for this object.
         *
         * @param warmEnabled
         *        The new value for the WarmEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmEnabled(Boolean warmEnabled);

        /**
         * Sets the value of the InstanceRole property for this object.
         *
         * @param instanceRole
         *        The new value for the InstanceRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRole(Collection<String> instanceRole);

        /**
         * Sets the value of the InstanceRole property for this object.
         *
         * @param instanceRole
         *        The new value for the InstanceRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRole(String... instanceRole);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Boolean encryptionEnabled;

        private Boolean cognitoEnabled;

        private Boolean appLogsEnabled;

        private Boolean advancedSecurityEnabled;

        private Boolean warmEnabled;

        private List<String> instanceRole = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeDetails model) {
            instanceType(model.instanceType);
            encryptionEnabled(model.encryptionEnabled);
            cognitoEnabled(model.cognitoEnabled);
            appLogsEnabled(model.appLogsEnabled);
            advancedSecurityEnabled(model.advancedSecurityEnabled);
            warmEnabled(model.warmEnabled);
            instanceRole(model.instanceRole);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(OpenSearchPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Boolean getEncryptionEnabled() {
            return encryptionEnabled;
        }

        public final void setEncryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
        }

        @Override
        public final Builder encryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
            return this;
        }

        public final Boolean getCognitoEnabled() {
            return cognitoEnabled;
        }

        public final void setCognitoEnabled(Boolean cognitoEnabled) {
            this.cognitoEnabled = cognitoEnabled;
        }

        @Override
        public final Builder cognitoEnabled(Boolean cognitoEnabled) {
            this.cognitoEnabled = cognitoEnabled;
            return this;
        }

        public final Boolean getAppLogsEnabled() {
            return appLogsEnabled;
        }

        public final void setAppLogsEnabled(Boolean appLogsEnabled) {
            this.appLogsEnabled = appLogsEnabled;
        }

        @Override
        public final Builder appLogsEnabled(Boolean appLogsEnabled) {
            this.appLogsEnabled = appLogsEnabled;
            return this;
        }

        public final Boolean getAdvancedSecurityEnabled() {
            return advancedSecurityEnabled;
        }

        public final void setAdvancedSecurityEnabled(Boolean advancedSecurityEnabled) {
            this.advancedSecurityEnabled = advancedSecurityEnabled;
        }

        @Override
        public final Builder advancedSecurityEnabled(Boolean advancedSecurityEnabled) {
            this.advancedSecurityEnabled = advancedSecurityEnabled;
            return this;
        }

        public final Boolean getWarmEnabled() {
            return warmEnabled;
        }

        public final void setWarmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
        }

        @Override
        public final Builder warmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
            return this;
        }

        public final Collection<String> getInstanceRole() {
            if (instanceRole instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceRole;
        }

        public final void setInstanceRole(Collection<String> instanceRole) {
            this.instanceRole = InstanceRoleListCopier.copy(instanceRole);
        }

        @Override
        public final Builder instanceRole(Collection<String> instanceRole) {
            this.instanceRole = InstanceRoleListCopier.copy(instanceRole);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRole(String... instanceRole) {
            instanceRole(Arrays.asList(instanceRole));
            return this;
        }

        @Override
        public InstanceTypeDetails build() {
            return new InstanceTypeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
