/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time, in UTC format, when the service takes a daily automated snapshot of the specified domain. Default is
 * <code>0</code> hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotOptions implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotOptions.Builder, SnapshotOptions> {
    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_START_HOUR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomatedSnapshotStartHour")
            .getter(getter(SnapshotOptions::automatedSnapshotStartHour))
            .setter(setter(Builder::automatedSnapshotStartHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotStartHour").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTOMATED_SNAPSHOT_START_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer automatedSnapshotStartHour;

    private SnapshotOptions(BuilderImpl builder) {
        this.automatedSnapshotStartHour = builder.automatedSnapshotStartHour;
    }

    /**
     * <p>
     * The time, in UTC format, when the service takes a daily automated snapshot of the specified domain. Default is
     * <code>0</code> hours.
     * </p>
     * 
     * @return The time, in UTC format, when the service takes a daily automated snapshot of the specified domain.
     *         Default is <code>0</code> hours.
     */
    public final Integer automatedSnapshotStartHour() {
        return automatedSnapshotStartHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotStartHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotOptions)) {
            return false;
        }
        SnapshotOptions other = (SnapshotOptions) obj;
        return Objects.equals(automatedSnapshotStartHour(), other.automatedSnapshotStartHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotOptions").add("AutomatedSnapshotStartHour", automatedSnapshotStartHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomatedSnapshotStartHour":
            return Optional.ofNullable(clazz.cast(automatedSnapshotStartHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotOptions, T> g) {
        return obj -> g.apply((SnapshotOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotOptions> {
        /**
         * <p>
         * The time, in UTC format, when the service takes a daily automated snapshot of the specified domain. Default
         * is <code>0</code> hours.
         * </p>
         * 
         * @param automatedSnapshotStartHour
         *        The time, in UTC format, when the service takes a daily automated snapshot of the specified domain.
         *        Default is <code>0</code> hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotStartHour(Integer automatedSnapshotStartHour);
    }

    static final class BuilderImpl implements Builder {
        private Integer automatedSnapshotStartHour;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotOptions model) {
            automatedSnapshotStartHour(model.automatedSnapshotStartHour);
        }

        public final Integer getAutomatedSnapshotStartHour() {
            return automatedSnapshotStartHour;
        }

        public final void setAutomatedSnapshotStartHour(Integer automatedSnapshotStartHour) {
            this.automatedSnapshotStartHour = automatedSnapshotStartHour;
        }

        @Override
        public final Builder automatedSnapshotStartHour(Integer automatedSnapshotStartHour) {
            this.automatedSnapshotStartHour = automatedSnapshotStartHour;
            return this;
        }

        @Override
        public SnapshotOptions build() {
            return new SnapshotOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
