/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies details about the Auto-Tune action. See <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html" target="_blank"> Auto-Tune
 * for Amazon OpenSearch Service </a> for more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoTuneDetails implements SdkPojo, Serializable, ToCopyableBuilder<AutoTuneDetails.Builder, AutoTuneDetails> {
    private static final SdkField<ScheduledAutoTuneDetails> SCHEDULED_AUTO_TUNE_DETAILS_FIELD = SdkField
            .<ScheduledAutoTuneDetails> builder(MarshallingType.SDK_POJO).memberName("ScheduledAutoTuneDetails")
            .getter(getter(AutoTuneDetails::scheduledAutoTuneDetails)).setter(setter(Builder::scheduledAutoTuneDetails))
            .constructor(ScheduledAutoTuneDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledAutoTuneDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCHEDULED_AUTO_TUNE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ScheduledAutoTuneDetails scheduledAutoTuneDetails;

    private AutoTuneDetails(BuilderImpl builder) {
        this.scheduledAutoTuneDetails = builder.scheduledAutoTuneDetails;
    }

    /**
     * Returns the value of the ScheduledAutoTuneDetails property for this object.
     * 
     * @return The value of the ScheduledAutoTuneDetails property for this object.
     */
    public final ScheduledAutoTuneDetails scheduledAutoTuneDetails() {
        return scheduledAutoTuneDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAutoTuneDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneDetails)) {
            return false;
        }
        AutoTuneDetails other = (AutoTuneDetails) obj;
        return Objects.equals(scheduledAutoTuneDetails(), other.scheduledAutoTuneDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoTuneDetails").add("ScheduledAutoTuneDetails", scheduledAutoTuneDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledAutoTuneDetails":
            return Optional.ofNullable(clazz.cast(scheduledAutoTuneDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoTuneDetails, T> g) {
        return obj -> g.apply((AutoTuneDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoTuneDetails> {
        /**
         * Sets the value of the ScheduledAutoTuneDetails property for this object.
         *
         * @param scheduledAutoTuneDetails
         *        The new value for the ScheduledAutoTuneDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAutoTuneDetails(ScheduledAutoTuneDetails scheduledAutoTuneDetails);

        /**
         * Sets the value of the ScheduledAutoTuneDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScheduledAutoTuneDetails.Builder}
         * avoiding the need to create one manually via {@link ScheduledAutoTuneDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledAutoTuneDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #scheduledAutoTuneDetails(ScheduledAutoTuneDetails)}.
         * 
         * @param scheduledAutoTuneDetails
         *        a consumer that will call methods on {@link ScheduledAutoTuneDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledAutoTuneDetails(ScheduledAutoTuneDetails)
         */
        default Builder scheduledAutoTuneDetails(Consumer<ScheduledAutoTuneDetails.Builder> scheduledAutoTuneDetails) {
            return scheduledAutoTuneDetails(ScheduledAutoTuneDetails.builder().applyMutation(scheduledAutoTuneDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScheduledAutoTuneDetails scheduledAutoTuneDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTuneDetails model) {
            scheduledAutoTuneDetails(model.scheduledAutoTuneDetails);
        }

        public final ScheduledAutoTuneDetails.Builder getScheduledAutoTuneDetails() {
            return scheduledAutoTuneDetails != null ? scheduledAutoTuneDetails.toBuilder() : null;
        }

        public final void setScheduledAutoTuneDetails(ScheduledAutoTuneDetails.BuilderImpl scheduledAutoTuneDetails) {
            this.scheduledAutoTuneDetails = scheduledAutoTuneDetails != null ? scheduledAutoTuneDetails.build() : null;
        }

        @Override
        public final Builder scheduledAutoTuneDetails(ScheduledAutoTuneDetails scheduledAutoTuneDetails) {
            this.scheduledAutoTuneDetails = scheduledAutoTuneDetails;
            return this;
        }

        @Override
        public AutoTuneDetails build() {
            return new AutoTuneDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
