/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DryRunResults implements SdkPojo, Serializable, ToCopyableBuilder<DryRunResults.Builder, DryRunResults> {
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentType").getter(getter(DryRunResults::deploymentType)).setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DryRunResults::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TYPE_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentType;

    private final String message;

    private DryRunResults(BuilderImpl builder) {
        this.deploymentType = builder.deploymentType;
        this.message = builder.message;
    }

    /**
     * <p>
     * Specifies the way in which Amazon OpenSearch Service applies the update. Possible responses are
     * <code>Blue/Green</code> (the update requires a blue/green deployment), <code>DynamicUpdate</code> (no blue/green
     * required), <code>Undetermined</code> (the domain is undergoing an update and can't predict the deployment type;
     * try again after the update is complete), and <code>None</code> (the request doesn't include any configuration
     * changes).
     * </p>
     * 
     * @return Specifies the way in which Amazon OpenSearch Service applies the update. Possible responses are
     *         <code>Blue/Green</code> (the update requires a blue/green deployment), <code>DynamicUpdate</code> (no
     *         blue/green required), <code>Undetermined</code> (the domain is undergoing an update and can't predict the
     *         deployment type; try again after the update is complete), and <code>None</code> (the request doesn't
     *         include any configuration changes).
     */
    public final String deploymentType() {
        return deploymentType;
    }

    /**
     * <p>
     * Contains an optional message associated with the DryRunResults.
     * </p>
     * 
     * @return Contains an optional message associated with the DryRunResults.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentType());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DryRunResults)) {
            return false;
        }
        DryRunResults other = (DryRunResults) obj;
        return Objects.equals(deploymentType(), other.deploymentType()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DryRunResults").add("DeploymentType", deploymentType()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentType()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DryRunResults, T> g) {
        return obj -> g.apply((DryRunResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DryRunResults> {
        /**
         * <p>
         * Specifies the way in which Amazon OpenSearch Service applies the update. Possible responses are
         * <code>Blue/Green</code> (the update requires a blue/green deployment), <code>DynamicUpdate</code> (no
         * blue/green required), <code>Undetermined</code> (the domain is undergoing an update and can't predict the
         * deployment type; try again after the update is complete), and <code>None</code> (the request doesn't include
         * any configuration changes).
         * </p>
         * 
         * @param deploymentType
         *        Specifies the way in which Amazon OpenSearch Service applies the update. Possible responses are
         *        <code>Blue/Green</code> (the update requires a blue/green deployment), <code>DynamicUpdate</code> (no
         *        blue/green required), <code>Undetermined</code> (the domain is undergoing an update and can't predict
         *        the deployment type; try again after the update is complete), and <code>None</code> (the request
         *        doesn't include any configuration changes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentType(String deploymentType);

        /**
         * <p>
         * Contains an optional message associated with the DryRunResults.
         * </p>
         * 
         * @param message
         *        Contains an optional message associated with the DryRunResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentType;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DryRunResults model) {
            deploymentType(model.deploymentType);
            message(model.message);
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DryRunResults build() {
            return new DryRunResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
