/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The connection mode for the cross-cluster connection.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>DIRECT</b> - Used for cross-cluster search or cross-cluster replication.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>VPC_ENDPOINT</b> - Used for remote reindex between Amazon OpenSearch Service VPC domains.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum ConnectionMode {
    DIRECT("DIRECT"),

    VPC_ENDPOINT("VPC_ENDPOINT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionMode> VALUE_MAP = EnumUtils.uniqueIndex(ConnectionMode.class,
            ConnectionMode::toString);

    private final String value;

    private ConnectionMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ConnectionMode corresponding to the value
     */
    public static ConnectionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ConnectionMode}s
     */
    public static Set<ConnectionMode> knownValues() {
        Set<ConnectionMode> knownValues = EnumSet.allOf(ConnectionMode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
