/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for a domain's <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html">off-peak window</a>,
 * during which OpenSearch Service can perform mandatory configuration changes on the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OffPeakWindowOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<OffPeakWindowOptions.Builder, OffPeakWindowOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(OffPeakWindowOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<OffPeakWindow> OFF_PEAK_WINDOW_FIELD = SdkField
            .<OffPeakWindow> builder(MarshallingType.SDK_POJO).memberName("OffPeakWindow")
            .getter(getter(OffPeakWindowOptions::offPeakWindow)).setter(setter(Builder::offPeakWindow))
            .constructor(OffPeakWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffPeakWindow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            OFF_PEAK_WINDOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final OffPeakWindow offPeakWindow;

    private OffPeakWindowOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.offPeakWindow = builder.offPeakWindow;
    }

    /**
     * <p>
     * Whether to enable an off-peak window.
     * </p>
     * <p>
     * This option is only available when modifying a domain created prior to February 13, 2023, not when creating a new
     * domain. All domains created after this date have the off-peak window enabled by default. You can't disable the
     * off-peak window after it's enabled for a domain.
     * </p>
     * 
     * @return Whether to enable an off-peak window.</p>
     *         <p>
     *         This option is only available when modifying a domain created prior to February 13, 2023, not when
     *         creating a new domain. All domains created after this date have the off-peak window enabled by default.
     *         You can't disable the off-peak window after it's enabled for a domain.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Off-peak window settings for the domain.
     * </p>
     * 
     * @return Off-peak window settings for the domain.
     */
    public final OffPeakWindow offPeakWindow() {
        return offPeakWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(offPeakWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OffPeakWindowOptions)) {
            return false;
        }
        OffPeakWindowOptions other = (OffPeakWindowOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(offPeakWindow(), other.offPeakWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OffPeakWindowOptions").add("Enabled", enabled()).add("OffPeakWindow", offPeakWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "OffPeakWindow":
            return Optional.ofNullable(clazz.cast(offPeakWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OffPeakWindowOptions, T> g) {
        return obj -> g.apply((OffPeakWindowOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OffPeakWindowOptions> {
        /**
         * <p>
         * Whether to enable an off-peak window.
         * </p>
         * <p>
         * This option is only available when modifying a domain created prior to February 13, 2023, not when creating a
         * new domain. All domains created after this date have the off-peak window enabled by default. You can't
         * disable the off-peak window after it's enabled for a domain.
         * </p>
         * 
         * @param enabled
         *        Whether to enable an off-peak window.</p>
         *        <p>
         *        This option is only available when modifying a domain created prior to February 13, 2023, not when
         *        creating a new domain. All domains created after this date have the off-peak window enabled by
         *        default. You can't disable the off-peak window after it's enabled for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Off-peak window settings for the domain.
         * </p>
         * 
         * @param offPeakWindow
         *        Off-peak window settings for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offPeakWindow(OffPeakWindow offPeakWindow);

        /**
         * <p>
         * Off-peak window settings for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link OffPeakWindow.Builder} avoiding the need
         * to create one manually via {@link OffPeakWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OffPeakWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #offPeakWindow(OffPeakWindow)}.
         * 
         * @param offPeakWindow
         *        a consumer that will call methods on {@link OffPeakWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offPeakWindow(OffPeakWindow)
         */
        default Builder offPeakWindow(Consumer<OffPeakWindow.Builder> offPeakWindow) {
            return offPeakWindow(OffPeakWindow.builder().applyMutation(offPeakWindow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private OffPeakWindow offPeakWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(OffPeakWindowOptions model) {
            enabled(model.enabled);
            offPeakWindow(model.offPeakWindow);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final OffPeakWindow.Builder getOffPeakWindow() {
            return offPeakWindow != null ? offPeakWindow.toBuilder() : null;
        }

        public final void setOffPeakWindow(OffPeakWindow.BuilderImpl offPeakWindow) {
            this.offPeakWindow = offPeakWindow != null ? offPeakWindow.build() : null;
        }

        @Override
        public final Builder offPeakWindow(OffPeakWindow offPeakWindow) {
            this.offPeakWindow = offPeakWindow;
            return this;
        }

        @Override
        public OffPeakWindowOptions build() {
            return new OffPeakWindowOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
