/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the configuration of an OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainConfig implements SdkPojo, Serializable, ToCopyableBuilder<DomainConfig.Builder, DomainConfig> {
    private static final SdkField<VersionStatus> ENGINE_VERSION_FIELD = SdkField
            .<VersionStatus> builder(MarshallingType.SDK_POJO).memberName("EngineVersion")
            .getter(getter(DomainConfig::engineVersion)).setter(setter(Builder::engineVersion))
            .constructor(VersionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<ClusterConfigStatus> CLUSTER_CONFIG_FIELD = SdkField
            .<ClusterConfigStatus> builder(MarshallingType.SDK_POJO).memberName("ClusterConfig")
            .getter(getter(DomainConfig::clusterConfig)).setter(setter(Builder::clusterConfig))
            .constructor(ClusterConfigStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()).build();

    private static final SdkField<EBSOptionsStatus> EBS_OPTIONS_FIELD = SdkField
            .<EBSOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("EBSOptions")
            .getter(getter(DomainConfig::ebsOptions)).setter(setter(Builder::ebsOptions)).constructor(EBSOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()).build();

    private static final SdkField<AccessPoliciesStatus> ACCESS_POLICIES_FIELD = SdkField
            .<AccessPoliciesStatus> builder(MarshallingType.SDK_POJO).memberName("AccessPolicies")
            .getter(getter(DomainConfig::accessPolicies)).setter(setter(Builder::accessPolicies))
            .constructor(AccessPoliciesStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<SnapshotOptionsStatus> SNAPSHOT_OPTIONS_FIELD = SdkField
            .<SnapshotOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("SnapshotOptions")
            .getter(getter(DomainConfig::snapshotOptions)).setter(setter(Builder::snapshotOptions))
            .constructor(SnapshotOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()).build();

    private static final SdkField<VPCDerivedInfoStatus> VPC_OPTIONS_FIELD = SdkField
            .<VPCDerivedInfoStatus> builder(MarshallingType.SDK_POJO).memberName("VPCOptions")
            .getter(getter(DomainConfig::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCDerivedInfoStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()).build();

    private static final SdkField<CognitoOptionsStatus> COGNITO_OPTIONS_FIELD = SdkField
            .<CognitoOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("CognitoOptions")
            .getter(getter(DomainConfig::cognitoOptions)).setter(setter(Builder::cognitoOptions))
            .constructor(CognitoOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()).build();

    private static final SdkField<EncryptionAtRestOptionsStatus> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<EncryptionAtRestOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions")
            .getter(getter(DomainConfig::encryptionAtRestOptions)).setter(setter(Builder::encryptionAtRestOptions))
            .constructor(EncryptionAtRestOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<NodeToNodeEncryptionOptionsStatus> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<NodeToNodeEncryptionOptionsStatus> builder(MarshallingType.SDK_POJO)
            .memberName("NodeToNodeEncryptionOptions")
            .getter(getter(DomainConfig::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(NodeToNodeEncryptionOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<AdvancedOptionsStatus> ADVANCED_OPTIONS_FIELD = SdkField
            .<AdvancedOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("AdvancedOptions")
            .getter(getter(DomainConfig::advancedOptions)).setter(setter(Builder::advancedOptions))
            .constructor(AdvancedOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build()).build();

    private static final SdkField<LogPublishingOptionsStatus> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<LogPublishingOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("LogPublishingOptions")
            .getter(getter(DomainConfig::logPublishingOptions)).setter(setter(Builder::logPublishingOptions))
            .constructor(LogPublishingOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build())
            .build();

    private static final SdkField<DomainEndpointOptionsStatus> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<DomainEndpointOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(DomainConfig::domainEndpointOptions)).setter(setter(Builder::domainEndpointOptions))
            .constructor(DomainEndpointOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<AdvancedSecurityOptionsStatus> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField
            .<AdvancedSecurityOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions")
            .getter(getter(DomainConfig::advancedSecurityOptions)).setter(setter(Builder::advancedSecurityOptions))
            .constructor(AdvancedSecurityOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build())
            .build();

    private static final SdkField<AutoTuneOptionsStatus> AUTO_TUNE_OPTIONS_FIELD = SdkField
            .<AutoTuneOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("AutoTuneOptions")
            .getter(getter(DomainConfig::autoTuneOptions)).setter(setter(Builder::autoTuneOptions))
            .constructor(AutoTuneOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()).build();

    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField
            .<ChangeProgressDetails> builder(MarshallingType.SDK_POJO).memberName("ChangeProgressDetails")
            .getter(getter(DomainConfig::changeProgressDetails)).setter(setter(Builder::changeProgressDetails))
            .constructor(ChangeProgressDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build())
            .build();

    private static final SdkField<OffPeakWindowOptionsStatus> OFF_PEAK_WINDOW_OPTIONS_FIELD = SdkField
            .<OffPeakWindowOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("OffPeakWindowOptions")
            .getter(getter(DomainConfig::offPeakWindowOptions)).setter(setter(Builder::offPeakWindowOptions))
            .constructor(OffPeakWindowOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffPeakWindowOptions").build())
            .build();

    private static final SdkField<SoftwareUpdateOptionsStatus> SOFTWARE_UPDATE_OPTIONS_FIELD = SdkField
            .<SoftwareUpdateOptionsStatus> builder(MarshallingType.SDK_POJO).memberName("SoftwareUpdateOptions")
            .getter(getter(DomainConfig::softwareUpdateOptions)).setter(setter(Builder::softwareUpdateOptions))
            .constructor(SoftwareUpdateOptionsStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdateOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD, CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD,
                    SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD,
                    NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD,
                    DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, AUTO_TUNE_OPTIONS_FIELD,
                    CHANGE_PROGRESS_DETAILS_FIELD, OFF_PEAK_WINDOW_OPTIONS_FIELD, SOFTWARE_UPDATE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VersionStatus engineVersion;

    private final ClusterConfigStatus clusterConfig;

    private final EBSOptionsStatus ebsOptions;

    private final AccessPoliciesStatus accessPolicies;

    private final SnapshotOptionsStatus snapshotOptions;

    private final VPCDerivedInfoStatus vpcOptions;

    private final CognitoOptionsStatus cognitoOptions;

    private final EncryptionAtRestOptionsStatus encryptionAtRestOptions;

    private final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;

    private final AdvancedOptionsStatus advancedOptions;

    private final LogPublishingOptionsStatus logPublishingOptions;

    private final DomainEndpointOptionsStatus domainEndpointOptions;

    private final AdvancedSecurityOptionsStatus advancedSecurityOptions;

    private final AutoTuneOptionsStatus autoTuneOptions;

    private final ChangeProgressDetails changeProgressDetails;

    private final OffPeakWindowOptionsStatus offPeakWindowOptions;

    private final SoftwareUpdateOptionsStatus softwareUpdateOptions;

    private DomainConfig(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.clusterConfig = builder.clusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.changeProgressDetails = builder.changeProgressDetails;
        this.offPeakWindowOptions = builder.offPeakWindowOptions;
        this.softwareUpdateOptions = builder.softwareUpdateOptions;
    }

    /**
     * <p>
     * The OpenSearch or Elasticsearch version that the domain is running.
     * </p>
     * 
     * @return The OpenSearch or Elasticsearch version that the domain is running.
     */
    public final VersionStatus engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Container for the cluster configuration of a the domain.
     * </p>
     * 
     * @return Container for the cluster configuration of a the domain.
     */
    public final ClusterConfigStatus clusterConfig() {
        return clusterConfig;
    }

    /**
     * <p>
     * Container for EBS options configured for the domain.
     * </p>
     * 
     * @return Container for EBS options configured for the domain.
     */
    public final EBSOptionsStatus ebsOptions() {
        return ebsOptions;
    }

    /**
     * <p>
     * Specifies the access policies for the domain.
     * </p>
     * 
     * @return Specifies the access policies for the domain.
     */
    public final AccessPoliciesStatus accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
     * </p>
     * 
     * @return DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
     */
    public final SnapshotOptionsStatus snapshotOptions() {
        return snapshotOptions;
    }

    /**
     * <p>
     * The current VPC options for the domain and the status of any updates to their configuration.
     * </p>
     * 
     * @return The current VPC options for the domain and the status of any updates to their configuration.
     */
    public final VPCDerivedInfoStatus vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * Container for Amazon Cognito options for the domain.
     * </p>
     * 
     * @return Container for Amazon Cognito options for the domain.
     */
    public final CognitoOptionsStatus cognitoOptions() {
        return cognitoOptions;
    }

    /**
     * <p>
     * Key-value pairs to enable encryption at rest.
     * </p>
     * 
     * @return Key-value pairs to enable encryption at rest.
     */
    public final EncryptionAtRestOptionsStatus encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * Whether node-to-node encryption is enabled or disabled.
     * </p>
     * 
     * @return Whether node-to-node encryption is enabled or disabled.
     */
    public final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Key-value pairs to specify advanced configuration options. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     * >Advanced options</a>.
     * </p>
     * 
     * @return Key-value pairs to specify advanced configuration options. For more information, see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     *         >Advanced options</a>.
     */
    public final AdvancedOptionsStatus advancedOptions() {
        return advancedOptions;
    }

    /**
     * <p>
     * Key-value pairs to configure slow log publishing.
     * </p>
     * 
     * @return Key-value pairs to configure slow log publishing.
     */
    public final LogPublishingOptionsStatus logPublishingOptions() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
     * </p>
     * 
     * @return Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
     */
    public final DomainEndpointOptionsStatus domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * Container for fine-grained access control settings for the domain.
     * </p>
     * 
     * @return Container for fine-grained access control settings for the domain.
     */
    public final AdvancedSecurityOptionsStatus advancedSecurityOptions() {
        return advancedSecurityOptions;
    }

    /**
     * <p>
     * Container for Auto-Tune settings for the domain.
     * </p>
     * 
     * @return Container for Auto-Tune settings for the domain.
     */
    public final AutoTuneOptionsStatus autoTuneOptions() {
        return autoTuneOptions;
    }

    /**
     * <p>
     * Container for information about the progress of an existing configuration change.
     * </p>
     * 
     * @return Container for information about the progress of an existing configuration change.
     */
    public final ChangeProgressDetails changeProgressDetails() {
        return changeProgressDetails;
    }

    /**
     * <p>
     * Container for off-peak window options for the domain.
     * </p>
     * 
     * @return Container for off-peak window options for the domain.
     */
    public final OffPeakWindowOptionsStatus offPeakWindowOptions() {
        return offPeakWindowOptions;
    }

    /**
     * <p>
     * Software update options for the domain.
     * </p>
     * 
     * @return Software update options for the domain.
     */
    public final SoftwareUpdateOptionsStatus softwareUpdateOptions() {
        return softwareUpdateOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(changeProgressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(offPeakWindowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(softwareUpdateOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainConfig)) {
            return false;
        }
        DomainConfig other = (DomainConfig) obj;
        return Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(clusterConfig(), other.clusterConfig())
                && Objects.equals(ebsOptions(), other.ebsOptions()) && Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(snapshotOptions(), other.snapshotOptions()) && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(cognitoOptions(), other.cognitoOptions())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && Objects.equals(advancedOptions(), other.advancedOptions())
                && Objects.equals(logPublishingOptions(), other.logPublishingOptions())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(advancedSecurityOptions(), other.advancedSecurityOptions())
                && Objects.equals(autoTuneOptions(), other.autoTuneOptions())
                && Objects.equals(changeProgressDetails(), other.changeProgressDetails())
                && Objects.equals(offPeakWindowOptions(), other.offPeakWindowOptions())
                && Objects.equals(softwareUpdateOptions(), other.softwareUpdateOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainConfig").add("EngineVersion", engineVersion()).add("ClusterConfig", clusterConfig())
                .add("EBSOptions", ebsOptions()).add("AccessPolicies", accessPolicies())
                .add("SnapshotOptions", snapshotOptions()).add("VPCOptions", vpcOptions())
                .add("CognitoOptions", cognitoOptions()).add("EncryptionAtRestOptions", encryptionAtRestOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions()).add("AdvancedOptions", advancedOptions())
                .add("LogPublishingOptions", logPublishingOptions()).add("DomainEndpointOptions", domainEndpointOptions())
                .add("AdvancedSecurityOptions", advancedSecurityOptions()).add("AutoTuneOptions", autoTuneOptions())
                .add("ChangeProgressDetails", changeProgressDetails()).add("OffPeakWindowOptions", offPeakWindowOptions())
                .add("SoftwareUpdateOptions", softwareUpdateOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "ClusterConfig":
            return Optional.ofNullable(clazz.cast(clusterConfig()));
        case "EBSOptions":
            return Optional.ofNullable(clazz.cast(ebsOptions()));
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "SnapshotOptions":
            return Optional.ofNullable(clazz.cast(snapshotOptions()));
        case "VPCOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "CognitoOptions":
            return Optional.ofNullable(clazz.cast(cognitoOptions()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "AdvancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptions()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "AdvancedSecurityOptions":
            return Optional.ofNullable(clazz.cast(advancedSecurityOptions()));
        case "AutoTuneOptions":
            return Optional.ofNullable(clazz.cast(autoTuneOptions()));
        case "ChangeProgressDetails":
            return Optional.ofNullable(clazz.cast(changeProgressDetails()));
        case "OffPeakWindowOptions":
            return Optional.ofNullable(clazz.cast(offPeakWindowOptions()));
        case "SoftwareUpdateOptions":
            return Optional.ofNullable(clazz.cast(softwareUpdateOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainConfig, T> g) {
        return obj -> g.apply((DomainConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainConfig> {
        /**
         * <p>
         * The OpenSearch or Elasticsearch version that the domain is running.
         * </p>
         * 
         * @param engineVersion
         *        The OpenSearch or Elasticsearch version that the domain is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(VersionStatus engineVersion);

        /**
         * <p>
         * The OpenSearch or Elasticsearch version that the domain is running.
         * </p>
         * This is a convenience method that creates an instance of the {@link VersionStatus.Builder} avoiding the need
         * to create one manually via {@link VersionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VersionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #engineVersion(VersionStatus)}.
         * 
         * @param engineVersion
         *        a consumer that will call methods on {@link VersionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersion(VersionStatus)
         */
        default Builder engineVersion(Consumer<VersionStatus.Builder> engineVersion) {
            return engineVersion(VersionStatus.builder().applyMutation(engineVersion).build());
        }

        /**
         * <p>
         * Container for the cluster configuration of a the domain.
         * </p>
         * 
         * @param clusterConfig
         *        Container for the cluster configuration of a the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterConfig(ClusterConfigStatus clusterConfig);

        /**
         * <p>
         * Container for the cluster configuration of a the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterConfigStatus.Builder} avoiding the
         * need to create one manually via {@link ClusterConfigStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterConfigStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterConfig(ClusterConfigStatus)}.
         * 
         * @param clusterConfig
         *        a consumer that will call methods on {@link ClusterConfigStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterConfig(ClusterConfigStatus)
         */
        default Builder clusterConfig(Consumer<ClusterConfigStatus.Builder> clusterConfig) {
            return clusterConfig(ClusterConfigStatus.builder().applyMutation(clusterConfig).build());
        }

        /**
         * <p>
         * Container for EBS options configured for the domain.
         * </p>
         * 
         * @param ebsOptions
         *        Container for EBS options configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptions(EBSOptionsStatus ebsOptions);

        /**
         * <p>
         * Container for EBS options configured for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link EBSOptionsStatus.Builder} avoiding the
         * need to create one manually via {@link EBSOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EBSOptionsStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #ebsOptions(EBSOptionsStatus)}.
         * 
         * @param ebsOptions
         *        a consumer that will call methods on {@link EBSOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsOptions(EBSOptionsStatus)
         */
        default Builder ebsOptions(Consumer<EBSOptionsStatus.Builder> ebsOptions) {
            return ebsOptions(EBSOptionsStatus.builder().applyMutation(ebsOptions).build());
        }

        /**
         * <p>
         * Specifies the access policies for the domain.
         * </p>
         * 
         * @param accessPolicies
         *        Specifies the access policies for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(AccessPoliciesStatus accessPolicies);

        /**
         * <p>
         * Specifies the access policies for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessPoliciesStatus.Builder} avoiding
         * the need to create one manually via {@link AccessPoliciesStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessPoliciesStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #accessPolicies(AccessPoliciesStatus)}.
         * 
         * @param accessPolicies
         *        a consumer that will call methods on {@link AccessPoliciesStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicies(AccessPoliciesStatus)
         */
        default Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return accessPolicies(AccessPoliciesStatus.builder().applyMutation(accessPolicies).build());
        }

        /**
         * <p>
         * DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
         * </p>
         * 
         * @param snapshotOptions
         *        DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions);

        /**
         * <p>
         * DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link SnapshotOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshotOptions(SnapshotOptionsStatus)}.
         * 
         * @param snapshotOptions
         *        a consumer that will call methods on {@link SnapshotOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotOptions(SnapshotOptionsStatus)
         */
        default Builder snapshotOptions(Consumer<SnapshotOptionsStatus.Builder> snapshotOptions) {
            return snapshotOptions(SnapshotOptionsStatus.builder().applyMutation(snapshotOptions).build());
        }

        /**
         * <p>
         * The current VPC options for the domain and the status of any updates to their configuration.
         * </p>
         * 
         * @param vpcOptions
         *        The current VPC options for the domain and the status of any updates to their configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCDerivedInfoStatus vpcOptions);

        /**
         * <p>
         * The current VPC options for the domain and the status of any updates to their configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCDerivedInfoStatus.Builder} avoiding
         * the need to create one manually via {@link VPCDerivedInfoStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCDerivedInfoStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcOptions(VPCDerivedInfoStatus)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCDerivedInfoStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCDerivedInfoStatus)
         */
        default Builder vpcOptions(Consumer<VPCDerivedInfoStatus.Builder> vpcOptions) {
            return vpcOptions(VPCDerivedInfoStatus.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * Container for Amazon Cognito options for the domain.
         * </p>
         * 
         * @param cognitoOptions
         *        Container for Amazon Cognito options for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoOptions(CognitoOptionsStatus cognitoOptions);

        /**
         * <p>
         * Container for Amazon Cognito options for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link CognitoOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #cognitoOptions(CognitoOptionsStatus)}.
         * 
         * @param cognitoOptions
         *        a consumer that will call methods on {@link CognitoOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoOptions(CognitoOptionsStatus)
         */
        default Builder cognitoOptions(Consumer<CognitoOptionsStatus.Builder> cognitoOptions) {
            return cognitoOptions(CognitoOptionsStatus.builder().applyMutation(cognitoOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to enable encryption at rest.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Key-value pairs to enable encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions);

        /**
         * <p>
         * Key-value pairs to enable encryption at rest.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionAtRestOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link EncryptionAtRestOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionAtRestOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionAtRestOptions(EncryptionAtRestOptionsStatus)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link EncryptionAtRestOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(EncryptionAtRestOptionsStatus)
         */
        default Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptionsStatus.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(EncryptionAtRestOptionsStatus.builder().applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * Whether node-to-node encryption is enabled or disabled.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        Whether node-to-node encryption is enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions);

        /**
         * <p>
         * Whether node-to-node encryption is enabled or disabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NodeToNodeEncryptionOptionsStatus.Builder} avoiding the need to create one manually via
         * {@link NodeToNodeEncryptionOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeToNodeEncryptionOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on {@link NodeToNodeEncryptionOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus)
         */
        default Builder nodeToNodeEncryptionOptions(
                Consumer<NodeToNodeEncryptionOptionsStatus.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.builder()
                    .applyMutation(nodeToNodeEncryptionOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to specify advanced configuration options. For more information, see <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
         * >Advanced options</a>.
         * </p>
         * 
         * @param advancedOptions
         *        Key-value pairs to specify advanced configuration options. For more information, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
         *        >Advanced options</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(AdvancedOptionsStatus advancedOptions);

        /**
         * <p>
         * Key-value pairs to specify advanced configuration options. For more information, see <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
         * >Advanced options</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link AdvancedOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #advancedOptions(AdvancedOptionsStatus)}.
         * 
         * @param advancedOptions
         *        a consumer that will call methods on {@link AdvancedOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedOptions(AdvancedOptionsStatus)
         */
        default Builder advancedOptions(Consumer<AdvancedOptionsStatus.Builder> advancedOptions) {
            return advancedOptions(AdvancedOptionsStatus.builder().applyMutation(advancedOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to configure slow log publishing.
         * </p>
         * 
         * @param logPublishingOptions
         *        Key-value pairs to configure slow log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions);

        /**
         * <p>
         * Key-value pairs to configure slow log publishing.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogPublishingOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link LogPublishingOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogPublishingOptionsStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #logPublishingOptions(LogPublishingOptionsStatus)}.
         * 
         * @param logPublishingOptions
         *        a consumer that will call methods on {@link LogPublishingOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingOptions(LogPublishingOptionsStatus)
         */
        default Builder logPublishingOptions(Consumer<LogPublishingOptionsStatus.Builder> logPublishingOptions) {
            return logPublishingOptions(LogPublishingOptionsStatus.builder().applyMutation(logPublishingOptions).build());
        }

        /**
         * <p>
         * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions);

        /**
         * <p>
         * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEndpointOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link DomainEndpointOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEndpointOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #domainEndpointOptions(DomainEndpointOptionsStatus)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link DomainEndpointOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(DomainEndpointOptionsStatus)
         */
        default Builder domainEndpointOptions(Consumer<DomainEndpointOptionsStatus.Builder> domainEndpointOptions) {
            return domainEndpointOptions(DomainEndpointOptionsStatus.builder().applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * Container for fine-grained access control settings for the domain.
         * </p>
         * 
         * @param advancedSecurityOptions
         *        Container for fine-grained access control settings for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions);

        /**
         * <p>
         * Container for fine-grained access control settings for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedSecurityOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link AdvancedSecurityOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedSecurityOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedSecurityOptions(AdvancedSecurityOptionsStatus)}.
         * 
         * @param advancedSecurityOptions
         *        a consumer that will call methods on {@link AdvancedSecurityOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedSecurityOptions(AdvancedSecurityOptionsStatus)
         */
        default Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsStatus.Builder> advancedSecurityOptions) {
            return advancedSecurityOptions(AdvancedSecurityOptionsStatus.builder().applyMutation(advancedSecurityOptions).build());
        }

        /**
         * <p>
         * Container for Auto-Tune settings for the domain.
         * </p>
         * 
         * @param autoTuneOptions
         *        Container for Auto-Tune settings for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTuneOptions(AutoTuneOptionsStatus autoTuneOptions);

        /**
         * <p>
         * Container for Auto-Tune settings for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoTuneOptionsStatus.Builder} avoiding
         * the need to create one manually via {@link AutoTuneOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoTuneOptionsStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #autoTuneOptions(AutoTuneOptionsStatus)}.
         * 
         * @param autoTuneOptions
         *        a consumer that will call methods on {@link AutoTuneOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTuneOptions(AutoTuneOptionsStatus)
         */
        default Builder autoTuneOptions(Consumer<AutoTuneOptionsStatus.Builder> autoTuneOptions) {
            return autoTuneOptions(AutoTuneOptionsStatus.builder().applyMutation(autoTuneOptions).build());
        }

        /**
         * <p>
         * Container for information about the progress of an existing configuration change.
         * </p>
         * 
         * @param changeProgressDetails
         *        Container for information about the progress of an existing configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails);

        /**
         * <p>
         * Container for information about the progress of an existing configuration change.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeProgressDetails.Builder} avoiding
         * the need to create one manually via {@link ChangeProgressDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeProgressDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #changeProgressDetails(ChangeProgressDetails)}.
         * 
         * @param changeProgressDetails
         *        a consumer that will call methods on {@link ChangeProgressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressDetails(ChangeProgressDetails)
         */
        default Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return changeProgressDetails(ChangeProgressDetails.builder().applyMutation(changeProgressDetails).build());
        }

        /**
         * <p>
         * Container for off-peak window options for the domain.
         * </p>
         * 
         * @param offPeakWindowOptions
         *        Container for off-peak window options for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offPeakWindowOptions(OffPeakWindowOptionsStatus offPeakWindowOptions);

        /**
         * <p>
         * Container for off-peak window options for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link OffPeakWindowOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link OffPeakWindowOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OffPeakWindowOptionsStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #offPeakWindowOptions(OffPeakWindowOptionsStatus)}.
         * 
         * @param offPeakWindowOptions
         *        a consumer that will call methods on {@link OffPeakWindowOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offPeakWindowOptions(OffPeakWindowOptionsStatus)
         */
        default Builder offPeakWindowOptions(Consumer<OffPeakWindowOptionsStatus.Builder> offPeakWindowOptions) {
            return offPeakWindowOptions(OffPeakWindowOptionsStatus.builder().applyMutation(offPeakWindowOptions).build());
        }

        /**
         * <p>
         * Software update options for the domain.
         * </p>
         * 
         * @param softwareUpdateOptions
         *        Software update options for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareUpdateOptions(SoftwareUpdateOptionsStatus softwareUpdateOptions);

        /**
         * <p>
         * Software update options for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareUpdateOptionsStatus.Builder}
         * avoiding the need to create one manually via {@link SoftwareUpdateOptionsStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareUpdateOptionsStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #softwareUpdateOptions(SoftwareUpdateOptionsStatus)}.
         * 
         * @param softwareUpdateOptions
         *        a consumer that will call methods on {@link SoftwareUpdateOptionsStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareUpdateOptions(SoftwareUpdateOptionsStatus)
         */
        default Builder softwareUpdateOptions(Consumer<SoftwareUpdateOptionsStatus.Builder> softwareUpdateOptions) {
            return softwareUpdateOptions(SoftwareUpdateOptionsStatus.builder().applyMutation(softwareUpdateOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VersionStatus engineVersion;

        private ClusterConfigStatus clusterConfig;

        private EBSOptionsStatus ebsOptions;

        private AccessPoliciesStatus accessPolicies;

        private SnapshotOptionsStatus snapshotOptions;

        private VPCDerivedInfoStatus vpcOptions;

        private CognitoOptionsStatus cognitoOptions;

        private EncryptionAtRestOptionsStatus encryptionAtRestOptions;

        private NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;

        private AdvancedOptionsStatus advancedOptions;

        private LogPublishingOptionsStatus logPublishingOptions;

        private DomainEndpointOptionsStatus domainEndpointOptions;

        private AdvancedSecurityOptionsStatus advancedSecurityOptions;

        private AutoTuneOptionsStatus autoTuneOptions;

        private ChangeProgressDetails changeProgressDetails;

        private OffPeakWindowOptionsStatus offPeakWindowOptions;

        private SoftwareUpdateOptionsStatus softwareUpdateOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainConfig model) {
            engineVersion(model.engineVersion);
            clusterConfig(model.clusterConfig);
            ebsOptions(model.ebsOptions);
            accessPolicies(model.accessPolicies);
            snapshotOptions(model.snapshotOptions);
            vpcOptions(model.vpcOptions);
            cognitoOptions(model.cognitoOptions);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            advancedOptions(model.advancedOptions);
            logPublishingOptions(model.logPublishingOptions);
            domainEndpointOptions(model.domainEndpointOptions);
            advancedSecurityOptions(model.advancedSecurityOptions);
            autoTuneOptions(model.autoTuneOptions);
            changeProgressDetails(model.changeProgressDetails);
            offPeakWindowOptions(model.offPeakWindowOptions);
            softwareUpdateOptions(model.softwareUpdateOptions);
        }

        public final VersionStatus.Builder getEngineVersion() {
            return engineVersion != null ? engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(VersionStatus.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(VersionStatus engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ClusterConfigStatus.Builder getClusterConfig() {
            return clusterConfig != null ? clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(ClusterConfigStatus.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(ClusterConfigStatus clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final EBSOptionsStatus.Builder getEbsOptions() {
            return ebsOptions != null ? ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return accessPolicies != null ? accessPolicies.toBuilder() : null;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return snapshotOptions != null ? snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCDerivedInfoStatus.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfoStatus.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfoStatus vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptionsStatus.Builder getCognitoOptions() {
            return cognitoOptions != null ? cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptionsStatus.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptionsStatus cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptionsStatus.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptionsStatus.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptionsStatus.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return advancedOptions != null ? advancedOptions.toBuilder() : null;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final LogPublishingOptionsStatus.Builder getLogPublishingOptions() {
            return logPublishingOptions != null ? logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptionsStatus.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final DomainEndpointOptionsStatus.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptionsStatus.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsStatus.Builder getAdvancedSecurityOptions() {
            return advancedSecurityOptions != null ? advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsStatus.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final AutoTuneOptionsStatus.Builder getAutoTuneOptions() {
            return autoTuneOptions != null ? autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsStatus.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsStatus autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return changeProgressDetails != null ? changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        public final OffPeakWindowOptionsStatus.Builder getOffPeakWindowOptions() {
            return offPeakWindowOptions != null ? offPeakWindowOptions.toBuilder() : null;
        }

        public final void setOffPeakWindowOptions(OffPeakWindowOptionsStatus.BuilderImpl offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions != null ? offPeakWindowOptions.build() : null;
        }

        @Override
        public final Builder offPeakWindowOptions(OffPeakWindowOptionsStatus offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        public final SoftwareUpdateOptionsStatus.Builder getSoftwareUpdateOptions() {
            return softwareUpdateOptions != null ? softwareUpdateOptions.toBuilder() : null;
        }

        public final void setSoftwareUpdateOptions(SoftwareUpdateOptionsStatus.BuilderImpl softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions != null ? softwareUpdateOptions.build() : null;
        }

        @Override
        public final Builder softwareUpdateOptions(SoftwareUpdateOptionsStatus softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        @Override
        public DomainConfig build() {
            return new DomainConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
