/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EngineType {
    OPEN_SEARCH("OpenSearch"),
    ELASTICSEARCH("Elasticsearch"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EngineType> VALUE_MAP;
    private final String value;

    private EngineType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EngineType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EngineType> knownValues() {
        EnumSet<EngineType> knownValues = EnumSet.allOf(EngineType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EngineType.class, EngineType::toString);
    }
}

