/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainRequest extends OpenSearchRequest implements
        ToCopyableBuilder<CreateDomainRequest.Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateDomainRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<ClusterConfig> CLUSTER_CONFIG_FIELD = SdkField
            .<ClusterConfig> builder(MarshallingType.SDK_POJO).memberName("ClusterConfig")
            .getter(getter(CreateDomainRequest::clusterConfig)).setter(setter(Builder::clusterConfig))
            .constructor(ClusterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()).build();

    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.<EBSOptions> builder(MarshallingType.SDK_POJO)
            .memberName("EBSOptions").getter(getter(CreateDomainRequest::ebsOptions)).setter(setter(Builder::ebsOptions))
            .constructor(EBSOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()).build();

    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPolicies").getter(getter(CreateDomainRequest::accessPolicies))
            .setter(setter(Builder::accessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPAddressType").getter(getter(CreateDomainRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressType").build()).build();

    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField
            .<SnapshotOptions> builder(MarshallingType.SDK_POJO).memberName("SnapshotOptions")
            .getter(getter(CreateDomainRequest::snapshotOptions)).setter(setter(Builder::snapshotOptions))
            .constructor(SnapshotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()).build();

    private static final SdkField<VPCOptions> VPC_OPTIONS_FIELD = SdkField.<VPCOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VPCOptions").getter(getter(CreateDomainRequest::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()).build();

    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField
            .<CognitoOptions> builder(MarshallingType.SDK_POJO).memberName("CognitoOptions")
            .getter(getter(CreateDomainRequest::cognitoOptions)).setter(setter(Builder::cognitoOptions))
            .constructor(CognitoOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()).build();

    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<EncryptionAtRestOptions> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions")
            .getter(getter(CreateDomainRequest::encryptionAtRestOptions)).setter(setter(Builder::encryptionAtRestOptions))
            .constructor(EncryptionAtRestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<NodeToNodeEncryptionOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NodeToNodeEncryptionOptions")
            .getter(getter(CreateDomainRequest::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(NodeToNodeEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdvancedOptions")
            .getter(getter(CreateDomainRequest::advancedOptions))
            .setter(setter(Builder::advancedOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<Map<String, LogPublishingOption>> builder(MarshallingType.MAP)
            .memberName("LogPublishingOptions")
            .getter(getter(CreateDomainRequest::logPublishingOptionsAsStrings))
            .setter(setter(Builder::logPublishingOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogPublishingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogPublishingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<DomainEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(CreateDomainRequest::domainEndpointOptions)).setter(setter(Builder::domainEndpointOptions))
            .constructor(DomainEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<AdvancedSecurityOptionsInput> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField
            .<AdvancedSecurityOptionsInput> builder(MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions")
            .getter(getter(CreateDomainRequest::advancedSecurityOptions)).setter(setter(Builder::advancedSecurityOptions))
            .constructor(AdvancedSecurityOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build())
            .build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(CreateDomainRequest::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoTuneOptionsInput> AUTO_TUNE_OPTIONS_FIELD = SdkField
            .<AutoTuneOptionsInput> builder(MarshallingType.SDK_POJO).memberName("AutoTuneOptions")
            .getter(getter(CreateDomainRequest::autoTuneOptions)).setter(setter(Builder::autoTuneOptions))
            .constructor(AutoTuneOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()).build();

    private static final SdkField<OffPeakWindowOptions> OFF_PEAK_WINDOW_OPTIONS_FIELD = SdkField
            .<OffPeakWindowOptions> builder(MarshallingType.SDK_POJO).memberName("OffPeakWindowOptions")
            .getter(getter(CreateDomainRequest::offPeakWindowOptions)).setter(setter(Builder::offPeakWindowOptions))
            .constructor(OffPeakWindowOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffPeakWindowOptions").build())
            .build();

    private static final SdkField<SoftwareUpdateOptions> SOFTWARE_UPDATE_OPTIONS_FIELD = SdkField
            .<SoftwareUpdateOptions> builder(MarshallingType.SDK_POJO).memberName("SoftwareUpdateOptions")
            .getter(getter(CreateDomainRequest::softwareUpdateOptions)).setter(setter(Builder::softwareUpdateOptions))
            .constructor(SoftwareUpdateOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdateOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ENGINE_VERSION_FIELD, CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, IP_ADDRESS_TYPE_FIELD,
            SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD,
            NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD,
            DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, TAG_LIST_FIELD, AUTO_TUNE_OPTIONS_FIELD,
            OFF_PEAK_WINDOW_OPTIONS_FIELD, SOFTWARE_UPDATE_OPTIONS_FIELD));

    private final String domainName;

    private final String engineVersion;

    private final ClusterConfig clusterConfig;

    private final EBSOptions ebsOptions;

    private final String accessPolicies;

    private final String ipAddressType;

    private final SnapshotOptions snapshotOptions;

    private final VPCOptions vpcOptions;

    private final CognitoOptions cognitoOptions;

    private final EncryptionAtRestOptions encryptionAtRestOptions;

    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

    private final Map<String, String> advancedOptions;

    private final Map<String, LogPublishingOption> logPublishingOptions;

    private final DomainEndpointOptions domainEndpointOptions;

    private final AdvancedSecurityOptionsInput advancedSecurityOptions;

    private final List<Tag> tagList;

    private final AutoTuneOptionsInput autoTuneOptions;

    private final OffPeakWindowOptions offPeakWindowOptions;

    private final SoftwareUpdateOptions softwareUpdateOptions;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.engineVersion = builder.engineVersion;
        this.clusterConfig = builder.clusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.ipAddressType = builder.ipAddressType;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.tagList = builder.tagList;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.offPeakWindowOptions = builder.offPeakWindowOptions;
        this.softwareUpdateOptions = builder.softwareUpdateOptions;
    }

    /**
     * <p>
     * Name of the OpenSearch Service domain to create. Domain names are unique across the domains owned by an account
     * within an Amazon Web Services Region.
     * </p>
     * 
     * @return Name of the OpenSearch Service domain to create. Domain names are unique across the domains owned by an
     *         account within an Amazon Web Services Region.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the OpenSearch Service
     * domain. For example, <code>OpenSearch_1.0</code> or <code>Elasticsearch_7.9</code>. For more information, see <a
     * href
     * ="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains"
     * >Creating and managing Amazon OpenSearch Service domains</a>.
     * </p>
     * 
     * @return String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the OpenSearch
     *         Service domain. For example, <code>OpenSearch_1.0</code> or <code>Elasticsearch_7.9</code>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains"
     *         >Creating and managing Amazon OpenSearch Service domains</a>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Container for the cluster configuration of a domain.
     * </p>
     * 
     * @return Container for the cluster configuration of a domain.
     */
    public final ClusterConfig clusterConfig() {
        return clusterConfig;
    }

    /**
     * <p>
     * Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.
     * </p>
     * 
     * @return Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.
     */
    public final EBSOptions ebsOptions() {
        return ebsOptions;
    }

    /**
     * <p>
     * Identity and Access Management (IAM) policy document specifying the access policies for the new domain.
     * </p>
     * 
     * @return Identity and Access Management (IAM) policy document specifying the access policies for the new domain.
     */
    public final String accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across
     * IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you
     * can't change your address type later.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IPAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain
     *         resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address
     *         type to dual stack, you can't change your address type later.
     * @see IPAddressType
     */
    public final IPAddressType ipAddressType() {
        return IPAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across
     * IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you
     * can't change your address type later.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IPAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain
     *         resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address
     *         type to dual stack, you can't change your address type later.
     * @see IPAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * DEPRECATED. Container for the parameters required to configure automated snapshots of domain indexes.
     * </p>
     * 
     * @return DEPRECATED. Container for the parameters required to configure automated snapshots of domain indexes.
     */
    public final SnapshotOptions snapshotOptions() {
        return snapshotOptions;
    }

    /**
     * <p>
     * Container for the values required to configure VPC access domains. If you don't specify these values, OpenSearch
     * Service creates the domain with a public endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon
     * OpenSearch Service domains using a VPC</a>.
     * </p>
     * 
     * @return Container for the values required to configure VPC access domains. If you don't specify these values,
     *         OpenSearch Service creates the domain with a public endpoint. For more information, see <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your
     *         Amazon OpenSearch Service domains using a VPC</a>.
     */
    public final VPCOptions vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * Key-value pairs to configure Amazon Cognito authentication. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Configuring Amazon
     * Cognito authentication for OpenSearch Dashboards</a>.
     * </p>
     * 
     * @return Key-value pairs to configure Amazon Cognito authentication. For more information, see <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Configuring
     *         Amazon Cognito authentication for OpenSearch Dashboards</a>.
     */
    public final CognitoOptions cognitoOptions() {
        return cognitoOptions;
    }

    /**
     * <p>
     * Key-value pairs to enable encryption at rest.
     * </p>
     * 
     * @return Key-value pairs to enable encryption at rest.
     */
    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * Enables node-to-node encryption.
     * </p>
     * 
     * @return Enables node-to-node encryption.
     */
    public final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdvancedOptions() {
        return advancedOptions != null && !(advancedOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs to specify advanced configuration options. The following key-value pairs are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather than a
     * boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP requests. If you
     * want to configure access policies for domain sub-resources, such as specific indexes and domain APIs, you must
     * disable this property. Default is true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean. Specifies
     * the percentage of heap space allocated to field data. Default is unbounded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a boolean.
     * Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with more
     * than the permitted number of clauses result in a <code>TooManyClauses</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than a boolean.
     * Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and plugins to
     * continue working with it. Default is false when creating a domain and true when upgrading a domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     * >Advanced cluster parameters</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedOptions} method.
     * </p>
     * 
     * @return Key-value pairs to specify advanced configuration options. The following key-value pairs are
     *         supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather
     *         than a boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP
     *         requests. If you want to configure access policies for domain sub-resources, such as specific indexes and
     *         domain APIs, you must disable this property. Default is true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean.
     *         Specifies the percentage of heap space allocated to field data. Default is unbounded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a
     *         boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024.
     *         Queries with more than the permitted number of clauses result in a <code>TooManyClauses</code> error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than a
     *         boolean. Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and
     *         plugins to continue working with it. Default is false when creating a domain and true when upgrading a
     *         domain.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
     *         >Advanced cluster parameters</a>.
     */
    public final Map<String, String> advancedOptions() {
        return advancedOptions;
    }

    /**
     * <p>
     * Key-value pairs to configure log publishing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPublishingOptions} method.
     * </p>
     * 
     * @return Key-value pairs to configure log publishing.
     */
    public final Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(logPublishingOptions);
    }

    /**
     * For responses, this returns true if the service returned a value for the LogPublishingOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogPublishingOptions() {
        return logPublishingOptions != null && !(logPublishingOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs to configure log publishing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPublishingOptions} method.
     * </p>
     * 
     * @return Key-value pairs to configure log publishing.
     */
    public final Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
     * </p>
     * 
     * @return Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
     */
    public final DomainEndpointOptions domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * Options for fine-grained access control.
     * </p>
     * 
     * @return Options for fine-grained access control.
     */
    public final AdvancedSecurityOptionsInput advancedSecurityOptions() {
        return advancedSecurityOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of tags to add to the domain upon creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return List of tags to add to the domain upon creation.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    /**
     * <p>
     * Options for Auto-Tune.
     * </p>
     * 
     * @return Options for Auto-Tune.
     */
    public final AutoTuneOptionsInput autoTuneOptions() {
        return autoTuneOptions;
    }

    /**
     * <p>
     * Specifies a daily 10-hour time block during which OpenSearch Service can perform configuration changes on the
     * domain, including service software updates and Auto-Tune enhancements that require a blue/green deployment. If no
     * options are specified, the default start time of 10:00 P.M. local time (for the Region that the domain is created
     * in) is used.
     * </p>
     * 
     * @return Specifies a daily 10-hour time block during which OpenSearch Service can perform configuration changes on
     *         the domain, including service software updates and Auto-Tune enhancements that require a blue/green
     *         deployment. If no options are specified, the default start time of 10:00 P.M. local time (for the Region
     *         that the domain is created in) is used.
     */
    public final OffPeakWindowOptions offPeakWindowOptions() {
        return offPeakWindowOptions;
    }

    /**
     * <p>
     * Software update options for the domain.
     * </p>
     * 
     * @return Software update options for the domain.
     */
    public final SoftwareUpdateOptions softwareUpdateOptions() {
        return softwareUpdateOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedOptions() ? advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogPublishingOptions() ? logPublishingOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(offPeakWindowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(softwareUpdateOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(clusterConfig(), other.clusterConfig()) && Objects.equals(ebsOptions(), other.ebsOptions())
                && Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(snapshotOptions(), other.snapshotOptions()) && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(cognitoOptions(), other.cognitoOptions())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && hasAdvancedOptions() == other.hasAdvancedOptions()
                && Objects.equals(advancedOptions(), other.advancedOptions())
                && hasLogPublishingOptions() == other.hasLogPublishingOptions()
                && Objects.equals(logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(advancedSecurityOptions(), other.advancedSecurityOptions())
                && hasTagList() == other.hasTagList() && Objects.equals(tagList(), other.tagList())
                && Objects.equals(autoTuneOptions(), other.autoTuneOptions())
                && Objects.equals(offPeakWindowOptions(), other.offPeakWindowOptions())
                && Objects.equals(softwareUpdateOptions(), other.softwareUpdateOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDomainRequest").add("DomainName", domainName()).add("EngineVersion", engineVersion())
                .add("ClusterConfig", clusterConfig()).add("EBSOptions", ebsOptions()).add("AccessPolicies", accessPolicies())
                .add("IPAddressType", ipAddressTypeAsString()).add("SnapshotOptions", snapshotOptions())
                .add("VPCOptions", vpcOptions()).add("CognitoOptions", cognitoOptions())
                .add("EncryptionAtRestOptions", encryptionAtRestOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions())
                .add("AdvancedOptions", hasAdvancedOptions() ? advancedOptions() : null)
                .add("LogPublishingOptions", hasLogPublishingOptions() ? logPublishingOptionsAsStrings() : null)
                .add("DomainEndpointOptions", domainEndpointOptions()).add("AdvancedSecurityOptions", advancedSecurityOptions())
                .add("TagList", hasTagList() ? tagList() : null).add("AutoTuneOptions", autoTuneOptions())
                .add("OffPeakWindowOptions", offPeakWindowOptions()).add("SoftwareUpdateOptions", softwareUpdateOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "ClusterConfig":
            return Optional.ofNullable(clazz.cast(clusterConfig()));
        case "EBSOptions":
            return Optional.ofNullable(clazz.cast(ebsOptions()));
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "IPAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "SnapshotOptions":
            return Optional.ofNullable(clazz.cast(snapshotOptions()));
        case "VPCOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "CognitoOptions":
            return Optional.ofNullable(clazz.cast(cognitoOptions()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "AdvancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptionsAsStrings()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "AdvancedSecurityOptions":
            return Optional.ofNullable(clazz.cast(advancedSecurityOptions()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        case "AutoTuneOptions":
            return Optional.ofNullable(clazz.cast(autoTuneOptions()));
        case "OffPeakWindowOptions":
            return Optional.ofNullable(clazz.cast(offPeakWindowOptions()));
        case "SoftwareUpdateOptions":
            return Optional.ofNullable(clazz.cast(softwareUpdateOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainRequest> {
        /**
         * <p>
         * Name of the OpenSearch Service domain to create. Domain names are unique across the domains owned by an
         * account within an Amazon Web Services Region.
         * </p>
         * 
         * @param domainName
         *        Name of the OpenSearch Service domain to create. Domain names are unique across the domains owned by
         *        an account within an Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the OpenSearch Service
         * domain. For example, <code>OpenSearch_1.0</code> or <code>Elasticsearch_7.9</code>. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains"
         * >Creating and managing Amazon OpenSearch Service domains</a>.
         * </p>
         * 
         * @param engineVersion
         *        String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the OpenSearch
         *        Service domain. For example, <code>OpenSearch_1.0</code> or <code>Elasticsearch_7.9</code>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains"
         *        >Creating and managing Amazon OpenSearch Service domains</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Container for the cluster configuration of a domain.
         * </p>
         * 
         * @param clusterConfig
         *        Container for the cluster configuration of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterConfig(ClusterConfig clusterConfig);

        /**
         * <p>
         * Container for the cluster configuration of a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterConfig.Builder} avoiding the need
         * to create one manually via {@link ClusterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterConfig(ClusterConfig)}.
         * 
         * @param clusterConfig
         *        a consumer that will call methods on {@link ClusterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterConfig(ClusterConfig)
         */
        default Builder clusterConfig(Consumer<ClusterConfig.Builder> clusterConfig) {
            return clusterConfig(ClusterConfig.builder().applyMutation(clusterConfig).build());
        }

        /**
         * <p>
         * Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.
         * </p>
         * 
         * @param ebsOptions
         *        Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptions(EBSOptions ebsOptions);

        /**
         * <p>
         * Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link EBSOptions.Builder} avoiding the need to
         * create one manually via {@link EBSOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EBSOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #ebsOptions(EBSOptions)}.
         * 
         * @param ebsOptions
         *        a consumer that will call methods on {@link EBSOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsOptions(EBSOptions)
         */
        default Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return ebsOptions(EBSOptions.builder().applyMutation(ebsOptions).build());
        }

        /**
         * <p>
         * Identity and Access Management (IAM) policy document specifying the access policies for the new domain.
         * </p>
         * 
         * @param accessPolicies
         *        Identity and Access Management (IAM) policy document specifying the access policies for the new
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(String accessPolicies);

        /**
         * <p>
         * Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources
         * across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual
         * stack, you can't change your address type later.
         * </p>
         * 
         * @param ipAddressType
         *        Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain
         *        resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP
         *        address type to dual stack, you can't change your address type later.
         * @see IPAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources
         * across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual
         * stack, you can't change your address type later.
         * </p>
         * 
         * @param ipAddressType
         *        Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain
         *        resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP
         *        address type to dual stack, you can't change your address type later.
         * @see IPAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressType
         */
        Builder ipAddressType(IPAddressType ipAddressType);

        /**
         * <p>
         * DEPRECATED. Container for the parameters required to configure automated snapshots of domain indexes.
         * </p>
         * 
         * @param snapshotOptions
         *        DEPRECATED. Container for the parameters required to configure automated snapshots of domain indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotOptions(SnapshotOptions snapshotOptions);

        /**
         * <p>
         * DEPRECATED. Container for the parameters required to configure automated snapshots of domain indexes.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotOptions.Builder} avoiding the
         * need to create one manually via {@link SnapshotOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshotOptions(SnapshotOptions)}.
         * 
         * @param snapshotOptions
         *        a consumer that will call methods on {@link SnapshotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotOptions(SnapshotOptions)
         */
        default Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return snapshotOptions(SnapshotOptions.builder().applyMutation(snapshotOptions).build());
        }

        /**
         * <p>
         * Container for the values required to configure VPC access domains. If you don't specify these values,
         * OpenSearch Service creates the domain with a public endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon
         * OpenSearch Service domains using a VPC</a>.
         * </p>
         * 
         * @param vpcOptions
         *        Container for the values required to configure VPC access domains. If you don't specify these values,
         *        OpenSearch Service creates the domain with a public endpoint. For more information, see <a
         *        href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your
         *        Amazon OpenSearch Service domains using a VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCOptions vpcOptions);

        /**
         * <p>
         * Container for the values required to configure VPC access domains. If you don't specify these values,
         * OpenSearch Service creates the domain with a public endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon
         * OpenSearch Service domains using a VPC</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCOptions.Builder} avoiding the need to
         * create one manually via {@link VPCOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcOptions(VPCOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCOptions)
         */
        default Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return vpcOptions(VPCOptions.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to configure Amazon Cognito authentication. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Configuring
         * Amazon Cognito authentication for OpenSearch Dashboards</a>.
         * </p>
         * 
         * @param cognitoOptions
         *        Key-value pairs to configure Amazon Cognito authentication. For more information, see <a
         *        href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
         *        >Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoOptions(CognitoOptions cognitoOptions);

        /**
         * <p>
         * Key-value pairs to configure Amazon Cognito authentication. For more information, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Configuring
         * Amazon Cognito authentication for OpenSearch Dashboards</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoOptions.Builder} avoiding the need
         * to create one manually via {@link CognitoOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #cognitoOptions(CognitoOptions)}.
         * 
         * @param cognitoOptions
         *        a consumer that will call methods on {@link CognitoOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoOptions(CognitoOptions)
         */
        default Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return cognitoOptions(CognitoOptions.builder().applyMutation(cognitoOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to enable encryption at rest.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Key-value pairs to enable encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions);

        /**
         * <p>
         * Key-value pairs to enable encryption at rest.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionAtRestOptions.Builder} avoiding
         * the need to create one manually via {@link EncryptionAtRestOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionAtRestOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionAtRestOptions(EncryptionAtRestOptions)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link EncryptionAtRestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(EncryptionAtRestOptions)
         */
        default Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * Enables node-to-node encryption.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        Enables node-to-node encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions);

        /**
         * <p>
         * Enables node-to-node encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeToNodeEncryptionOptions.Builder}
         * avoiding the need to create one manually via {@link NodeToNodeEncryptionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeToNodeEncryptionOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on {@link NodeToNodeEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions)
         */
        default Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)
                    .build());
        }

        /**
         * <p>
         * Key-value pairs to specify advanced configuration options. The following key-value pairs are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather
         * than a boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP
         * requests. If you want to configure access policies for domain sub-resources, such as specific indexes and
         * domain APIs, you must disable this property. Default is true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean.
         * Specifies the percentage of heap space allocated to field data. Default is unbounded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a boolean.
         * Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with
         * more than the permitted number of clauses result in a <code>TooManyClauses</code> error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than a
         * boolean. Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and
         * plugins to continue working with it. Default is false when creating a domain and true when upgrading a
         * domain.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
         * >Advanced cluster parameters</a>.
         * </p>
         * 
         * @param advancedOptions
         *        Key-value pairs to specify advanced configuration options. The following key-value pairs are
         *        supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string
         *        rather than a boolean. Specifies whether explicit references to indexes are allowed inside the body of
         *        HTTP requests. If you want to configure access policies for domain sub-resources, such as specific
         *        indexes and domain APIs, you must disable this property. Default is true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean.
         *        Specifies the percentage of heap space allocated to field data. Default is unbounded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a
         *        boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024.
         *        Queries with more than the permitted number of clauses result in a <code>TooManyClauses</code> error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than
         *        a boolean. Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients
         *        and plugins to continue working with it. Default is false when creating a domain and true when
         *        upgrading a domain.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
         *        >Advanced cluster parameters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(Map<String, String> advancedOptions);

        /**
         * <p>
         * Key-value pairs to configure log publishing.
         * </p>
         * 
         * @param logPublishingOptions
         *        Key-value pairs to configure log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions);

        /**
         * <p>
         * Key-value pairs to configure log publishing.
         * </p>
         * 
         * @param logPublishingOptions
         *        Key-value pairs to configure log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions);

        /**
         * <p>
         * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions);

        /**
         * <p>
         * Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEndpointOptions.Builder} avoiding
         * the need to create one manually via {@link DomainEndpointOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEndpointOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #domainEndpointOptions(DomainEndpointOptions)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link DomainEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(DomainEndpointOptions)
         */
        default Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return domainEndpointOptions(DomainEndpointOptions.builder().applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * Options for fine-grained access control.
         * </p>
         * 
         * @param advancedSecurityOptions
         *        Options for fine-grained access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedSecurityOptions(AdvancedSecurityOptionsInput advancedSecurityOptions);

        /**
         * <p>
         * Options for fine-grained access control.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedSecurityOptionsInput.Builder}
         * avoiding the need to create one manually via {@link AdvancedSecurityOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedSecurityOptionsInput.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedSecurityOptions(AdvancedSecurityOptionsInput)}.
         * 
         * @param advancedSecurityOptions
         *        a consumer that will call methods on {@link AdvancedSecurityOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedSecurityOptions(AdvancedSecurityOptionsInput)
         */
        default Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsInput.Builder> advancedSecurityOptions) {
            return advancedSecurityOptions(AdvancedSecurityOptionsInput.builder().applyMutation(advancedSecurityOptions).build());
        }

        /**
         * <p>
         * List of tags to add to the domain upon creation.
         * </p>
         * 
         * @param tagList
         *        List of tags to add to the domain upon creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * <p>
         * List of tags to add to the domain upon creation.
         * </p>
         * 
         * @param tagList
         *        List of tags to add to the domain upon creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * <p>
         * List of tags to add to the domain upon creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.opensearch.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        /**
         * <p>
         * Options for Auto-Tune.
         * </p>
         * 
         * @param autoTuneOptions
         *        Options for Auto-Tune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTuneOptions(AutoTuneOptionsInput autoTuneOptions);

        /**
         * <p>
         * Options for Auto-Tune.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoTuneOptionsInput.Builder} avoiding
         * the need to create one manually via {@link AutoTuneOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoTuneOptionsInput.Builder#build()} is called immediately and
         * its result is passed to {@link #autoTuneOptions(AutoTuneOptionsInput)}.
         * 
         * @param autoTuneOptions
         *        a consumer that will call methods on {@link AutoTuneOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTuneOptions(AutoTuneOptionsInput)
         */
        default Builder autoTuneOptions(Consumer<AutoTuneOptionsInput.Builder> autoTuneOptions) {
            return autoTuneOptions(AutoTuneOptionsInput.builder().applyMutation(autoTuneOptions).build());
        }

        /**
         * <p>
         * Specifies a daily 10-hour time block during which OpenSearch Service can perform configuration changes on the
         * domain, including service software updates and Auto-Tune enhancements that require a blue/green deployment.
         * If no options are specified, the default start time of 10:00 P.M. local time (for the Region that the domain
         * is created in) is used.
         * </p>
         * 
         * @param offPeakWindowOptions
         *        Specifies a daily 10-hour time block during which OpenSearch Service can perform configuration changes
         *        on the domain, including service software updates and Auto-Tune enhancements that require a blue/green
         *        deployment. If no options are specified, the default start time of 10:00 P.M. local time (for the
         *        Region that the domain is created in) is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offPeakWindowOptions(OffPeakWindowOptions offPeakWindowOptions);

        /**
         * <p>
         * Specifies a daily 10-hour time block during which OpenSearch Service can perform configuration changes on the
         * domain, including service software updates and Auto-Tune enhancements that require a blue/green deployment.
         * If no options are specified, the default start time of 10:00 P.M. local time (for the Region that the domain
         * is created in) is used.
         * </p>
         * This is a convenience method that creates an instance of the {@link OffPeakWindowOptions.Builder} avoiding
         * the need to create one manually via {@link OffPeakWindowOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OffPeakWindowOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #offPeakWindowOptions(OffPeakWindowOptions)}.
         * 
         * @param offPeakWindowOptions
         *        a consumer that will call methods on {@link OffPeakWindowOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offPeakWindowOptions(OffPeakWindowOptions)
         */
        default Builder offPeakWindowOptions(Consumer<OffPeakWindowOptions.Builder> offPeakWindowOptions) {
            return offPeakWindowOptions(OffPeakWindowOptions.builder().applyMutation(offPeakWindowOptions).build());
        }

        /**
         * <p>
         * Software update options for the domain.
         * </p>
         * 
         * @param softwareUpdateOptions
         *        Software update options for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareUpdateOptions(SoftwareUpdateOptions softwareUpdateOptions);

        /**
         * <p>
         * Software update options for the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareUpdateOptions.Builder} avoiding
         * the need to create one manually via {@link SoftwareUpdateOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareUpdateOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #softwareUpdateOptions(SoftwareUpdateOptions)}.
         * 
         * @param softwareUpdateOptions
         *        a consumer that will call methods on {@link SoftwareUpdateOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareUpdateOptions(SoftwareUpdateOptions)
         */
        default Builder softwareUpdateOptions(Consumer<SoftwareUpdateOptions.Builder> softwareUpdateOptions) {
            return softwareUpdateOptions(SoftwareUpdateOptions.builder().applyMutation(softwareUpdateOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String engineVersion;

        private ClusterConfig clusterConfig;

        private EBSOptions ebsOptions;

        private String accessPolicies;

        private String ipAddressType;

        private SnapshotOptions snapshotOptions;

        private VPCOptions vpcOptions;

        private CognitoOptions cognitoOptions;

        private EncryptionAtRestOptions encryptionAtRestOptions;

        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();

        private DomainEndpointOptions domainEndpointOptions;

        private AdvancedSecurityOptionsInput advancedSecurityOptions;

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private AutoTuneOptionsInput autoTuneOptions;

        private OffPeakWindowOptions offPeakWindowOptions;

        private SoftwareUpdateOptions softwareUpdateOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            domainName(model.domainName);
            engineVersion(model.engineVersion);
            clusterConfig(model.clusterConfig);
            ebsOptions(model.ebsOptions);
            accessPolicies(model.accessPolicies);
            ipAddressType(model.ipAddressType);
            snapshotOptions(model.snapshotOptions);
            vpcOptions(model.vpcOptions);
            cognitoOptions(model.cognitoOptions);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            advancedOptions(model.advancedOptions);
            logPublishingOptionsWithStrings(model.logPublishingOptions);
            domainEndpointOptions(model.domainEndpointOptions);
            advancedSecurityOptions(model.advancedSecurityOptions);
            tagList(model.tagList);
            autoTuneOptions(model.autoTuneOptions);
            offPeakWindowOptions(model.offPeakWindowOptions);
            softwareUpdateOptions(model.softwareUpdateOptions);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ClusterConfig.Builder getClusterConfig() {
            return clusterConfig != null ? clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(ClusterConfig.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(ClusterConfig clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return ebsOptions != null ? ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final String getAccessPolicies() {
            return accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IPAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return snapshotOptions != null ? snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return cognitoOptions != null ? cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            Map<String, LogPublishingOption.Builder> result = LogPublishingOptionsCopier.copyToBuilder(this.logPublishingOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsInput.Builder getAdvancedSecurityOptions() {
            return advancedSecurityOptions != null ? advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsInput.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsInput advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoTuneOptionsInput.Builder getAutoTuneOptions() {
            return autoTuneOptions != null ? autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsInput.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsInput autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final OffPeakWindowOptions.Builder getOffPeakWindowOptions() {
            return offPeakWindowOptions != null ? offPeakWindowOptions.toBuilder() : null;
        }

        public final void setOffPeakWindowOptions(OffPeakWindowOptions.BuilderImpl offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions != null ? offPeakWindowOptions.build() : null;
        }

        @Override
        public final Builder offPeakWindowOptions(OffPeakWindowOptions offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        public final SoftwareUpdateOptions.Builder getSoftwareUpdateOptions() {
            return softwareUpdateOptions != null ? softwareUpdateOptions.toBuilder() : null;
        }

        public final void setSoftwareUpdateOptions(SoftwareUpdateOptions.BuilderImpl softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions != null ? softwareUpdateOptions.build() : null;
        }

        @Override
        public final Builder softwareUpdateOptions(SoftwareUpdateOptions softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
