/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.AddDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.AddDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.AddTagsRequest;
import software.amazon.awssdk.services.opensearch.model.AddTagsResponse;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.CancelDomainConfigChangeRequest;
import software.amazon.awssdk.services.opensearch.model.CancelDomainConfigChangeResponse;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.opensearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.GetDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.GetDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusResponse;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.opensearch.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse;
import software.amazon.awssdk.services.opensearch.model.ListTagsRequest;
import software.amazon.awssdk.services.opensearch.model.ListTagsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVersionsResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainResponse;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest;
import software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingResponse;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest;
import software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionResponse;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.opensearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceRequest;
import software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceResponse;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigResponse;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.opensearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionResponse;
import software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest;
import software.amazon.awssdk.services.opensearch.model.UpgradeDomainResponse;
import software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher;
import software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListDomainMaintenancesPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListScheduledActionsPublisher;
import software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher;

/**
 * Service client for accessing Amazon OpenSearch Service asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Use the Amazon OpenSearch Service configuration API to create, configure, and manage OpenSearch Service domains. The
 * endpoint for configuration service requests is Region specific: es.<i>region</i>.amazonaws.com. For example,
 * es.us-east-1.amazonaws.com. For a current list of supported Regions and endpoints, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#service-regions">Amazon Web Services service
 * endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OpenSearchAsyncClient extends AwsClient {
    String SERVICE_NAME = "es";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "es";

    /**
     * <p>
     * Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search
     * connection request. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param acceptInboundConnectionRequest
     *        Container for the parameters to the <code>AcceptInboundConnection</code> operation.
     * @return A Java Future containing the result of the AcceptInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AcceptInboundConnection
     */
    default CompletableFuture<AcceptInboundConnectionResponse> acceptInboundConnection(
            AcceptInboundConnectionRequest acceptInboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search
     * connection request. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptInboundConnectionRequest#builder()}
     * </p>
     *
     * @param acceptInboundConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest.Builder} to create
     *        a request. Container for the parameters to the <code>AcceptInboundConnection</code> operation.
     * @return A Java Future containing the result of the AcceptInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AcceptInboundConnection
     */
    default CompletableFuture<AcceptInboundConnectionResponse> acceptInboundConnection(
            Consumer<AcceptInboundConnectionRequest.Builder> acceptInboundConnectionRequest) {
        return acceptInboundConnection(AcceptInboundConnectionRequest.builder().applyMutation(acceptInboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new direct-query data source to the specified domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
     * >Creating Amazon OpenSearch Service data source integrations with Amazon S3</a>.
     * </p>
     *
     * @param addDataSourceRequest
     *        Container for the parameters to the <code>AddDataSource</code> operation.
     * @return A Java Future containing the result of the AddDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AddDataSource
     */
    default CompletableFuture<AddDataSourceResponse> addDataSource(AddDataSourceRequest addDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new direct-query data source to the specified domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html"
     * >Creating Amazon OpenSearch Service data source integrations with Amazon S3</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link AddDataSourceRequest#builder()}
     * </p>
     *
     * @param addDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.AddDataSourceRequest.Builder} to create a request.
     *        Container for the parameters to the <code>AddDataSource</code> operation.
     * @return A Java Future containing the result of the AddDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AddDataSource
     */
    default CompletableFuture<AddDataSourceResponse> addDataSource(Consumer<AddDataSourceRequest.Builder> addDataSourceRequest) {
        return addDataSource(AddDataSourceRequest.builder().applyMutation(addDataSourceRequest).build());
    }

    /**
     * <p>
     * Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a set of case-sensitive key-value pairs.
     * A domain can have up to 10 tags. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html"
     * >Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code>AddTags</code> operation. Specifies the tags to attach to the
     *        domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a set of case-sensitive key-value pairs.
     * A domain can have up to 10 tags. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html"
     * >Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.AddTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code>AddTags</code> operation. Specifies the tags to attach to the
     *        domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Associates a package with an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param associatePackageRequest
     *        Container for the request parameters to the <code>AssociatePackage</code> operation.
     * @return A Java Future containing the result of the AssociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AssociatePackage
     */
    default CompletableFuture<AssociatePackageResponse> associatePackage(AssociatePackageRequest associatePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a package with an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePackageRequest.Builder} avoiding the need
     * to create one manually via {@link AssociatePackageRequest#builder()}
     * </p>
     *
     * @param associatePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>AssociatePackage</code> operation.
     * @return A Java Future containing the result of the AssociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AssociatePackage
     */
    default CompletableFuture<AssociatePackageResponse> associatePackage(
            Consumer<AssociatePackageRequest.Builder> associatePackageRequest) {
        return associatePackage(AssociatePackageRequest.builder().applyMutation(associatePackageRequest).build());
    }

    /**
     * <p>
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     *
     * @param authorizeVpcEndpointAccessRequest
     * @return A Java Future containing the result of the AuthorizeVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AuthorizeVpcEndpointAccess
     */
    default CompletableFuture<AuthorizeVpcEndpointAccessResponse> authorizeVpcEndpointAccess(
            AuthorizeVpcEndpointAccessRequest authorizeVpcEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeVpcEndpointAccessRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeVpcEndpointAccessRequest#builder()}
     * </p>
     *
     * @param authorizeVpcEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.AuthorizeVpcEndpointAccessRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AuthorizeVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.AuthorizeVpcEndpointAccess
     */
    default CompletableFuture<AuthorizeVpcEndpointAccessResponse> authorizeVpcEndpointAccess(
            Consumer<AuthorizeVpcEndpointAccessRequest.Builder> authorizeVpcEndpointAccessRequest) {
        return authorizeVpcEndpointAccess(AuthorizeVpcEndpointAccessRequest.builder()
                .applyMutation(authorizeVpcEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Cancels a pending configuration change on an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param cancelDomainConfigChangeRequest
     * @return A Java Future containing the result of the CancelDomainConfigChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CancelDomainConfigChange
     */
    default CompletableFuture<CancelDomainConfigChangeResponse> cancelDomainConfigChange(
            CancelDomainConfigChangeRequest cancelDomainConfigChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending configuration change on an Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDomainConfigChangeRequest.Builder} avoiding
     * the need to create one manually via {@link CancelDomainConfigChangeRequest#builder()}
     * </p>
     *
     * @param cancelDomainConfigChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.CancelDomainConfigChangeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CancelDomainConfigChange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CancelDomainConfigChange
     */
    default CompletableFuture<CancelDomainConfigChangeResponse> cancelDomainConfigChange(
            Consumer<CancelDomainConfigChangeRequest.Builder> cancelDomainConfigChangeRequest) {
        return cancelDomainConfigChange(CancelDomainConfigChangeRequest.builder().applyMutation(cancelDomainConfigChangeRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this
     * operation before the <code>AutomatedUpdateDate</code> and when the domain's <code>UpdateStatus</code> is
     * <code>PENDING_UPDATE</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service
     * software updates in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param cancelServiceSoftwareUpdateRequest
     *        Container for the request parameters to cancel a service software update.
     * @return A Java Future containing the result of the CancelServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CancelServiceSoftwareUpdate
     */
    default CompletableFuture<CancelServiceSoftwareUpdateResponse> cancelServiceSoftwareUpdate(
            CancelServiceSoftwareUpdateRequest cancelServiceSoftwareUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this
     * operation before the <code>AutomatedUpdateDate</code> and when the domain's <code>UpdateStatus</code> is
     * <code>PENDING_UPDATE</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service
     * software updates in Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelServiceSoftwareUpdateRequest.Builder}
     * avoiding the need to create one manually via {@link CancelServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param cancelServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateRequest.Builder} to
     *        create a request. Container for the request parameters to cancel a service software update.
     * @return A Java Future containing the result of the CancelServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CancelServiceSoftwareUpdate
     */
    default CompletableFuture<CancelServiceSoftwareUpdateResponse> cancelServiceSoftwareUpdate(
            Consumer<CancelServiceSoftwareUpdateRequest.Builder> cancelServiceSoftwareUpdateRequest) {
        return cancelServiceSoftwareUpdate(CancelServiceSoftwareUpdateRequest.builder()
                .applyMutation(cancelServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and
     * managing Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateDomain
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and
     * managing Amazon OpenSearch Service domains</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateDomain
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination
     * domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param createOutboundConnectionRequest
     *        Container for the parameters to the <code>CreateOutboundConnection</code> operation.
     * @return A Java Future containing the result of the CreateOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateOutboundConnection
     */
    default CompletableFuture<CreateOutboundConnectionResponse> createOutboundConnection(
            CreateOutboundConnectionRequest createOutboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination
     * domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOutboundConnectionRequest#builder()}
     * </p>
     *
     * @param createOutboundConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.CreateOutboundConnectionRequest.Builder} to create
     *        a request. Container for the parameters to the <code>CreateOutboundConnection</code> operation.
     * @return A Java Future containing the result of the CreateOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateOutboundConnection
     */
    default CompletableFuture<CreateOutboundConnectionResponse> createOutboundConnection(
            Consumer<CreateOutboundConnectionRequest.Builder> createOutboundConnectionRequest) {
        return createOutboundConnection(CreateOutboundConnectionRequest.builder().applyMutation(createOutboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a package for use with Amazon OpenSearch Service domains. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param createPackageRequest
     *        Container for request parameters to the <code>CreatePackage</code> operation.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreatePackage
     */
    default CompletableFuture<CreatePackageResponse> createPackage(CreatePackageRequest createPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a package for use with Amazon OpenSearch Service domains. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePackageRequest#builder()}
     * </p>
     *
     * @param createPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.CreatePackageRequest.Builder} to create a request.
     *        Container for request parameters to the <code>CreatePackage</code> operation.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreatePackage
     */
    default CompletableFuture<CreatePackageResponse> createPackage(Consumer<CreatePackageRequest.Builder> createPackageRequest) {
        return createPackage(CreatePackageRequest.builder().applyMutation(createPackageRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateVpcEndpoint
     */
    default CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.CreateVpcEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.CreateVpcEndpoint
     */
    default CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(
            Consumer<CreateVpcEndpointRequest.Builder> createVpcEndpointRequest) {
        return createVpcEndpoint(CreateVpcEndpointRequest.builder().applyMutation(createVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a direct-query data source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-delete.html">Deleting
     * an Amazon OpenSearch Service data source with Amazon S3</a>.
     * </p>
     *
     * @param deleteDataSourceRequest
     *        Container for the parameters to the <code>DeleteDataSource</code> operation.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteDataSource
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a direct-query data source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-delete.html">Deleting
     * an Amazon OpenSearch Service data source with Amazon S3</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DeleteDataSourceRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DeleteDataSource</code> operation.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteDataSource
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain after you delete it.
     * </p>
     *
     * @param deleteDomainRequest
     *        Container for the parameters to the <code>DeleteDomain</code> operation.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteDomain
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service domain and all of its data. You can't recover a domain after you delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DeleteDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code>DeleteDomain</code> operation.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteDomain
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search
     * connection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param deleteInboundConnectionRequest
     *        Container for the parameters to the <code>DeleteInboundConnection</code> operation.
     * @return A Java Future containing the result of the DeleteInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteInboundConnection
     */
    default CompletableFuture<DeleteInboundConnectionResponse> deleteInboundConnection(
            DeleteInboundConnectionRequest deleteInboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search
     * connection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInboundConnectionRequest#builder()}
     * </p>
     *
     * @param deleteInboundConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest.Builder} to create
     *        a request. Container for the parameters to the <code>DeleteInboundConnection</code> operation.
     * @return A Java Future containing the result of the DeleteInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteInboundConnection
     */
    default CompletableFuture<DeleteInboundConnectionResponse> deleteInboundConnection(
            Consumer<DeleteInboundConnectionRequest.Builder> deleteInboundConnectionRequest) {
        return deleteInboundConnection(DeleteInboundConnectionRequest.builder().applyMutation(deleteInboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search
     * connection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param deleteOutboundConnectionRequest
     *        Container for the parameters to the <code>DeleteOutboundConnection</code> operation.
     * @return A Java Future containing the result of the DeleteOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteOutboundConnection
     */
    default CompletableFuture<DeleteOutboundConnectionResponse> deleteOutboundConnection(
            DeleteOutboundConnectionRequest deleteOutboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search
     * connection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOutboundConnectionRequest#builder()}
     * </p>
     *
     * @param deleteOutboundConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest.Builder} to create
     *        a request. Container for the parameters to the <code>DeleteOutboundConnection</code> operation.
     * @return A Java Future containing the result of the DeleteOutboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteOutboundConnection
     */
    default CompletableFuture<DeleteOutboundConnectionResponse> deleteOutboundConnection(
            Consumer<DeleteOutboundConnectionRequest.Builder> deleteOutboundConnectionRequest) {
        return deleteOutboundConnection(DeleteOutboundConnectionRequest.builder().applyMutation(deleteOutboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service package. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param deletePackageRequest
     *        Deletes a package from OpenSearch Service. The package can't be associated with any OpenSearch Service
     *        domain.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeletePackage
     */
    default CompletableFuture<DeletePackageResponse> deletePackage(DeletePackageRequest deletePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service package. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePackageRequest#builder()}
     * </p>
     *
     * @param deletePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DeletePackageRequest.Builder} to create a request.
     *        Deletes a package from OpenSearch Service. The package can't be associated with any OpenSearch Service
     *        domain.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeletePackage
     */
    default CompletableFuture<DeletePackageResponse> deletePackage(Consumer<DeletePackageRequest.Builder> deletePackageRequest) {
        return deletePackage(DeletePackageRequest.builder().applyMutation(deletePackageRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param deleteVpcEndpointRequest
     * @return A Java Future containing the result of the DeleteVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteVpcEndpoint
     */
    default CompletableFuture<DeleteVpcEndpointResponse> deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVpcEndpointRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DeleteVpcEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DeleteVpcEndpoint
     */
    default CompletableFuture<DeleteVpcEndpointResponse> deleteVpcEndpoint(
            Consumer<DeleteVpcEndpointRequest.Builder> deleteVpcEndpointRequest) {
        return deleteVpcEndpoint(DeleteVpcEndpointRequest.builder().applyMutation(deleteVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID,
     * domain service endpoint, and domain ARN.
     * </p>
     *
     * @param describeDomainRequest
     *        Container for the parameters to the <code>DescribeDomain</code> operation.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomain
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID,
     * domain service endpoint, and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomain</code> operation.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomain
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest) {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon
     * OpenSearch Service</a>.
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainAutoTunes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default CompletableFuture<DescribeDomainAutoTunesResponse> describeDomainAutoTunes(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon
     * OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainAutoTunesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainAutoTunesRequest#builder()}
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest.Builder} to create
     *        a request. Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainAutoTunes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default CompletableFuture<DescribeDomainAutoTunesResponse> describeDomainAutoTunes(
            Consumer<DescribeDomainAutoTunesRequest.Builder> describeDomainAutoTunesRequest) {
        return describeDomainAutoTunes(DescribeDomainAutoTunesRequest.builder().applyMutation(describeDomainAutoTunesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesPublisher describeDomainAutoTunesPaginator(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        return new DescribeDomainAutoTunesPublisher(this, describeDomainAutoTunesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainAutoTunesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainAutoTunesRequest#builder()}
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest.Builder} to create
     *        a request. Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesPublisher describeDomainAutoTunesPaginator(
            Consumer<DescribeDomainAutoTunesRequest.Builder> describeDomainAutoTunesRequest) {
        return describeDomainAutoTunesPaginator(DescribeDomainAutoTunesRequest.builder()
                .applyMutation(describeDomainAutoTunesRequest).build());
    }

    /**
     * <p>
     * Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html"
     * >Making configuration changes in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeDomainChangeProgressRequest
     *        Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation.
     * @return A Java Future containing the result of the DescribeDomainChangeProgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainChangeProgress
     */
    default CompletableFuture<DescribeDomainChangeProgressResponse> describeDomainChangeProgress(
            DescribeDomainChangeProgressRequest describeDomainChangeProgressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html"
     * >Making configuration changes in Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainChangeProgressRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDomainChangeProgressRequest#builder()}
     * </p>
     *
     * @param describeDomainChangeProgressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation.
     * @return A Java Future containing the result of the DescribeDomainChangeProgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainChangeProgress
     */
    default CompletableFuture<DescribeDomainChangeProgressResponse> describeDomainChangeProgress(
            Consumer<DescribeDomainChangeProgressRequest.Builder> describeDomainChangeProgressRequest) {
        return describeDomainChangeProgress(DescribeDomainChangeProgressRequest.builder()
                .applyMutation(describeDomainChangeProgressRequest).build());
    }

    /**
     * <p>
     * Returns the configuration of an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param describeDomainConfigRequest
     *        Container for the parameters to the <code>DescribeDomainConfig</code> operation.
     * @return A Java Future containing the result of the DescribeDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainConfig
     */
    default CompletableFuture<DescribeDomainConfigResponse> describeDomainConfig(
            DescribeDomainConfigRequest describeDomainConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration of an Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDomainConfigRequest#builder()}
     * </p>
     *
     * @param describeDomainConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainConfig</code> operation.
     * @return A Java Future containing the result of the DescribeDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainConfig
     */
    default CompletableFuture<DescribeDomainConfigResponse> describeDomainConfig(
            Consumer<DescribeDomainConfigRequest.Builder> describeDomainConfigRequest) {
        return describeDomainConfig(DescribeDomainConfigRequest.builder().applyMutation(describeDomainConfigRequest).build());
    }

    /**
     * <p>
     * Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability
     * Zone, and shard count per node.
     * </p>
     *
     * @param describeDomainHealthRequest
     *        Container for the parameters to the <code>DescribeDomainHealth</code> operation.
     * @return A Java Future containing the result of the DescribeDomainHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainHealth
     */
    default CompletableFuture<DescribeDomainHealthResponse> describeDomainHealth(
            DescribeDomainHealthRequest describeDomainHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability
     * Zone, and shard count per node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainHealthRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDomainHealthRequest#builder()}
     * </p>
     *
     * @param describeDomainHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainHealthRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainHealth</code> operation.
     * @return A Java Future containing the result of the DescribeDomainHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainHealth
     */
    default CompletableFuture<DescribeDomainHealthResponse> describeDomainHealth(
            Consumer<DescribeDomainHealthRequest.Builder> describeDomainHealthRequest) {
        return describeDomainHealth(DescribeDomainHealthRequest.builder().applyMutation(describeDomainHealthRequest).build());
    }

    /**
     * <p>
     * Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability
     * Zone(s), standby nodes, node configurations, and node states.
     * </p>
     *
     * @param describeDomainNodesRequest
     *        Container for the parameters to the <code>DescribeDomainNodes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainNodes
     */
    default CompletableFuture<DescribeDomainNodesResponse> describeDomainNodes(
            DescribeDomainNodesRequest describeDomainNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability
     * Zone(s), standby nodes, node configurations, and node states.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDomainNodesRequest#builder()}
     * </p>
     *
     * @param describeDomainNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainNodesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainNodes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomainNodes
     */
    default CompletableFuture<DescribeDomainNodesResponse> describeDomainNodes(
            Consumer<DescribeDomainNodesRequest.Builder> describeDomainNodesRequest) {
        return describeDomainNodes(DescribeDomainNodesRequest.builder().applyMutation(describeDomainNodesRequest).build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Amazon OpenSearch Service domains.
     * </p>
     *
     * @param describeDomainsRequest
     *        Container for the parameters to the <code>DescribeDomains</code> operation.
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Amazon OpenSearch Service domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDomainsRequest#builder()}
     * </p>
     *
     * @param describeDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDomainsRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomains</code> operation.
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains(
            Consumer<DescribeDomainsRequest.Builder> describeDomainsRequest) {
        return describeDomains(DescribeDomainsRequest.builder().applyMutation(describeDomainsRequest).build());
    }

    /**
     * <p>
     * Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun"
     * >Determining whether a change will cause a blue/green deployment</a>.
     * </p>
     *
     * @param describeDryRunProgressRequest
     * @return A Java Future containing the result of the DescribeDryRunProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDryRunProgress
     */
    default CompletableFuture<DescribeDryRunProgressResponse> describeDryRunProgress(
            DescribeDryRunProgressRequest describeDryRunProgressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun"
     * >Determining whether a change will cause a blue/green deployment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDryRunProgressRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDryRunProgressRequest#builder()}
     * </p>
     *
     * @param describeDryRunProgressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeDryRunProgressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDryRunProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeDryRunProgress
     */
    default CompletableFuture<DescribeDryRunProgressResponse> describeDryRunProgress(
            Consumer<DescribeDryRunProgressRequest.Builder> describeDryRunProgressRequest) {
        return describeDryRunProgress(DescribeDryRunProgressRequest.builder().applyMutation(describeDryRunProgressRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service
     * domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        Container for the parameters to the <code>DescribeInboundConnections</code> operation.
     * @return A Java Future containing the result of the DescribeInboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default CompletableFuture<DescribeInboundConnectionsResponse> describeInboundConnections(
            DescribeInboundConnectionsRequest describeInboundConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service
     * domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeInboundConnections</code> operation.
     * @return A Java Future containing the result of the DescribeInboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default CompletableFuture<DescribeInboundConnectionsResponse> describeInboundConnections(
            Consumer<DescribeInboundConnectionsRequest.Builder> describeInboundConnectionsRequest) {
        return describeInboundConnections(DescribeInboundConnectionsRequest.builder()
                .applyMutation(describeInboundConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        Container for the parameters to the <code>DescribeInboundConnections</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default DescribeInboundConnectionsPublisher describeInboundConnectionsPaginator(
            DescribeInboundConnectionsRequest describeInboundConnectionsRequest) {
        return new DescribeInboundConnectionsPublisher(this, describeInboundConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeInboundConnectionsPublisher publisher = client.describeInboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeInboundConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeInboundConnections</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInboundConnections
     */
    default DescribeInboundConnectionsPublisher describeInboundConnectionsPaginator(
            Consumer<DescribeInboundConnectionsRequest.Builder> describeInboundConnectionsRequest) {
        return describeInboundConnectionsPaginator(DescribeInboundConnectionsRequest.builder()
                .applyMutation(describeInboundConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and
     * instance type.
     * </p>
     *
     * @param describeInstanceTypeLimitsRequest
     *        Container for the parameters to the <code>DescribeInstanceTypeLimits</code> operation.
     * @return A Java Future containing the result of the DescribeInstanceTypeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInstanceTypeLimits
     */
    default CompletableFuture<DescribeInstanceTypeLimitsResponse> describeInstanceTypeLimits(
            DescribeInstanceTypeLimitsRequest describeInstanceTypeLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and
     * instance type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceTypeLimitsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceTypeLimitsRequest#builder()}
     * </p>
     *
     * @param describeInstanceTypeLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeInstanceTypeLimits</code> operation.
     * @return A Java Future containing the result of the DescribeInstanceTypeLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeInstanceTypeLimits
     */
    default CompletableFuture<DescribeInstanceTypeLimitsResponse> describeInstanceTypeLimits(
            Consumer<DescribeInstanceTypeLimitsRequest.Builder> describeInstanceTypeLimitsRequest) {
        return describeInstanceTypeLimits(DescribeInstanceTypeLimitsRequest.builder()
                .applyMutation(describeInstanceTypeLimitsRequest).build());
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        Container for the parameters to the <code>DescribeOutboundConnections</code> operation.
     * @return A Java Future containing the result of the DescribeOutboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default CompletableFuture<DescribeOutboundConnectionsResponse> describeOutboundConnections(
            DescribeOutboundConnectionsRequest describeOutboundConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html"
     * >Cross-cluster search for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOutboundConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOutboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeOutboundConnections</code> operation.
     * @return A Java Future containing the result of the DescribeOutboundConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default CompletableFuture<DescribeOutboundConnectionsResponse> describeOutboundConnections(
            Consumer<DescribeOutboundConnectionsRequest.Builder> describeOutboundConnectionsRequest) {
        return describeOutboundConnections(DescribeOutboundConnectionsRequest.builder()
                .applyMutation(describeOutboundConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        Container for the parameters to the <code>DescribeOutboundConnections</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default DescribeOutboundConnectionsPublisher describeOutboundConnectionsPaginator(
            DescribeOutboundConnectionsRequest describeOutboundConnectionsRequest) {
        return new DescribeOutboundConnectionsPublisher(this, describeOutboundConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeOutboundConnectionsPublisher publisher = client.describeOutboundConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundConnections(software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOutboundConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOutboundConnectionsRequest#builder()}
     * </p>
     *
     * @param describeOutboundConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeOutboundConnections</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeOutboundConnections
     */
    default DescribeOutboundConnectionsPublisher describeOutboundConnectionsPaginator(
            Consumer<DescribeOutboundConnectionsRequest.Builder> describeOutboundConnectionsRequest) {
        return describeOutboundConnectionsPaginator(DescribeOutboundConnectionsRequest.builder()
                .applyMutation(describeOutboundConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes all packages available to OpenSearch Service. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describePackagesRequest
     *        Container for the request parameters to the <code>DescribePackage</code> operation.
     * @return A Java Future containing the result of the DescribePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default CompletableFuture<DescribePackagesResponse> describePackages(DescribePackagesRequest describePackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all packages available to OpenSearch Service. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackagesRequest#builder()}
     * </p>
     *
     * @param describePackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>DescribePackage</code> operation.
     * @return A Java Future containing the result of the DescribePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default CompletableFuture<DescribePackagesResponse> describePackages(
            Consumer<DescribePackagesRequest.Builder> describePackagesRequest) {
        return describePackages(DescribePackagesRequest.builder().applyMutation(describePackagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePackagesRequest
     *        Container for the request parameters to the <code>DescribePackage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default DescribePackagesPublisher describePackagesPaginator(DescribePackagesRequest describePackagesRequest) {
        return new DescribePackagesPublisher(this, describePackagesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackagesRequest#builder()}
     * </p>
     *
     * @param describePackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>DescribePackage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribePackages
     */
    default DescribePackagesPublisher describePackagesPaginator(Consumer<DescribePackagesRequest.Builder> describePackagesRequest) {
        return describePackagesPaginator(DescribePackagesRequest.builder().applyMutation(describePackagesRequest).build());
    }

    /**
     * <p>
     * Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more
     * information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved
     * Instances in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        Container for the request parameters to a <code>DescribeReservedInstanceOfferings</code> operation.
     * @return A Java Future containing the result of the DescribeReservedInstanceOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default CompletableFuture<DescribeReservedInstanceOfferingsResponse> describeReservedInstanceOfferings(
            DescribeReservedInstanceOfferingsRequest describeReservedInstanceOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more
     * information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved
     * Instances in Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstanceOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest.Builder}
     *        to create a request. Container for the request parameters to a
     *        <code>DescribeReservedInstanceOfferings</code> operation.
     * @return A Java Future containing the result of the DescribeReservedInstanceOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default CompletableFuture<DescribeReservedInstanceOfferingsResponse> describeReservedInstanceOfferings(
            Consumer<DescribeReservedInstanceOfferingsRequest.Builder> describeReservedInstanceOfferingsRequest) {
        return describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsRequest.builder()
                .applyMutation(describeReservedInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        Container for the request parameters to a <code>DescribeReservedInstanceOfferings</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default DescribeReservedInstanceOfferingsPublisher describeReservedInstanceOfferingsPaginator(
            DescribeReservedInstanceOfferingsRequest describeReservedInstanceOfferingsRequest) {
        return new DescribeReservedInstanceOfferingsPublisher(this, describeReservedInstanceOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstanceOfferingsPublisher publisher = client.describeReservedInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstanceOfferings(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstanceOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest.Builder}
     *        to create a request. Container for the request parameters to a
     *        <code>DescribeReservedInstanceOfferings</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstanceOfferings
     */
    default DescribeReservedInstanceOfferingsPublisher describeReservedInstanceOfferingsPaginator(
            Consumer<DescribeReservedInstanceOfferingsRequest.Builder> describeReservedInstanceOfferingsRequest) {
        return describeReservedInstanceOfferingsPaginator(DescribeReservedInstanceOfferingsRequest.builder()
                .applyMutation(describeReservedInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information,
     * see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved Instances in
     * Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Container for the request parameters to the <code>DescribeReservedInstances</code> operation.
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default CompletableFuture<DescribeReservedInstancesResponse> describeReservedInstances(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information,
     * see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved Instances in
     * Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest.Builder} to
     *        create a request. Container for the request parameters to the <code>DescribeReservedInstances</code>
     *        operation.
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default CompletableFuture<DescribeReservedInstancesResponse> describeReservedInstances(
            Consumer<DescribeReservedInstancesRequest.Builder> describeReservedInstancesRequest) {
        return describeReservedInstances(DescribeReservedInstancesRequest.builder()
                .applyMutation(describeReservedInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Container for the request parameters to the <code>DescribeReservedInstances</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default DescribeReservedInstancesPublisher describeReservedInstancesPaginator(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        return new DescribeReservedInstancesPublisher(this, describeReservedInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.DescribeReservedInstancesPublisher publisher = client.describeReservedInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstances(software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest.Builder} to
     *        create a request. Container for the request parameters to the <code>DescribeReservedInstances</code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeReservedInstances
     */
    default DescribeReservedInstancesPublisher describeReservedInstancesPaginator(
            Consumer<DescribeReservedInstancesRequest.Builder> describeReservedInstancesRequest) {
        return describeReservedInstancesPaginator(DescribeReservedInstancesRequest.builder()
                .applyMutation(describeReservedInstancesRequest).build());
    }

    /**
     * <p>
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     * </p>
     *
     * @param describeVpcEndpointsRequest
     * @return A Java Future containing the result of the DescribeVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeVpcEndpoints
     */
    default CompletableFuture<DescribeVpcEndpointsResponse> describeVpcEndpoints(
            DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param describeVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DescribeVpcEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DescribeVpcEndpoints
     */
    default CompletableFuture<DescribeVpcEndpointsResponse> describeVpcEndpoints(
            Consumer<DescribeVpcEndpointsRequest.Builder> describeVpcEndpointsRequest) {
        return describeVpcEndpoints(DescribeVpcEndpointsRequest.builder().applyMutation(describeVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any
     * OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for
     * association later. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param dissociatePackageRequest
     *        Container for the request parameters to the <code>DissociatePackage</code> operation.
     * @return A Java Future containing the result of the DissociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DissociatePackage
     */
    default CompletableFuture<DissociatePackageResponse> dissociatePackage(DissociatePackageRequest dissociatePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any
     * OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for
     * association later. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DissociatePackageRequest.Builder} avoiding the need
     * to create one manually via {@link DissociatePackageRequest#builder()}
     * </p>
     *
     * @param dissociatePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.DissociatePackageRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>DissociatePackage</code> operation.
     * @return A Java Future containing the result of the DissociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.DissociatePackage
     */
    default CompletableFuture<DissociatePackageResponse> dissociatePackage(
            Consumer<DissociatePackageRequest.Builder> dissociatePackageRequest) {
        return dissociatePackage(DissociatePackageRequest.builder().applyMutation(dissociatePackageRequest).build());
    }

    /**
     * <p>
     * Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
     * </p>
     *
     * @param getCompatibleVersionsRequest
     *        Container for the request parameters to <code>GetCompatibleVersions</code> operation.
     * @return A Java Future containing the result of the GetCompatibleVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetCompatibleVersions
     */
    default CompletableFuture<GetCompatibleVersionsResponse> getCompatibleVersions(
            GetCompatibleVersionsRequest getCompatibleVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompatibleVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCompatibleVersionsRequest#builder()}
     * </p>
     *
     * @param getCompatibleVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsRequest.Builder} to create a
     *        request. Container for the request parameters to <code>GetCompatibleVersions</code> operation.
     * @return A Java Future containing the result of the GetCompatibleVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetCompatibleVersions
     */
    default CompletableFuture<GetCompatibleVersionsResponse> getCompatibleVersions(
            Consumer<GetCompatibleVersionsRequest.Builder> getCompatibleVersionsRequest) {
        return getCompatibleVersions(GetCompatibleVersionsRequest.builder().applyMutation(getCompatibleVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a direct query data source.
     * </p>
     *
     * @param getDataSourceRequest
     *        Container for the parameters to the <code>GetDataSource</code> operation.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetDataSource
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a direct query data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetDataSourceRequest.Builder} to create a request.
     *        Container for the parameters to the <code>GetDataSource</code> operation.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetDataSource
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * The status of the maintenance action.
     * </p>
     *
     * @param getDomainMaintenanceStatusRequest
     *        Container for the parameters to the <code>GetDomainMaintenanceStatus</code> operation.
     * @return A Java Future containing the result of the GetDomainMaintenanceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetDomainMaintenanceStatus
     */
    default CompletableFuture<GetDomainMaintenanceStatusResponse> getDomainMaintenanceStatus(
            GetDomainMaintenanceStatusRequest getDomainMaintenanceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The status of the maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainMaintenanceStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetDomainMaintenanceStatusRequest#builder()}
     * </p>
     *
     * @param getDomainMaintenanceStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetDomainMaintenanceStatusRequest.Builder} to
     *        create a request. Container for the parameters to the <code>GetDomainMaintenanceStatus</code> operation.
     * @return A Java Future containing the result of the GetDomainMaintenanceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetDomainMaintenanceStatus
     */
    default CompletableFuture<GetDomainMaintenanceStatusResponse> getDomainMaintenanceStatus(
            Consumer<GetDomainMaintenanceStatusRequest.Builder> getDomainMaintenanceStatusRequest) {
        return getDomainMaintenanceStatus(GetDomainMaintenanceStatusRequest.builder()
                .applyMutation(getDomainMaintenanceStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and
     * plugin properties (if the package is a zip plugin package). For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for the request parameters to the <code>GetPackageVersionHistory</code> operation.
     * @return A Java Future containing the result of the GetPackageVersionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default CompletableFuture<GetPackageVersionHistoryResponse> getPackageVersionHistory(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and
     * plugin properties (if the package is a zip plugin package). For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionHistoryRequest#builder()}
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest.Builder} to create
     *        a request. Container for the request parameters to the <code>GetPackageVersionHistory</code> operation.
     * @return A Java Future containing the result of the GetPackageVersionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default CompletableFuture<GetPackageVersionHistoryResponse> getPackageVersionHistory(
            Consumer<GetPackageVersionHistoryRequest.Builder> getPackageVersionHistoryRequest) {
        return getPackageVersionHistory(GetPackageVersionHistoryRequest.builder().applyMutation(getPackageVersionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for the request parameters to the <code>GetPackageVersionHistory</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryPublisher getPackageVersionHistoryPaginator(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        return new GetPackageVersionHistoryPublisher(this, getPackageVersionHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionHistoryRequest#builder()}
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryRequest.Builder} to create
     *        a request. Container for the request parameters to the <code>GetPackageVersionHistory</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryPublisher getPackageVersionHistoryPaginator(
            Consumer<GetPackageVersionHistoryRequest.Builder> getPackageVersionHistoryRequest) {
        return getPackageVersionHistoryPaginator(GetPackageVersionHistoryRequest.builder()
                .applyMutation(getPackageVersionHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for the request parameters to the <code>GetUpgradeHistory</code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>GetUpgradeHistory</code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) {
        return getUpgradeHistory(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for the request parameters to the <code>GetUpgradeHistory</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        return new GetUpgradeHistoryPublisher(this, getUpgradeHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>GetUpgradeHistory</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) {
        return getUpgradeHistoryPaginator(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch
     * Service domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for the request parameters to the <code>GetUpgradeStatus</code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeStatus
     */
    default CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch
     * Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeStatusRequest#builder()}
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>GetUpgradeStatus</code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.GetUpgradeStatus
     */
    default CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(
            Consumer<GetUpgradeStatusRequest.Builder> getUpgradeStatusRequest) {
        return getUpgradeStatus(GetUpgradeStatusRequest.builder().applyMutation(getUpgradeStatusRequest).build());
    }

    /**
     * <p>
     * Lists direct-query data sources for a specific domain. For more information, see For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html">Working with
     * Amazon OpenSearch Service direct queries with Amazon S3</a>.
     * </p>
     *
     * @param listDataSourcesRequest
     *        Container for the parameters to the <code>ListDataSources</code> operation.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDataSources
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists direct-query data sources for a specific domain. For more information, see For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html">Working with
     * Amazon OpenSearch Service direct queries with Amazon S3</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListDataSourcesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>ListDataSources</code> operation.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDataSources
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * A list of maintenance actions for the domain.
     * </p>
     *
     * @param listDomainMaintenancesRequest
     *        Container for the parameters to the <code>ListDomainMaintenances</code> operation.
     * @return A Java Future containing the result of the ListDomainMaintenances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainMaintenances
     */
    default CompletableFuture<ListDomainMaintenancesResponse> listDomainMaintenances(
            ListDomainMaintenancesRequest listDomainMaintenancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of maintenance actions for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainMaintenancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainMaintenancesRequest#builder()}
     * </p>
     *
     * @param listDomainMaintenancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>ListDomainMaintenances</code> operation.
     * @return A Java Future containing the result of the ListDomainMaintenances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainMaintenances
     */
    default CompletableFuture<ListDomainMaintenancesResponse> listDomainMaintenances(
            Consumer<ListDomainMaintenancesRequest.Builder> listDomainMaintenancesRequest) {
        return listDomainMaintenances(ListDomainMaintenancesRequest.builder().applyMutation(listDomainMaintenancesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainMaintenances(software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainMaintenancesPublisher publisher = client.listDomainMaintenancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainMaintenancesPublisher publisher = client.listDomainMaintenancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainMaintenances(software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainMaintenancesRequest
     *        Container for the parameters to the <code>ListDomainMaintenances</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainMaintenances
     */
    default ListDomainMaintenancesPublisher listDomainMaintenancesPaginator(
            ListDomainMaintenancesRequest listDomainMaintenancesRequest) {
        return new ListDomainMaintenancesPublisher(this, listDomainMaintenancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainMaintenances(software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainMaintenancesPublisher publisher = client.listDomainMaintenancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainMaintenancesPublisher publisher = client.listDomainMaintenancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainMaintenances(software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainMaintenancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainMaintenancesRequest#builder()}
     * </p>
     *
     * @param listDomainMaintenancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>ListDomainMaintenances</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainMaintenances
     */
    default ListDomainMaintenancesPublisher listDomainMaintenancesPaginator(
            Consumer<ListDomainMaintenancesRequest.Builder> listDomainMaintenancesRequest) {
        return listDomainMaintenancesPaginator(ListDomainMaintenancesRequest.builder()
                .applyMutation(listDomainMaintenancesRequest).build());
    }

    /**
     * <p>
     * Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.
     * </p>
     *
     * @param listDomainNamesRequest
     *        Container for the parameters to the <code>ListDomainNames</code> operation.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListDomainNamesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>ListDomainNames</code> operation.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(
            Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest) {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for the request parameters to the <code>ListDomainsForPackage</code> operation.
     * @return A Java Future containing the result of the ListDomainsForPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default CompletableFuture<ListDomainsForPackageResponse> listDomainsForPackage(
            ListDomainsForPackageRequest listDomainsForPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsForPackageRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainsForPackageRequest#builder()}
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>ListDomainsForPackage</code> operation.
     * @return A Java Future containing the result of the ListDomainsForPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default CompletableFuture<ListDomainsForPackageResponse> listDomainsForPackage(
            Consumer<ListDomainsForPackageRequest.Builder> listDomainsForPackageRequest) {
        return listDomainsForPackage(ListDomainsForPackageRequest.builder().applyMutation(listDomainsForPackageRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for the request parameters to the <code>ListDomainsForPackage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default ListDomainsForPackagePublisher listDomainsForPackagePaginator(
            ListDomainsForPackageRequest listDomainsForPackageRequest) {
        return new ListDomainsForPackagePublisher(this, listDomainsForPackageRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsForPackageRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainsForPackageRequest#builder()}
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListDomainsForPackageRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>ListDomainsForPackage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListDomainsForPackage
     */
    default ListDomainsForPackagePublisher listDomainsForPackagePaginator(
            Consumer<ListDomainsForPackageRequest.Builder> listDomainsForPackageRequest) {
        return listDomainsForPackagePaginator(ListDomainsForPackageRequest.builder().applyMutation(listDomainsForPackageRequest)
                .build());
    }

    /**
     * <p>
     * Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     * @return A Java Future containing the result of the ListInstanceTypeDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default CompletableFuture<ListInstanceTypeDetailsResponse> listInstanceTypeDetails(
            ListInstanceTypeDetailsRequest listInstanceTypeDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all instance types and available features for a given OpenSearch or Elasticsearch version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypeDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceTypeDetailsRequest#builder()}
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListInstanceTypeDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default CompletableFuture<ListInstanceTypeDetailsResponse> listInstanceTypeDetails(
            Consumer<ListInstanceTypeDetailsRequest.Builder> listInstanceTypeDetailsRequest) {
        return listInstanceTypeDetails(ListInstanceTypeDetailsRequest.builder().applyMutation(listInstanceTypeDetailsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default ListInstanceTypeDetailsPublisher listInstanceTypeDetailsPaginator(
            ListInstanceTypeDetailsRequest listInstanceTypeDetailsRequest) {
        return new ListInstanceTypeDetailsPublisher(this, listInstanceTypeDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListInstanceTypeDetailsPublisher publisher = client.listInstanceTypeDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypeDetails(software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypeDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceTypeDetailsRequest#builder()}
     * </p>
     *
     * @param listInstanceTypeDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListInstanceTypeDetails
     */
    default ListInstanceTypeDetailsPublisher listInstanceTypeDetailsPaginator(
            Consumer<ListInstanceTypeDetailsRequest.Builder> listInstanceTypeDetailsRequest) {
        return listInstanceTypeDetailsPaginator(ListInstanceTypeDetailsRequest.builder()
                .applyMutation(listInstanceTypeDetailsRequest).build());
    }

    /**
     * <p>
     * Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for the request parameters to the <code>ListPackagesForDomain</code> operation.
     * @return A Java Future containing the result of the ListPackagesForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default CompletableFuture<ListPackagesForDomainResponse> listPackagesForDomain(
            ListPackagesForDomainRequest listPackagesForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagesForDomainRequest#builder()}
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>ListPackagesForDomain</code> operation.
     * @return A Java Future containing the result of the ListPackagesForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default CompletableFuture<ListPackagesForDomainResponse> listPackagesForDomain(
            Consumer<ListPackagesForDomainRequest.Builder> listPackagesForDomainRequest) {
        return listPackagesForDomain(ListPackagesForDomainRequest.builder().applyMutation(listPackagesForDomainRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for the request parameters to the <code>ListPackagesForDomain</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default ListPackagesForDomainPublisher listPackagesForDomainPaginator(
            ListPackagesForDomainRequest listPackagesForDomainRequest) {
        return new ListPackagesForDomainPublisher(this, listPackagesForDomainRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagesForDomainRequest#builder()}
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>ListPackagesForDomain</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListPackagesForDomain
     */
    default ListPackagesForDomainPublisher listPackagesForDomainPaginator(
            Consumer<ListPackagesForDomainRequest.Builder> listPackagesForDomainRequest) {
        return listPackagesForDomainPaginator(ListPackagesForDomainRequest.builder().applyMutation(listPackagesForDomainRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of configuration changes that are scheduled for a domain. These changes can be <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service
     * software updates</a> or <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types"
     * >blue/green Auto-Tune enhancements</a>.
     * </p>
     *
     * @param listScheduledActionsRequest
     * @return A Java Future containing the result of the ListScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListScheduledActions
     */
    default CompletableFuture<ListScheduledActionsResponse> listScheduledActions(
            ListScheduledActionsRequest listScheduledActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configuration changes that are scheduled for a domain. These changes can be <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service
     * software updates</a> or <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types"
     * >blue/green Auto-Tune enhancements</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduledActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduledActionsRequest#builder()}
     * </p>
     *
     * @param listScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListScheduledActions
     */
    default CompletableFuture<ListScheduledActionsResponse> listScheduledActions(
            Consumer<ListScheduledActionsRequest.Builder> listScheduledActionsRequest) {
        return listScheduledActions(ListScheduledActionsRequest.builder().applyMutation(listScheduledActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScheduledActions(software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScheduledActions(software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listScheduledActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListScheduledActions
     */
    default ListScheduledActionsPublisher listScheduledActionsPaginator(ListScheduledActionsRequest listScheduledActionsRequest) {
        return new ListScheduledActionsPublisher(this, listScheduledActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScheduledActions(software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListScheduledActionsPublisher publisher = client.listScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScheduledActions(software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduledActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduledActionsRequest#builder()}
     * </p>
     *
     * @param listScheduledActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InvalidPaginationTokenException Request processing failed because you provided an invalid pagination
     *         token.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListScheduledActions
     */
    default ListScheduledActionsPublisher listScheduledActionsPaginator(
            Consumer<ListScheduledActionsRequest.Builder> listScheduledActionsRequest) {
        return listScheduledActionsPaginator(ListScheduledActionsRequest.builder().applyMutation(listScheduledActionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns all resource tags for an Amazon OpenSearch Service domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html"
     * >Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code>ListTags</code> operation.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListTags
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all resource tags for an Amazon OpenSearch Service domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html"
     * >Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code>ListTags</code> operation.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListTags
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.
     * </p>
     *
     * @param listVersionsRequest
     *        Container for the request parameters to the <code>ListVersions</code> operation.
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default CompletableFuture<ListVersionsResponse> listVersions(ListVersionsRequest listVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListVersionsRequest.Builder} to create a request.
     *        Container for the request parameters to the <code>ListVersions</code> operation.
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default CompletableFuture<ListVersionsResponse> listVersions(Consumer<ListVersionsRequest.Builder> listVersionsRequest) {
        return listVersions(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listVersionsRequest
     *        Container for the request parameters to the <code>ListVersions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default ListVersionsPublisher listVersionsPaginator(ListVersionsRequest listVersionsRequest) {
        return new ListVersionsPublisher(this, listVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearch.paginators.ListVersionsPublisher publisher = client.listVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearch.model.ListVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearch.model.ListVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersions(software.amazon.awssdk.services.opensearch.model.ListVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVersionsRequest#builder()}
     * </p>
     *
     * @param listVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListVersionsRequest.Builder} to create a request.
     *        Container for the request parameters to the <code>ListVersions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVersions
     */
    default ListVersionsPublisher listVersionsPaginator(Consumer<ListVersionsRequest.Builder> listVersionsRequest) {
        return listVersionsPaginator(ListVersionsRequest.builder().applyMutation(listVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon
     * OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     *
     * @param listVpcEndpointAccessRequest
     * @return A Java Future containing the result of the ListVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVpcEndpointAccess
     */
    default CompletableFuture<ListVpcEndpointAccessResponse> listVpcEndpointAccess(
            ListVpcEndpointAccessRequest listVpcEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon
     * OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpcEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListVpcEndpointAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVpcEndpointAccess
     */
    default CompletableFuture<ListVpcEndpointAccessResponse> listVpcEndpointAccess(
            Consumer<ListVpcEndpointAccessRequest.Builder> listVpcEndpointAccessRequest) {
        return listVpcEndpointAccess(ListVpcEndpointAccessRequest.builder().applyMutation(listVpcEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and
     * Region.
     * </p>
     *
     * @param listVpcEndpointsRequest
     * @return A Java Future containing the result of the ListVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVpcEndpoints
     */
    default CompletableFuture<ListVpcEndpointsResponse> listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVpcEndpoints
     */
    default CompletableFuture<ListVpcEndpointsResponse> listVpcEndpoints(
            Consumer<ListVpcEndpointsRequest.Builder> listVpcEndpointsRequest) {
        return listVpcEndpoints(ListVpcEndpointsRequest.builder().applyMutation(listVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     * </p>
     *
     * @param listVpcEndpointsForDomainRequest
     * @return A Java Future containing the result of the ListVpcEndpointsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVpcEndpointsForDomain
     */
    default CompletableFuture<ListVpcEndpointsForDomainResponse> listVpcEndpointsForDomain(
            ListVpcEndpointsForDomainRequest listVpcEndpointsForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsForDomainRequest.Builder} avoiding
     * the need to create one manually via {@link ListVpcEndpointsForDomainRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsForDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.ListVpcEndpointsForDomainRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListVpcEndpointsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.ListVpcEndpointsForDomain
     */
    default CompletableFuture<ListVpcEndpointsForDomainResponse> listVpcEndpointsForDomain(
            Consumer<ListVpcEndpointsForDomainRequest.Builder> listVpcEndpointsForDomainRequest) {
        return listVpcEndpointsForDomain(ListVpcEndpointsForDomainRequest.builder()
                .applyMutation(listVpcEndpointsForDomainRequest).build());
    }

    /**
     * <p>
     * Allows you to purchase Amazon OpenSearch Service Reserved Instances.
     * </p>
     *
     * @param purchaseReservedInstanceOfferingRequest
     *        Container for request parameters to the <code>PurchaseReservedInstanceOffering</code> operation.
     * @return A Java Future containing the result of the PurchaseReservedInstanceOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.PurchaseReservedInstanceOffering
     */
    default CompletableFuture<PurchaseReservedInstanceOfferingResponse> purchaseReservedInstanceOffering(
            PurchaseReservedInstanceOfferingRequest purchaseReservedInstanceOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase Amazon OpenSearch Service Reserved Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseReservedInstanceOfferingRequest.Builder}
     * avoiding the need to create one manually via {@link PurchaseReservedInstanceOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedInstanceOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.PurchaseReservedInstanceOfferingRequest.Builder}
     *        to create a request. Container for request parameters to the <code>PurchaseReservedInstanceOffering</code>
     *        operation.
     * @return A Java Future containing the result of the PurchaseReservedInstanceOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.PurchaseReservedInstanceOffering
     */
    default CompletableFuture<PurchaseReservedInstanceOfferingResponse> purchaseReservedInstanceOffering(
            Consumer<PurchaseReservedInstanceOfferingRequest.Builder> purchaseReservedInstanceOfferingRequest) {
        return purchaseReservedInstanceOffering(PurchaseReservedInstanceOfferingRequest.builder()
                .applyMutation(purchaseReservedInstanceOfferingRequest).build());
    }

    /**
     * <p>
     * Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.
     * </p>
     *
     * @param rejectInboundConnectionRequest
     *        Container for the request parameters to the <code>RejectInboundConnection</code> operation.
     * @return A Java Future containing the result of the RejectInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RejectInboundConnection
     */
    default CompletableFuture<RejectInboundConnectionResponse> rejectInboundConnection(
            RejectInboundConnectionRequest rejectInboundConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectInboundConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link RejectInboundConnectionRequest#builder()}
     * </p>
     *
     * @param rejectInboundConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.RejectInboundConnectionRequest.Builder} to create
     *        a request. Container for the request parameters to the <code>RejectInboundConnection</code> operation.
     * @return A Java Future containing the result of the RejectInboundConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RejectInboundConnection
     */
    default CompletableFuture<RejectInboundConnectionResponse> rejectInboundConnection(
            Consumer<RejectInboundConnectionRequest.Builder> rejectInboundConnectionRequest) {
        return rejectInboundConnection(RejectInboundConnectionRequest.builder().applyMutation(rejectInboundConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Removes the specified set of tags from an Amazon OpenSearch Service domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging"
     * > Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the request parameters to the <code>RemoveTags</code> operation.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RemoveTags
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified set of tags from an Amazon OpenSearch Service domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging"
     * > Tagging Amazon OpenSearch Service domains</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.RemoveTagsRequest.Builder} to create a request.
     *        Container for the request parameters to the <code>RemoveTags</code> operation.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RemoveTags
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * </p>
     *
     * @param revokeVpcEndpointAccessRequest
     * @return A Java Future containing the result of the RevokeVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RevokeVpcEndpointAccess
     */
    default CompletableFuture<RevokeVpcEndpointAccessResponse> revokeVpcEndpointAccess(
            RevokeVpcEndpointAccessRequest revokeVpcEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeVpcEndpointAccessRequest.Builder} avoiding
     * the need to create one manually via {@link RevokeVpcEndpointAccessRequest#builder()}
     * </p>
     *
     * @param revokeVpcEndpointAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.RevokeVpcEndpointAccessRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RevokeVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.RevokeVpcEndpointAccess
     */
    default CompletableFuture<RevokeVpcEndpointAccessResponse> revokeVpcEndpointAccess(
            Consumer<RevokeVpcEndpointAccessRequest.Builder> revokeVpcEndpointAccessRequest) {
        return revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest.builder().applyMutation(revokeVpcEndpointAccessRequest)
                .build());
    }

    /**
     * <p>
     * Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or
     * Elasticsearch process restart, or a Dashboard or Kibana restart.
     * </p>
     *
     * @param startDomainMaintenanceRequest
     *        Container for the parameters to the <code>StartDomainMaintenance</code> operation.
     * @return A Java Future containing the result of the StartDomainMaintenance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.StartDomainMaintenance
     */
    default CompletableFuture<StartDomainMaintenanceResponse> startDomainMaintenance(
            StartDomainMaintenanceRequest startDomainMaintenanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or
     * Elasticsearch process restart, or a Dashboard or Kibana restart.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDomainMaintenanceRequest.Builder} avoiding the
     * need to create one manually via {@link StartDomainMaintenanceRequest#builder()}
     * </p>
     *
     * @param startDomainMaintenanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.StartDomainMaintenanceRequest.Builder} to create a
     *        request. Container for the parameters to the <code>StartDomainMaintenance</code> operation.
     * @return A Java Future containing the result of the StartDomainMaintenance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.StartDomainMaintenance
     */
    default CompletableFuture<StartDomainMaintenanceResponse> startDomainMaintenance(
            Consumer<StartDomainMaintenanceRequest.Builder> startDomainMaintenanceRequest) {
        return startDomainMaintenance(StartDomainMaintenanceRequest.builder().applyMutation(startDomainMaintenanceRequest)
                .build());
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service
     * software updates in Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param startServiceSoftwareUpdateRequest
     *        Container for the request parameters to the <code>StartServiceSoftwareUpdate</code> operation.
     * @return A Java Future containing the result of the StartServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.StartServiceSoftwareUpdate
     */
    default CompletableFuture<StartServiceSoftwareUpdateResponse> startServiceSoftwareUpdate(
            StartServiceSoftwareUpdateRequest startServiceSoftwareUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service
     * software updates in Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartServiceSoftwareUpdateRequest.Builder} avoiding
     * the need to create one manually via {@link StartServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param startServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.StartServiceSoftwareUpdateRequest.Builder} to
     *        create a request. Container for the request parameters to the <code>StartServiceSoftwareUpdate</code>
     *        operation.
     * @return A Java Future containing the result of the StartServiceSoftwareUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.StartServiceSoftwareUpdate
     */
    default CompletableFuture<StartServiceSoftwareUpdateResponse> startServiceSoftwareUpdate(
            Consumer<StartServiceSoftwareUpdateRequest.Builder> startServiceSoftwareUpdateRequest) {
        return startServiceSoftwareUpdate(StartServiceSoftwareUpdateRequest.builder()
                .applyMutation(startServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Updates a direct-query data source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html">Working
     * with Amazon OpenSearch Service data source integrations with Amazon S3</a>.
     * </p>
     *
     * @param updateDataSourceRequest
     *        Container for the parameters to the <code>UpdateDataSource</code> operation.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateDataSource
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a direct-query data source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html">Working
     * with Amazon OpenSearch Service data source integrations with Amazon S3</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.UpdateDataSourceRequest.Builder} to create a
     *        request. Container for the parameters to the <code>UpdateDataSource</code> operation.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>DependencyFailureException An exception for when a failure in one of the dependencies results in the
     *         service being unable to fetch details about the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateDataSource
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.
     * </p>
     *
     * @param updateDomainConfigRequest
     *        Container for the request parameters to the <code>UpdateDomain</code> operation.
     * @return A Java Future containing the result of the UpdateDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateDomainConfig
     */
    default CompletableFuture<UpdateDomainConfigResponse> updateDomainConfig(UpdateDomainConfigRequest updateDomainConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainConfigRequest#builder()}
     * </p>
     *
     * @param updateDomainConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.UpdateDomainConfigRequest.Builder} to create a
     *        request. Container for the request parameters to the <code>UpdateDomain</code> operation.
     * @return A Java Future containing the result of the UpdateDomainConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>InvalidTypeException An exception for trying to create or access a sub-resource that's either invalid
     *         or not supported.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateDomainConfig
     */
    default CompletableFuture<UpdateDomainConfigResponse> updateDomainConfig(
            Consumer<UpdateDomainConfigRequest.Builder> updateDomainConfigRequest) {
        return updateDomainConfig(UpdateDomainConfigRequest.builder().applyMutation(updateDomainConfigRequest).build());
    }

    /**
     * <p>
     * Updates a package for use with Amazon OpenSearch Service domains. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     *
     * @param updatePackageRequest
     *        Container for request parameters to the <code>UpdatePackage</code> operation.
     * @return A Java Future containing the result of the UpdatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdatePackage
     */
    default CompletableFuture<UpdatePackageResponse> updatePackage(UpdatePackageRequest updatePackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a package for use with Amazon OpenSearch Service domains. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages
     * for Amazon OpenSearch Service</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePackageRequest#builder()}
     * </p>
     *
     * @param updatePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.UpdatePackageRequest.Builder} to create a request.
     *        Container for request parameters to the <code>UpdatePackage</code> operation.
     * @return A Java Future containing the result of the UpdatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>AccessDeniedException An error occurred because you don't have permissions to access the resource.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdatePackage
     */
    default CompletableFuture<UpdatePackageResponse> updatePackage(Consumer<UpdatePackageRequest.Builder> updatePackageRequest) {
        return updatePackage(UpdatePackageRequest.builder().applyMutation(updatePackageRequest).build());
    }

    /**
     * <p>
     * Reschedules a planned domain configuration change for a later time. This change can be a scheduled <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service
     * software update</a> or a <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types"
     * >blue/green Auto-Tune enhancement</a>.
     * </p>
     *
     * @param updateScheduledActionRequest
     * @return A Java Future containing the result of the UpdateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SlotNotAvailableException An exception for attempting to schedule a domain action during an
     *         unavailable time slot.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateScheduledAction
     */
    default CompletableFuture<UpdateScheduledActionResponse> updateScheduledAction(
            UpdateScheduledActionRequest updateScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reschedules a planned domain configuration change for a later time. This change can be a scheduled <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service
     * software update</a> or a <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types"
     * >blue/green Auto-Tune enhancement</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateScheduledActionRequest#builder()}
     * </p>
     *
     * @param updateScheduledActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.UpdateScheduledActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SlotNotAvailableException An exception for attempting to schedule a domain action during an
     *         unavailable time slot.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>LimitExceededException An exception for trying to create more than the allowed number of resources or
     *         sub-resources.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateScheduledAction
     */
    default CompletableFuture<UpdateScheduledActionResponse> updateScheduledAction(
            Consumer<UpdateScheduledActionRequest.Builder> updateScheduledActionRequest) {
        return updateScheduledAction(UpdateScheduledActionRequest.builder().applyMutation(updateScheduledActionRequest).build());
    }

    /**
     * <p>
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param updateVpcEndpointRequest
     * @return A Java Future containing the result of the UpdateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateVpcEndpoint
     */
    default CompletableFuture<UpdateVpcEndpointResponse> updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param updateVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.UpdateVpcEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpdateVpcEndpoint
     */
    default CompletableFuture<UpdateVpcEndpointResponse> updateVpcEndpoint(
            Consumer<UpdateVpcEndpointRequest.Builder> updateVpcEndpointRequest) {
        return updateVpcEndpoint(UpdateVpcEndpointRequest.builder().applyMutation(updateVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a
     * compatible version of OpenSearch or Elasticsearch.
     * </p>
     *
     * @param upgradeDomainRequest
     *        Container for the request parameters to the <code>UpgradeDomain</code> operation.
     * @return A Java Future containing the result of the UpgradeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpgradeDomain
     */
    default CompletableFuture<UpgradeDomainResponse> upgradeDomain(UpgradeDomainRequest upgradeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a
     * compatible version of OpenSearch or Elasticsearch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpgradeDomainRequest#builder()}
     * </p>
     *
     * @param upgradeDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearch.model.UpgradeDomainRequest.Builder} to create a request.
     *        Container for the request parameters to the <code>UpgradeDomain</code> operation.
     * @return A Java Future containing the result of the UpgradeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access an unsupported
     *         operation.</li>
     *         <li>ValidationException An exception for accessing or deleting a resource that doesn't exist.</li>
     *         <li>InternalException Request processing failed because of an unknown error, exception, or internal
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OpenSearchAsyncClient.UpgradeDomain
     */
    default CompletableFuture<UpgradeDomainResponse> upgradeDomain(Consumer<UpgradeDomainRequest.Builder> upgradeDomainRequest) {
        return upgradeDomain(UpgradeDomainRequest.builder().applyMutation(upgradeDomainRequest).build());
    }

    @Override
    default OpenSearchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link OpenSearchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OpenSearchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OpenSearchAsyncClient}.
     */
    static OpenSearchAsyncClientBuilder builder() {
        return new DefaultOpenSearchAsyncClientBuilder();
    }
}
