/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for enabling and configuring fine-grained access control. For more information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html">Fine-grained access control in
 * Amazon OpenSearch Service</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedSecurityOptionsInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedSecurityOptionsInput.Builder, AdvancedSecurityOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AdvancedSecurityOptionsInput::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InternalUserDatabaseEnabled")
            .getter(getter(AdvancedSecurityOptionsInput::internalUserDatabaseEnabled))
            .setter(setter(Builder::internalUserDatabaseEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled")
                    .build()).build();

    private static final SdkField<MasterUserOptions> MASTER_USER_OPTIONS_FIELD = SdkField
            .<MasterUserOptions> builder(MarshallingType.SDK_POJO).memberName("MasterUserOptions")
            .getter(getter(AdvancedSecurityOptionsInput::masterUserOptions)).setter(setter(Builder::masterUserOptions))
            .constructor(MasterUserOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserOptions").build()).build();

    private static final SdkField<SAMLOptionsInput> SAML_OPTIONS_FIELD = SdkField
            .<SAMLOptionsInput> builder(MarshallingType.SDK_POJO).memberName("SAMLOptions")
            .getter(getter(AdvancedSecurityOptionsInput::samlOptions)).setter(setter(Builder::samlOptions))
            .constructor(SAMLOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLOptions").build()).build();

    private static final SdkField<JWTOptionsInput> JWT_OPTIONS_FIELD = SdkField
            .<JWTOptionsInput> builder(MarshallingType.SDK_POJO).memberName("JWTOptions")
            .getter(getter(AdvancedSecurityOptionsInput::jwtOptions)).setter(setter(Builder::jwtOptions))
            .constructor(JWTOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JWTOptions").build()).build();

    private static final SdkField<Boolean> ANONYMOUS_AUTH_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AnonymousAuthEnabled").getter(getter(AdvancedSecurityOptionsInput::anonymousAuthEnabled))
            .setter(setter(Builder::anonymousAuthEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousAuthEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            INTERNAL_USER_DATABASE_ENABLED_FIELD, MASTER_USER_OPTIONS_FIELD, SAML_OPTIONS_FIELD, JWT_OPTIONS_FIELD,
            ANONYMOUS_AUTH_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean internalUserDatabaseEnabled;

    private final MasterUserOptions masterUserOptions;

    private final SAMLOptionsInput samlOptions;

    private final JWTOptionsInput jwtOptions;

    private final Boolean anonymousAuthEnabled;

    private AdvancedSecurityOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.masterUserOptions = builder.masterUserOptions;
        this.samlOptions = builder.samlOptions;
        this.jwtOptions = builder.jwtOptions;
        this.anonymousAuthEnabled = builder.anonymousAuthEnabled;
    }

    /**
     * <p>
     * True to enable fine-grained access control.
     * </p>
     * 
     * @return True to enable fine-grained access control.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * True to enable the internal user database.
     * </p>
     * 
     * @return True to enable the internal user database.
     */
    public final Boolean internalUserDatabaseEnabled() {
        return internalUserDatabaseEnabled;
    }

    /**
     * <p>
     * Container for information about the master user.
     * </p>
     * 
     * @return Container for information about the master user.
     */
    public final MasterUserOptions masterUserOptions() {
        return masterUserOptions;
    }

    /**
     * <p>
     * Container for information about the SAML configuration for OpenSearch Dashboards.
     * </p>
     * 
     * @return Container for information about the SAML configuration for OpenSearch Dashboards.
     */
    public final SAMLOptionsInput samlOptions() {
        return samlOptions;
    }

    /**
     * <p>
     * Container for information about the JWT configuration of the Amazon OpenSearch Service.
     * </p>
     * 
     * @return Container for information about the JWT configuration of the Amazon OpenSearch Service.
     */
    public final JWTOptionsInput jwtOptions() {
        return jwtOptions;
    }

    /**
     * <p>
     * True to enable a 30-day migration period during which administrators can create role mappings. Only necessary
     * when <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
     * >enabling fine-grained access control on an existing domain</a>.
     * </p>
     * 
     * @return True to enable a 30-day migration period during which administrators can create role mappings. Only
     *         necessary when <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
     *         >enabling fine-grained access control on an existing domain</a>.
     */
    public final Boolean anonymousAuthEnabled() {
        return anonymousAuthEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserOptions());
        hashCode = 31 * hashCode + Objects.hashCode(samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(jwtOptions());
        hashCode = 31 * hashCode + Objects.hashCode(anonymousAuthEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityOptionsInput)) {
            return false;
        }
        AdvancedSecurityOptionsInput other = (AdvancedSecurityOptionsInput) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled())
                && Objects.equals(masterUserOptions(), other.masterUserOptions())
                && Objects.equals(samlOptions(), other.samlOptions()) && Objects.equals(jwtOptions(), other.jwtOptions())
                && Objects.equals(anonymousAuthEnabled(), other.anonymousAuthEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedSecurityOptionsInput").add("Enabled", enabled())
                .add("InternalUserDatabaseEnabled", internalUserDatabaseEnabled()).add("MasterUserOptions", masterUserOptions())
                .add("SAMLOptions", samlOptions()).add("JWTOptions", jwtOptions())
                .add("AnonymousAuthEnabled", anonymousAuthEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "InternalUserDatabaseEnabled":
            return Optional.ofNullable(clazz.cast(internalUserDatabaseEnabled()));
        case "MasterUserOptions":
            return Optional.ofNullable(clazz.cast(masterUserOptions()));
        case "SAMLOptions":
            return Optional.ofNullable(clazz.cast(samlOptions()));
        case "JWTOptions":
            return Optional.ofNullable(clazz.cast(jwtOptions()));
        case "AnonymousAuthEnabled":
            return Optional.ofNullable(clazz.cast(anonymousAuthEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityOptionsInput, T> g) {
        return obj -> g.apply((AdvancedSecurityOptionsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedSecurityOptionsInput> {
        /**
         * <p>
         * True to enable fine-grained access control.
         * </p>
         * 
         * @param enabled
         *        True to enable fine-grained access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * True to enable the internal user database.
         * </p>
         * 
         * @param internalUserDatabaseEnabled
         *        True to enable the internal user database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled);

        /**
         * <p>
         * Container for information about the master user.
         * </p>
         * 
         * @param masterUserOptions
         *        Container for information about the master user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserOptions(MasterUserOptions masterUserOptions);

        /**
         * <p>
         * Container for information about the master user.
         * </p>
         * This is a convenience method that creates an instance of the {@link MasterUserOptions.Builder} avoiding the
         * need to create one manually via {@link MasterUserOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MasterUserOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #masterUserOptions(MasterUserOptions)}.
         * 
         * @param masterUserOptions
         *        a consumer that will call methods on {@link MasterUserOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #masterUserOptions(MasterUserOptions)
         */
        default Builder masterUserOptions(Consumer<MasterUserOptions.Builder> masterUserOptions) {
            return masterUserOptions(MasterUserOptions.builder().applyMutation(masterUserOptions).build());
        }

        /**
         * <p>
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         * </p>
         * 
         * @param samlOptions
         *        Container for information about the SAML configuration for OpenSearch Dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlOptions(SAMLOptionsInput samlOptions);

        /**
         * <p>
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         * </p>
         * This is a convenience method that creates an instance of the {@link SAMLOptionsInput.Builder} avoiding the
         * need to create one manually via {@link SAMLOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAMLOptionsInput.Builder#build()} is called immediately and its
         * result is passed to {@link #samlOptions(SAMLOptionsInput)}.
         * 
         * @param samlOptions
         *        a consumer that will call methods on {@link SAMLOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlOptions(SAMLOptionsInput)
         */
        default Builder samlOptions(Consumer<SAMLOptionsInput.Builder> samlOptions) {
            return samlOptions(SAMLOptionsInput.builder().applyMutation(samlOptions).build());
        }

        /**
         * <p>
         * Container for information about the JWT configuration of the Amazon OpenSearch Service.
         * </p>
         * 
         * @param jwtOptions
         *        Container for information about the JWT configuration of the Amazon OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtOptions(JWTOptionsInput jwtOptions);

        /**
         * <p>
         * Container for information about the JWT configuration of the Amazon OpenSearch Service.
         * </p>
         * This is a convenience method that creates an instance of the {@link JWTOptionsInput.Builder} avoiding the
         * need to create one manually via {@link JWTOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JWTOptionsInput.Builder#build()} is called immediately and its
         * result is passed to {@link #jwtOptions(JWTOptionsInput)}.
         * 
         * @param jwtOptions
         *        a consumer that will call methods on {@link JWTOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jwtOptions(JWTOptionsInput)
         */
        default Builder jwtOptions(Consumer<JWTOptionsInput.Builder> jwtOptions) {
            return jwtOptions(JWTOptionsInput.builder().applyMutation(jwtOptions).build());
        }

        /**
         * <p>
         * True to enable a 30-day migration period during which administrators can create role mappings. Only necessary
         * when <a href=
         * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
         * >enabling fine-grained access control on an existing domain</a>.
         * </p>
         * 
         * @param anonymousAuthEnabled
         *        True to enable a 30-day migration period during which administrators can create role mappings. Only
         *        necessary when <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing"
         *        >enabling fine-grained access control on an existing domain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousAuthEnabled(Boolean anonymousAuthEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean internalUserDatabaseEnabled;

        private MasterUserOptions masterUserOptions;

        private SAMLOptionsInput samlOptions;

        private JWTOptionsInput jwtOptions;

        private Boolean anonymousAuthEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityOptionsInput model) {
            enabled(model.enabled);
            internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            masterUserOptions(model.masterUserOptions);
            samlOptions(model.samlOptions);
            jwtOptions(model.jwtOptions);
            anonymousAuthEnabled(model.anonymousAuthEnabled);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return internalUserDatabaseEnabled;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final MasterUserOptions.Builder getMasterUserOptions() {
            return masterUserOptions != null ? masterUserOptions.toBuilder() : null;
        }

        public final void setMasterUserOptions(MasterUserOptions.BuilderImpl masterUserOptions) {
            this.masterUserOptions = masterUserOptions != null ? masterUserOptions.build() : null;
        }

        @Override
        public final Builder masterUserOptions(MasterUserOptions masterUserOptions) {
            this.masterUserOptions = masterUserOptions;
            return this;
        }

        public final SAMLOptionsInput.Builder getSamlOptions() {
            return samlOptions != null ? samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SAMLOptionsInput.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SAMLOptionsInput samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final JWTOptionsInput.Builder getJwtOptions() {
            return jwtOptions != null ? jwtOptions.toBuilder() : null;
        }

        public final void setJwtOptions(JWTOptionsInput.BuilderImpl jwtOptions) {
            this.jwtOptions = jwtOptions != null ? jwtOptions.build() : null;
        }

        @Override
        public final Builder jwtOptions(JWTOptionsInput jwtOptions) {
            this.jwtOptions = jwtOptions;
            return this;
        }

        public final Boolean getAnonymousAuthEnabled() {
            return anonymousAuthEnabled;
        }

        public final void setAnonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
        }

        @Override
        public final Builder anonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
            return this;
        }

        @Override
        public AdvancedSecurityOptionsInput build() {
            return new AdvancedSecurityOptionsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
