/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for parameters required to enable all machine learning features.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIMLOptionsInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AIMLOptionsInput.Builder, AIMLOptionsInput> {
    private static final SdkField<NaturalLanguageQueryGenerationOptionsInput> NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD = SdkField
            .<NaturalLanguageQueryGenerationOptionsInput> builder(MarshallingType.SDK_POJO)
            .memberName("NaturalLanguageQueryGenerationOptions")
            .getter(getter(AIMLOptionsInput::naturalLanguageQueryGenerationOptions))
            .setter(setter(Builder::naturalLanguageQueryGenerationOptions))
            .constructor(NaturalLanguageQueryGenerationOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NaturalLanguageQueryGenerationOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NATURAL_LANGUAGE_QUERY_GENERATION_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions;

    private AIMLOptionsInput(BuilderImpl builder) {
        this.naturalLanguageQueryGenerationOptions = builder.naturalLanguageQueryGenerationOptions;
    }

    /**
     * <p>
     * Container for parameters required for natural language query generation on the specified domain.
     * </p>
     * 
     * @return Container for parameters required for natural language query generation on the specified domain.
     */
    public final NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions() {
        return naturalLanguageQueryGenerationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(naturalLanguageQueryGenerationOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIMLOptionsInput)) {
            return false;
        }
        AIMLOptionsInput other = (AIMLOptionsInput) obj;
        return Objects.equals(naturalLanguageQueryGenerationOptions(), other.naturalLanguageQueryGenerationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIMLOptionsInput")
                .add("NaturalLanguageQueryGenerationOptions", naturalLanguageQueryGenerationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NaturalLanguageQueryGenerationOptions":
            return Optional.ofNullable(clazz.cast(naturalLanguageQueryGenerationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AIMLOptionsInput, T> g) {
        return obj -> g.apply((AIMLOptionsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIMLOptionsInput> {
        /**
         * <p>
         * Container for parameters required for natural language query generation on the specified domain.
         * </p>
         * 
         * @param naturalLanguageQueryGenerationOptions
         *        Container for parameters required for natural language query generation on the specified domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder naturalLanguageQueryGenerationOptions(
                NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions);

        /**
         * <p>
         * Container for parameters required for natural language query generation on the specified domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NaturalLanguageQueryGenerationOptionsInput.Builder} avoiding the need to create one manually via
         * {@link NaturalLanguageQueryGenerationOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NaturalLanguageQueryGenerationOptionsInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsInput)}.
         * 
         * @param naturalLanguageQueryGenerationOptions
         *        a consumer that will call methods on {@link NaturalLanguageQueryGenerationOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsInput)
         */
        default Builder naturalLanguageQueryGenerationOptions(
                Consumer<NaturalLanguageQueryGenerationOptionsInput.Builder> naturalLanguageQueryGenerationOptions) {
            return naturalLanguageQueryGenerationOptions(NaturalLanguageQueryGenerationOptionsInput.builder()
                    .applyMutation(naturalLanguageQueryGenerationOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AIMLOptionsInput model) {
            naturalLanguageQueryGenerationOptions(model.naturalLanguageQueryGenerationOptions);
        }

        public final NaturalLanguageQueryGenerationOptionsInput.Builder getNaturalLanguageQueryGenerationOptions() {
            return naturalLanguageQueryGenerationOptions != null ? naturalLanguageQueryGenerationOptions.toBuilder() : null;
        }

        public final void setNaturalLanguageQueryGenerationOptions(
                NaturalLanguageQueryGenerationOptionsInput.BuilderImpl naturalLanguageQueryGenerationOptions) {
            this.naturalLanguageQueryGenerationOptions = naturalLanguageQueryGenerationOptions != null ? naturalLanguageQueryGenerationOptions
                    .build() : null;
        }

        @Override
        public final Builder naturalLanguageQueryGenerationOptions(
                NaturalLanguageQueryGenerationOptionsInput naturalLanguageQueryGenerationOptions) {
            this.naturalLanguageQueryGenerationOptions = naturalLanguageQueryGenerationOptions;
            return this;
        }

        @Override
        public AIMLOptionsInput build() {
            return new AIMLOptionsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
