/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A property change that was cancelled for an Amazon OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelledChangeProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<CancelledChangeProperty.Builder, CancelledChangeProperty> {
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyName").getter(getter(CancelledChangeProperty::propertyName))
            .setter(setter(Builder::propertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyName").build()).build();

    private static final SdkField<String> CANCELLED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CancelledValue").getter(getter(CancelledChangeProperty::cancelledValue))
            .setter(setter(Builder::cancelledValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledValue").build()).build();

    private static final SdkField<String> ACTIVE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveValue").getter(getter(CancelledChangeProperty::activeValue)).setter(setter(Builder::activeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_NAME_FIELD,
            CANCELLED_VALUE_FIELD, ACTIVE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyName;

    private final String cancelledValue;

    private final String activeValue;

    private CancelledChangeProperty(BuilderImpl builder) {
        this.propertyName = builder.propertyName;
        this.cancelledValue = builder.cancelledValue;
        this.activeValue = builder.activeValue;
    }

    /**
     * <p>
     * The name of the property whose change was cancelled.
     * </p>
     * 
     * @return The name of the property whose change was cancelled.
     */
    public final String propertyName() {
        return propertyName;
    }

    /**
     * <p>
     * The pending value of the property that was cancelled. This would have been the eventual value of the property if
     * the chance had not been cancelled.
     * </p>
     * 
     * @return The pending value of the property that was cancelled. This would have been the eventual value of the
     *         property if the chance had not been cancelled.
     */
    public final String cancelledValue() {
        return cancelledValue;
    }

    /**
     * <p>
     * The current value of the property, after the change was cancelled.
     * </p>
     * 
     * @return The current value of the property, after the change was cancelled.
     */
    public final String activeValue() {
        return activeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(cancelledValue());
        hashCode = 31 * hashCode + Objects.hashCode(activeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelledChangeProperty)) {
            return false;
        }
        CancelledChangeProperty other = (CancelledChangeProperty) obj;
        return Objects.equals(propertyName(), other.propertyName()) && Objects.equals(cancelledValue(), other.cancelledValue())
                && Objects.equals(activeValue(), other.activeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelledChangeProperty").add("PropertyName", propertyName())
                .add("CancelledValue", cancelledValue()).add("ActiveValue", activeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyName":
            return Optional.ofNullable(clazz.cast(propertyName()));
        case "CancelledValue":
            return Optional.ofNullable(clazz.cast(cancelledValue()));
        case "ActiveValue":
            return Optional.ofNullable(clazz.cast(activeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelledChangeProperty, T> g) {
        return obj -> g.apply((CancelledChangeProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelledChangeProperty> {
        /**
         * <p>
         * The name of the property whose change was cancelled.
         * </p>
         * 
         * @param propertyName
         *        The name of the property whose change was cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyName(String propertyName);

        /**
         * <p>
         * The pending value of the property that was cancelled. This would have been the eventual value of the property
         * if the chance had not been cancelled.
         * </p>
         * 
         * @param cancelledValue
         *        The pending value of the property that was cancelled. This would have been the eventual value of the
         *        property if the chance had not been cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledValue(String cancelledValue);

        /**
         * <p>
         * The current value of the property, after the change was cancelled.
         * </p>
         * 
         * @param activeValue
         *        The current value of the property, after the change was cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeValue(String activeValue);
    }

    static final class BuilderImpl implements Builder {
        private String propertyName;

        private String cancelledValue;

        private String activeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelledChangeProperty model) {
            propertyName(model.propertyName);
            cancelledValue(model.cancelledValue);
            activeValue(model.activeValue);
        }

        public final String getPropertyName() {
            return propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final String getCancelledValue() {
            return cancelledValue;
        }

        public final void setCancelledValue(String cancelledValue) {
            this.cancelledValue = cancelledValue;
        }

        @Override
        public final Builder cancelledValue(String cancelledValue) {
            this.cancelledValue = cancelledValue;
            return this;
        }

        public final String getActiveValue() {
            return activeValue;
        }

        public final void setActiveValue(String activeValue) {
            this.activeValue = activeValue;
        }

        @Override
        public final Builder activeValue(String activeValue) {
            this.activeValue = activeValue;
            return this;
        }

        @Override
        public CancelledChangeProperty build() {
            return new CancelledChangeProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
