/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a direct-query data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceDetails.Builder, DataSourceDetails> {
    private static final SdkField<DataSourceType> DATA_SOURCE_TYPE_FIELD = SdkField
            .<DataSourceType> builder(MarshallingType.SDK_POJO).memberName("DataSourceType")
            .getter(getter(DataSourceDetails::dataSourceType)).setter(setter(Builder::dataSourceType))
            .constructor(DataSourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataSourceDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataSourceDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DataSourceDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataSourceType dataSourceType;

    private final String name;

    private final String description;

    private final String status;

    private DataSourceDetails(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
    }

    /**
     * <p>
     * The type of data source.
     * </p>
     * 
     * @return The type of data source.
     */
    public final DataSourceType dataSourceType() {
        return dataSourceType;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the data source.
     * </p>
     * 
     * @return A description of the data source.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceDetails)) {
            return false;
        }
        DataSourceDetails other = (DataSourceDetails) obj;
        return Objects.equals(dataSourceType(), other.dataSourceType()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceDetails").add("DataSourceType", dataSourceType()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceType()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceDetails, T> g) {
        return obj -> g.apply((DataSourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceDetails> {
        /**
         * <p>
         * The type of data source.
         * </p>
         * 
         * @param dataSourceType
         *        The type of data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceType(DataSourceType dataSourceType);

        /**
         * <p>
         * The type of data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceType.Builder} avoiding the need
         * to create one manually via {@link DataSourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceType.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSourceType(DataSourceType)}.
         * 
         * @param dataSourceType
         *        a consumer that will call methods on {@link DataSourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceType(DataSourceType)
         */
        default Builder dataSourceType(Consumer<DataSourceType.Builder> dataSourceType) {
            return dataSourceType(DataSourceType.builder().applyMutation(dataSourceType).build());
        }

        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the data source.
         * </p>
         * 
         * @param description
         *        A description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private DataSourceType dataSourceType;

        private String name;

        private String description;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceDetails model) {
            dataSourceType(model.dataSourceType);
            name(model.name);
            description(model.description);
            status(model.status);
        }

        public final DataSourceType.Builder getDataSourceType() {
            return dataSourceType != null ? dataSourceType.toBuilder() : null;
        }

        public final void setDataSourceType(DataSourceType.BuilderImpl dataSourceType) {
            this.dataSourceType = dataSourceType != null ? dataSourceType.build() : null;
        }

        @Override
        public final Builder dataSourceType(DataSourceType dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DataSourceDetails build() {
            return new DataSourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
