/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelDomainConfigChangeResponse extends OpenSearchResponse implements
        ToCopyableBuilder<CancelDomainConfigChangeResponse.Builder, CancelDomainConfigChangeResponse> {
    private static final SdkField<List<String>> CANCELLED_CHANGE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CancelledChangeIds")
            .getter(getter(CancelDomainConfigChangeResponse::cancelledChangeIds))
            .setter(setter(Builder::cancelledChangeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledChangeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CancelledChangeProperty>> CANCELLED_CHANGE_PROPERTIES_FIELD = SdkField
            .<List<CancelledChangeProperty>> builder(MarshallingType.LIST)
            .memberName("CancelledChangeProperties")
            .getter(getter(CancelDomainConfigChangeResponse::cancelledChangeProperties))
            .setter(setter(Builder::cancelledChangeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledChangeProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CancelledChangeProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(CancelledChangeProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(CancelDomainConfigChangeResponse::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLED_CHANGE_IDS_FIELD,
            CANCELLED_CHANGE_PROPERTIES_FIELD, DRY_RUN_FIELD));

    private final List<String> cancelledChangeIds;

    private final List<CancelledChangeProperty> cancelledChangeProperties;

    private final Boolean dryRun;

    private CancelDomainConfigChangeResponse(BuilderImpl builder) {
        super(builder);
        this.cancelledChangeIds = builder.cancelledChangeIds;
        this.cancelledChangeProperties = builder.cancelledChangeProperties;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the CancelledChangeIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCancelledChangeIds() {
        return cancelledChangeIds != null && !(cancelledChangeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the changes that were cancelled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCancelledChangeIds} method.
     * </p>
     * 
     * @return The unique identifiers of the changes that were cancelled.
     */
    public final List<String> cancelledChangeIds() {
        return cancelledChangeIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the CancelledChangeProperties property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCancelledChangeProperties() {
        return cancelledChangeProperties != null && !(cancelledChangeProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domain change properties that were cancelled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCancelledChangeProperties} method.
     * </p>
     * 
     * @return The domain change properties that were cancelled.
     */
    public final List<CancelledChangeProperty> cancelledChangeProperties() {
        return cancelledChangeProperties;
    }

    /**
     * <p>
     * Whether or not the request was a dry run. If <code>True</code>, the changes were not actually cancelled.
     * </p>
     * 
     * @return Whether or not the request was a dry run. If <code>True</code>, the changes were not actually cancelled.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCancelledChangeIds() ? cancelledChangeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCancelledChangeProperties() ? cancelledChangeProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelDomainConfigChangeResponse)) {
            return false;
        }
        CancelDomainConfigChangeResponse other = (CancelDomainConfigChangeResponse) obj;
        return hasCancelledChangeIds() == other.hasCancelledChangeIds()
                && Objects.equals(cancelledChangeIds(), other.cancelledChangeIds())
                && hasCancelledChangeProperties() == other.hasCancelledChangeProperties()
                && Objects.equals(cancelledChangeProperties(), other.cancelledChangeProperties())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelDomainConfigChangeResponse")
                .add("CancelledChangeIds", hasCancelledChangeIds() ? cancelledChangeIds() : null)
                .add("CancelledChangeProperties", hasCancelledChangeProperties() ? cancelledChangeProperties() : null)
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancelledChangeIds":
            return Optional.ofNullable(clazz.cast(cancelledChangeIds()));
        case "CancelledChangeProperties":
            return Optional.ofNullable(clazz.cast(cancelledChangeProperties()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelDomainConfigChangeResponse, T> g) {
        return obj -> g.apply((CancelDomainConfigChangeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelDomainConfigChangeResponse> {
        /**
         * <p>
         * The unique identifiers of the changes that were cancelled.
         * </p>
         * 
         * @param cancelledChangeIds
         *        The unique identifiers of the changes that were cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledChangeIds(Collection<String> cancelledChangeIds);

        /**
         * <p>
         * The unique identifiers of the changes that were cancelled.
         * </p>
         * 
         * @param cancelledChangeIds
         *        The unique identifiers of the changes that were cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledChangeIds(String... cancelledChangeIds);

        /**
         * <p>
         * The domain change properties that were cancelled.
         * </p>
         * 
         * @param cancelledChangeProperties
         *        The domain change properties that were cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledChangeProperties(Collection<CancelledChangeProperty> cancelledChangeProperties);

        /**
         * <p>
         * The domain change properties that were cancelled.
         * </p>
         * 
         * @param cancelledChangeProperties
         *        The domain change properties that were cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledChangeProperties(CancelledChangeProperty... cancelledChangeProperties);

        /**
         * <p>
         * The domain change properties that were cancelled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.CancelledChangeProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.CancelledChangeProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.CancelledChangeProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #cancelledChangeProperties(List<CancelledChangeProperty>)}.
         * 
         * @param cancelledChangeProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.CancelledChangeProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancelledChangeProperties(java.util.Collection<CancelledChangeProperty>)
         */
        Builder cancelledChangeProperties(Consumer<CancelledChangeProperty.Builder>... cancelledChangeProperties);

        /**
         * <p>
         * Whether or not the request was a dry run. If <code>True</code>, the changes were not actually cancelled.
         * </p>
         * 
         * @param dryRun
         *        Whether or not the request was a dry run. If <code>True</code>, the changes were not actually
         *        cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<String> cancelledChangeIds = DefaultSdkAutoConstructList.getInstance();

        private List<CancelledChangeProperty> cancelledChangeProperties = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelDomainConfigChangeResponse model) {
            super(model);
            cancelledChangeIds(model.cancelledChangeIds);
            cancelledChangeProperties(model.cancelledChangeProperties);
            dryRun(model.dryRun);
        }

        public final Collection<String> getCancelledChangeIds() {
            if (cancelledChangeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return cancelledChangeIds;
        }

        public final void setCancelledChangeIds(Collection<String> cancelledChangeIds) {
            this.cancelledChangeIds = GUIDListCopier.copy(cancelledChangeIds);
        }

        @Override
        public final Builder cancelledChangeIds(Collection<String> cancelledChangeIds) {
            this.cancelledChangeIds = GUIDListCopier.copy(cancelledChangeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledChangeIds(String... cancelledChangeIds) {
            cancelledChangeIds(Arrays.asList(cancelledChangeIds));
            return this;
        }

        public final List<CancelledChangeProperty.Builder> getCancelledChangeProperties() {
            List<CancelledChangeProperty.Builder> result = CancelledChangePropertyListCopier
                    .copyToBuilder(this.cancelledChangeProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCancelledChangeProperties(Collection<CancelledChangeProperty.BuilderImpl> cancelledChangeProperties) {
            this.cancelledChangeProperties = CancelledChangePropertyListCopier.copyFromBuilder(cancelledChangeProperties);
        }

        @Override
        public final Builder cancelledChangeProperties(Collection<CancelledChangeProperty> cancelledChangeProperties) {
            this.cancelledChangeProperties = CancelledChangePropertyListCopier.copy(cancelledChangeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledChangeProperties(CancelledChangeProperty... cancelledChangeProperties) {
            cancelledChangeProperties(Arrays.asList(cancelledChangeProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledChangeProperties(Consumer<CancelledChangeProperty.Builder>... cancelledChangeProperties) {
            cancelledChangeProperties(Stream.of(cancelledChangeProperties)
                    .map(c -> CancelledChangeProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public CancelDomainConfigChangeResponse build() {
            return new CancelDomainConfigChangeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
