/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection properties of an outbound connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionProperties.Builder, ConnectionProperties> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(ConnectionProperties::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<CrossClusterSearchConnectionProperties> CROSS_CLUSTER_SEARCH_FIELD = SdkField
            .<CrossClusterSearchConnectionProperties> builder(MarshallingType.SDK_POJO).memberName("CrossClusterSearch")
            .getter(getter(ConnectionProperties::crossClusterSearch)).setter(setter(Builder::crossClusterSearch))
            .constructor(CrossClusterSearchConnectionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearch").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            CROSS_CLUSTER_SEARCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final CrossClusterSearchConnectionProperties crossClusterSearch;

    private ConnectionProperties(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.crossClusterSearch = builder.crossClusterSearch;
    }

    /**
     * <important>
     * <p>
     * The Endpoint attribute cannot be modified.
     * </p>
     * </important>
     * <p>
     * The endpoint of the remote domain. Applicable for VPC_ENDPOINT connection mode.
     * </p>
     * 
     * @return <p>
     *         The Endpoint attribute cannot be modified.
     *         </p>
     *         </important>
     *         <p>
     *         The endpoint of the remote domain. Applicable for VPC_ENDPOINT connection mode.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The connection properties for cross cluster search.
     * </p>
     * 
     * @return The connection properties for cross cluster search.
     */
    public final CrossClusterSearchConnectionProperties crossClusterSearch() {
        return crossClusterSearch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(crossClusterSearch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionProperties)) {
            return false;
        }
        ConnectionProperties other = (ConnectionProperties) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(crossClusterSearch(), other.crossClusterSearch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionProperties").add("Endpoint", endpoint())
                .add("CrossClusterSearch", crossClusterSearch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "CrossClusterSearch":
            return Optional.ofNullable(clazz.cast(crossClusterSearch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionProperties, T> g) {
        return obj -> g.apply((ConnectionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionProperties> {
        /**
         * <important>
         * <p>
         * The Endpoint attribute cannot be modified.
         * </p>
         * </important>
         * <p>
         * The endpoint of the remote domain. Applicable for VPC_ENDPOINT connection mode.
         * </p>
         * 
         * @param endpoint
         *        <p>
         *        The Endpoint attribute cannot be modified.
         *        </p>
         *        </important>
         *        <p>
         *        The endpoint of the remote domain. Applicable for VPC_ENDPOINT connection mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The connection properties for cross cluster search.
         * </p>
         * 
         * @param crossClusterSearch
         *        The connection properties for cross cluster search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearch(CrossClusterSearchConnectionProperties crossClusterSearch);

        /**
         * <p>
         * The connection properties for cross cluster search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CrossClusterSearchConnectionProperties.Builder} avoiding the need to create one manually via
         * {@link CrossClusterSearchConnectionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrossClusterSearchConnectionProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #crossClusterSearch(CrossClusterSearchConnectionProperties)}.
         * 
         * @param crossClusterSearch
         *        a consumer that will call methods on {@link CrossClusterSearchConnectionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossClusterSearch(CrossClusterSearchConnectionProperties)
         */
        default Builder crossClusterSearch(Consumer<CrossClusterSearchConnectionProperties.Builder> crossClusterSearch) {
            return crossClusterSearch(CrossClusterSearchConnectionProperties.builder().applyMutation(crossClusterSearch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private CrossClusterSearchConnectionProperties crossClusterSearch;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionProperties model) {
            endpoint(model.endpoint);
            crossClusterSearch(model.crossClusterSearch);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final CrossClusterSearchConnectionProperties.Builder getCrossClusterSearch() {
            return crossClusterSearch != null ? crossClusterSearch.toBuilder() : null;
        }

        public final void setCrossClusterSearch(CrossClusterSearchConnectionProperties.BuilderImpl crossClusterSearch) {
            this.crossClusterSearch = crossClusterSearch != null ? crossClusterSearch.build() : null;
        }

        @Override
        public final Builder crossClusterSearch(CrossClusterSearchConnectionProperties crossClusterSearch) {
            this.crossClusterSearch = crossClusterSearch;
            return this;
        }

        @Override
        public ConnectionProperties build() {
            return new ConnectionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
