/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDryRunProgressResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeDryRunProgressResponse.Builder, DescribeDryRunProgressResponse> {
    private static final SdkField<DryRunProgressStatus> DRY_RUN_PROGRESS_STATUS_FIELD = SdkField
            .<DryRunProgressStatus> builder(MarshallingType.SDK_POJO).memberName("DryRunProgressStatus")
            .getter(getter(DescribeDryRunProgressResponse::dryRunProgressStatus)).setter(setter(Builder::dryRunProgressStatus))
            .constructor(DryRunProgressStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunProgressStatus").build())
            .build();

    private static final SdkField<DomainStatus> DRY_RUN_CONFIG_FIELD = SdkField.<DomainStatus> builder(MarshallingType.SDK_POJO)
            .memberName("DryRunConfig").getter(getter(DescribeDryRunProgressResponse::dryRunConfig))
            .setter(setter(Builder::dryRunConfig)).constructor(DomainStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunConfig").build()).build();

    private static final SdkField<DryRunResults> DRY_RUN_RESULTS_FIELD = SdkField
            .<DryRunResults> builder(MarshallingType.SDK_POJO).memberName("DryRunResults")
            .getter(getter(DescribeDryRunProgressResponse::dryRunResults)).setter(setter(Builder::dryRunResults))
            .constructor(DryRunResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_PROGRESS_STATUS_FIELD,
            DRY_RUN_CONFIG_FIELD, DRY_RUN_RESULTS_FIELD));

    private final DryRunProgressStatus dryRunProgressStatus;

    private final DomainStatus dryRunConfig;

    private final DryRunResults dryRunResults;

    private DescribeDryRunProgressResponse(BuilderImpl builder) {
        super(builder);
        this.dryRunProgressStatus = builder.dryRunProgressStatus;
        this.dryRunConfig = builder.dryRunConfig;
        this.dryRunResults = builder.dryRunResults;
    }

    /**
     * <p>
     * The current status of the dry run, including any validation errors.
     * </p>
     * 
     * @return The current status of the dry run, including any validation errors.
     */
    public final DryRunProgressStatus dryRunProgressStatus() {
        return dryRunProgressStatus;
    }

    /**
     * <p>
     * Details about the changes you're planning to make on the domain.
     * </p>
     * 
     * @return Details about the changes you're planning to make on the domain.
     */
    public final DomainStatus dryRunConfig() {
        return dryRunConfig;
    }

    /**
     * <p>
     * The results of the dry run.
     * </p>
     * 
     * @return The results of the dry run.
     */
    public final DryRunResults dryRunResults() {
        return dryRunResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRunProgressStatus());
        hashCode = 31 * hashCode + Objects.hashCode(dryRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dryRunResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDryRunProgressResponse)) {
            return false;
        }
        DescribeDryRunProgressResponse other = (DescribeDryRunProgressResponse) obj;
        return Objects.equals(dryRunProgressStatus(), other.dryRunProgressStatus())
                && Objects.equals(dryRunConfig(), other.dryRunConfig()) && Objects.equals(dryRunResults(), other.dryRunResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDryRunProgressResponse").add("DryRunProgressStatus", dryRunProgressStatus())
                .add("DryRunConfig", dryRunConfig()).add("DryRunResults", dryRunResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRunProgressStatus":
            return Optional.ofNullable(clazz.cast(dryRunProgressStatus()));
        case "DryRunConfig":
            return Optional.ofNullable(clazz.cast(dryRunConfig()));
        case "DryRunResults":
            return Optional.ofNullable(clazz.cast(dryRunResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDryRunProgressResponse, T> g) {
        return obj -> g.apply((DescribeDryRunProgressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDryRunProgressResponse> {
        /**
         * <p>
         * The current status of the dry run, including any validation errors.
         * </p>
         * 
         * @param dryRunProgressStatus
         *        The current status of the dry run, including any validation errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunProgressStatus(DryRunProgressStatus dryRunProgressStatus);

        /**
         * <p>
         * The current status of the dry run, including any validation errors.
         * </p>
         * This is a convenience method that creates an instance of the {@link DryRunProgressStatus.Builder} avoiding
         * the need to create one manually via {@link DryRunProgressStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DryRunProgressStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #dryRunProgressStatus(DryRunProgressStatus)}.
         * 
         * @param dryRunProgressStatus
         *        a consumer that will call methods on {@link DryRunProgressStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dryRunProgressStatus(DryRunProgressStatus)
         */
        default Builder dryRunProgressStatus(Consumer<DryRunProgressStatus.Builder> dryRunProgressStatus) {
            return dryRunProgressStatus(DryRunProgressStatus.builder().applyMutation(dryRunProgressStatus).build());
        }

        /**
         * <p>
         * Details about the changes you're planning to make on the domain.
         * </p>
         * 
         * @param dryRunConfig
         *        Details about the changes you're planning to make on the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunConfig(DomainStatus dryRunConfig);

        /**
         * <p>
         * Details about the changes you're planning to make on the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainStatus.Builder} avoiding the need
         * to create one manually via {@link DomainStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #dryRunConfig(DomainStatus)}.
         * 
         * @param dryRunConfig
         *        a consumer that will call methods on {@link DomainStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dryRunConfig(DomainStatus)
         */
        default Builder dryRunConfig(Consumer<DomainStatus.Builder> dryRunConfig) {
            return dryRunConfig(DomainStatus.builder().applyMutation(dryRunConfig).build());
        }

        /**
         * <p>
         * The results of the dry run.
         * </p>
         * 
         * @param dryRunResults
         *        The results of the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunResults(DryRunResults dryRunResults);

        /**
         * <p>
         * The results of the dry run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DryRunResults.Builder} avoiding the need
         * to create one manually via {@link DryRunResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DryRunResults.Builder#build()} is called immediately and its
         * result is passed to {@link #dryRunResults(DryRunResults)}.
         * 
         * @param dryRunResults
         *        a consumer that will call methods on {@link DryRunResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dryRunResults(DryRunResults)
         */
        default Builder dryRunResults(Consumer<DryRunResults.Builder> dryRunResults) {
            return dryRunResults(DryRunResults.builder().applyMutation(dryRunResults).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private DryRunProgressStatus dryRunProgressStatus;

        private DomainStatus dryRunConfig;

        private DryRunResults dryRunResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDryRunProgressResponse model) {
            super(model);
            dryRunProgressStatus(model.dryRunProgressStatus);
            dryRunConfig(model.dryRunConfig);
            dryRunResults(model.dryRunResults);
        }

        public final DryRunProgressStatus.Builder getDryRunProgressStatus() {
            return dryRunProgressStatus != null ? dryRunProgressStatus.toBuilder() : null;
        }

        public final void setDryRunProgressStatus(DryRunProgressStatus.BuilderImpl dryRunProgressStatus) {
            this.dryRunProgressStatus = dryRunProgressStatus != null ? dryRunProgressStatus.build() : null;
        }

        @Override
        public final Builder dryRunProgressStatus(DryRunProgressStatus dryRunProgressStatus) {
            this.dryRunProgressStatus = dryRunProgressStatus;
            return this;
        }

        public final DomainStatus.Builder getDryRunConfig() {
            return dryRunConfig != null ? dryRunConfig.toBuilder() : null;
        }

        public final void setDryRunConfig(DomainStatus.BuilderImpl dryRunConfig) {
            this.dryRunConfig = dryRunConfig != null ? dryRunConfig.build() : null;
        }

        @Override
        public final Builder dryRunConfig(DomainStatus dryRunConfig) {
            this.dryRunConfig = dryRunConfig;
            return this;
        }

        public final DryRunResults.Builder getDryRunResults() {
            return dryRunResults != null ? dryRunResults.toBuilder() : null;
        }

        public final void setDryRunResults(DryRunResults.BuilderImpl dryRunResults) {
            this.dryRunResults = dryRunResults != null ? dryRunResults.build() : null;
        }

        @Override
        public final Builder dryRunResults(DryRunResults dryRunResults) {
            this.dryRunResults = dryRunResults;
            return this;
        }

        @Override
        public DescribeDryRunProgressResponse build() {
            return new DescribeDryRunProgressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
