/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceTypeDetailsRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, ListInstanceTypeDetailsRequest> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ListInstanceTypeDetailsRequest.getter(ListInstanceTypeDetailsRequest::engineVersion)).setter(ListInstanceTypeDetailsRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ListInstanceTypeDetailsRequest.getter(ListInstanceTypeDetailsRequest::domainName)).setter(ListInstanceTypeDetailsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInstanceTypeDetailsRequest.getter(ListInstanceTypeDetailsRequest::maxResults)).setter(ListInstanceTypeDetailsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInstanceTypeDetailsRequest.getter(ListInstanceTypeDetailsRequest::nextToken)).setter(ListInstanceTypeDetailsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> RETRIEVE_A_ZS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RetrieveAZs").getter(ListInstanceTypeDetailsRequest.getter(ListInstanceTypeDetailsRequest::retrieveAZs)).setter(ListInstanceTypeDetailsRequest.setter(Builder::retrieveAZs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("retrieveAZs").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ListInstanceTypeDetailsRequest.getter(ListInstanceTypeDetailsRequest::instanceType)).setter(ListInstanceTypeDetailsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("instanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD, DOMAIN_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RETRIEVE_A_ZS_FIELD, INSTANCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("domainName", DOMAIN_NAME_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("retrieveAZs", RETRIEVE_A_ZS_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
        }
    });
    private final String engineVersion;
    private final String domainName;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean retrieveAZs;
    private final String instanceType;

    private ListInstanceTypeDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.engineVersion = builder.engineVersion;
        this.domainName = builder.domainName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.retrieveAZs = builder.retrieveAZs;
        this.instanceType = builder.instanceType;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean retrieveAZs() {
        return this.retrieveAZs;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveAZs());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceTypeDetailsRequest)) {
            return false;
        }
        ListInstanceTypeDetailsRequest other = (ListInstanceTypeDetailsRequest)((Object)obj);
        return Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.retrieveAZs(), other.retrieveAZs()) && Objects.equals(this.instanceType(), other.instanceType());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstanceTypeDetailsRequest").add("EngineVersion", (Object)this.engineVersion()).add("DomainName", (Object)this.domainName()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("RetrieveAZs", (Object)this.retrieveAZs()).add("InstanceType", (Object)this.instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RetrieveAZs": {
                return Optional.ofNullable(clazz.cast(this.retrieveAZs()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceTypeDetailsRequest, T> g) {
        return obj -> g.apply((ListInstanceTypeDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String engineVersion;
        private String domainName;
        private Integer maxResults;
        private String nextToken;
        private Boolean retrieveAZs;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceTypeDetailsRequest model) {
            super(model);
            this.engineVersion(model.engineVersion);
            this.domainName(model.domainName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.retrieveAZs(model.retrieveAZs);
            this.instanceType(model.instanceType);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getRetrieveAZs() {
            return this.retrieveAZs;
        }

        public final void setRetrieveAZs(Boolean retrieveAZs) {
            this.retrieveAZs = retrieveAZs;
        }

        @Override
        public final Builder retrieveAZs(Boolean retrieveAZs) {
            this.retrieveAZs = retrieveAZs;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstanceTypeDetailsRequest build() {
            return new ListInstanceTypeDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstanceTypeDetailsRequest> {
        public Builder engineVersion(String var1);

        public Builder domainName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder retrieveAZs(Boolean var1);

        public Builder instanceType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

