/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.services.opensearch.model.ScheduledAction;
import software.amazon.awssdk.services.opensearch.model.ScheduledActionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScheduledActionsResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, ListScheduledActionsResponse> {
    private static final SdkField<List<ScheduledAction>> SCHEDULED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledActions").getter(ListScheduledActionsResponse.getter(ListScheduledActionsResponse::scheduledActions)).setter(ListScheduledActionsResponse.setter(Builder::scheduledActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScheduledActionsResponse.getter(ListScheduledActionsResponse::nextToken)).setter(ListScheduledActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ScheduledActions", SCHEDULED_ACTIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ScheduledAction> scheduledActions;
    private final String nextToken;

    private ListScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledActions = builder.scheduledActions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScheduledActions() {
        return this.scheduledActions != null && !(this.scheduledActions instanceof SdkAutoConstructList);
    }

    public final List<ScheduledAction> scheduledActions() {
        return this.scheduledActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledActions() ? this.scheduledActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledActionsResponse)) {
            return false;
        }
        ListScheduledActionsResponse other = (ListScheduledActionsResponse)((Object)obj);
        return this.hasScheduledActions() == other.hasScheduledActions() && Objects.equals(this.scheduledActions(), other.scheduledActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScheduledActionsResponse").add("ScheduledActions", this.hasScheduledActions() ? this.scheduledActions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledActions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledActionsResponse, T> g) {
        return obj -> g.apply((ListScheduledActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private List<ScheduledAction> scheduledActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledActionsResponse model) {
            super(model);
            this.scheduledActions(model.scheduledActions);
            this.nextToken(model.nextToken);
        }

        public final List<ScheduledAction.Builder> getScheduledActions() {
            List<ScheduledAction.Builder> result = ScheduledActionsListCopier.copyToBuilder(this.scheduledActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledActions(Collection<ScheduledAction.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionsListCopier.copyFromBuilder(scheduledActions);
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledAction> scheduledActions) {
            this.scheduledActions = ScheduledActionsListCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledAction ... scheduledActions) {
            this.scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledAction.Builder> ... scheduledActions) {
            this.scheduledActions(Stream.of(scheduledActions).map(c -> (ScheduledAction)((ScheduledAction.Builder)ScheduledAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScheduledActionsResponse build() {
            return new ListScheduledActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScheduledActionsResponse> {
        public Builder scheduledActions(Collection<ScheduledAction> var1);

        public Builder scheduledActions(ScheduledAction ... var1);

        public Builder scheduledActions(Consumer<ScheduledAction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

