/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedInstanceOfferingResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, PurchaseReservedInstanceOfferingResponse> {
    private static final SdkField<String> RESERVED_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstanceId").getter(PurchaseReservedInstanceOfferingResponse.getter(PurchaseReservedInstanceOfferingResponse::reservedInstanceId)).setter(PurchaseReservedInstanceOfferingResponse.setter(Builder::reservedInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId").build()}).build();
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(PurchaseReservedInstanceOfferingResponse.getter(PurchaseReservedInstanceOfferingResponse::reservationName)).setter(PurchaseReservedInstanceOfferingResponse.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCE_ID_FIELD, RESERVATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReservedInstanceId", RESERVED_INSTANCE_ID_FIELD);
            this.put("ReservationName", RESERVATION_NAME_FIELD);
        }
    });
    private final String reservedInstanceId;
    private final String reservationName;

    private PurchaseReservedInstanceOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceId = builder.reservedInstanceId;
        this.reservationName = builder.reservationName;
    }

    public final String reservedInstanceId() {
        return this.reservedInstanceId;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstanceOfferingResponse)) {
            return false;
        }
        PurchaseReservedInstanceOfferingResponse other = (PurchaseReservedInstanceOfferingResponse)((Object)obj);
        return Objects.equals(this.reservedInstanceId(), other.reservedInstanceId()) && Objects.equals(this.reservationName(), other.reservationName());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedInstanceOfferingResponse").add("ReservedInstanceId", (Object)this.reservedInstanceId()).add("ReservationName", (Object)this.reservationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstanceId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceId()));
            }
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedInstanceOfferingResponse, T> g) {
        return obj -> g.apply((PurchaseReservedInstanceOfferingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String reservedInstanceId;
        private String reservationName;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstanceOfferingResponse model) {
            super(model);
            this.reservedInstanceId(model.reservedInstanceId);
            this.reservationName(model.reservationName);
        }

        public final String getReservedInstanceId() {
            return this.reservedInstanceId;
        }

        public final void setReservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
        }

        @Override
        public final Builder reservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        @Override
        public PurchaseReservedInstanceOfferingResponse build() {
            return new PurchaseReservedInstanceOfferingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedInstanceOfferingResponse> {
        public Builder reservedInstanceId(String var1);

        public Builder reservationName(String var1);
    }
}

