/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.DomainPackageDetails;
import software.amazon.awssdk.services.opensearch.model.DomainPackageDetailsListCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatePackagesResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, AssociatePackagesResponse> {
    private static final SdkField<List<DomainPackageDetails>> DOMAIN_PACKAGE_DETAILS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainPackageDetailsList").getter(AssociatePackagesResponse.getter(AssociatePackagesResponse::domainPackageDetailsList)).setter(AssociatePackagesResponse.setter(Builder::domainPackageDetailsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageDetailsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainPackageDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_PACKAGE_DETAILS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainPackageDetailsList", DOMAIN_PACKAGE_DETAILS_LIST_FIELD);
        }
    });
    private final List<DomainPackageDetails> domainPackageDetailsList;

    private AssociatePackagesResponse(BuilderImpl builder) {
        super(builder);
        this.domainPackageDetailsList = builder.domainPackageDetailsList;
    }

    public final boolean hasDomainPackageDetailsList() {
        return this.domainPackageDetailsList != null && !(this.domainPackageDetailsList instanceof SdkAutoConstructList);
    }

    public final List<DomainPackageDetails> domainPackageDetailsList() {
        return this.domainPackageDetailsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainPackageDetailsList() ? this.domainPackageDetailsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePackagesResponse)) {
            return false;
        }
        AssociatePackagesResponse other = (AssociatePackagesResponse)((Object)obj);
        return this.hasDomainPackageDetailsList() == other.hasDomainPackageDetailsList() && Objects.equals(this.domainPackageDetailsList(), other.domainPackageDetailsList());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatePackagesResponse").add("DomainPackageDetailsList", this.hasDomainPackageDetailsList() ? this.domainPackageDetailsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainPackageDetailsList": {
                return Optional.ofNullable(clazz.cast(this.domainPackageDetailsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePackagesResponse, T> g) {
        return obj -> g.apply((AssociatePackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private List<DomainPackageDetails> domainPackageDetailsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePackagesResponse model) {
            super(model);
            this.domainPackageDetailsList(model.domainPackageDetailsList);
        }

        public final List<DomainPackageDetails.Builder> getDomainPackageDetailsList() {
            List<DomainPackageDetails.Builder> result = DomainPackageDetailsListCopier.copyToBuilder(this.domainPackageDetailsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainPackageDetailsList(Collection<DomainPackageDetails.BuilderImpl> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copyFromBuilder(domainPackageDetailsList);
        }

        @Override
        public final Builder domainPackageDetailsList(Collection<DomainPackageDetails> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copy(domainPackageDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(DomainPackageDetails ... domainPackageDetailsList) {
            this.domainPackageDetailsList(Arrays.asList(domainPackageDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder> ... domainPackageDetailsList) {
            this.domainPackageDetailsList(Stream.of(domainPackageDetailsList).map(c -> (DomainPackageDetails)((DomainPackageDetails.Builder)DomainPackageDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssociatePackagesResponse build() {
            return new AssociatePackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociatePackagesResponse> {
        public Builder domainPackageDetailsList(Collection<DomainPackageDetails> var1);

        public Builder domainPackageDetailsList(DomainPackageDetails ... var1);

        public Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder> ... var1);
    }
}

