/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.opensearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeDomainRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, UpgradeDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpgradeDomainRequest.getter(UpgradeDomainRequest::domainName)).setter(UpgradeDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVersion").getter(UpgradeDomainRequest.getter(UpgradeDomainRequest::targetVersion)).setter(UpgradeDomainRequest.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformCheckOnly").getter(UpgradeDomainRequest.getter(UpgradeDomainRequest::performCheckOnly)).setter(UpgradeDomainRequest.setter(Builder::performCheckOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdvancedOptions").getter(UpgradeDomainRequest.getter(UpgradeDomainRequest::advancedOptions)).setter(UpgradeDomainRequest.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD, ADVANCED_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("TargetVersion", TARGET_VERSION_FIELD);
            this.put("PerformCheckOnly", PERFORM_CHECK_ONLY_FIELD);
            this.put("AdvancedOptions", ADVANCED_OPTIONS_FIELD);
        }
    });
    private final String domainName;
    private final String targetVersion;
    private final Boolean performCheckOnly;
    private final Map<String, String> advancedOptions;

    private UpgradeDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
        this.advancedOptions = builder.advancedOptions;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final Boolean performCheckOnly() {
        return this.performCheckOnly;
    }

    public final boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.performCheckOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedOptions() ? this.advancedOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeDomainRequest)) {
            return false;
        }
        UpgradeDomainRequest other = (UpgradeDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.performCheckOnly(), other.performCheckOnly()) && this.hasAdvancedOptions() == other.hasAdvancedOptions() && Objects.equals(this.advancedOptions(), other.advancedOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeDomainRequest").add("DomainName", (Object)this.domainName()).add("TargetVersion", (Object)this.targetVersion()).add("PerformCheckOnly", (Object)this.performCheckOnly()).add("AdvancedOptions", this.hasAdvancedOptions() ? this.advancedOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "PerformCheckOnly": {
                return Optional.ofNullable(clazz.cast(this.performCheckOnly()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeDomainRequest, T> g) {
        return obj -> g.apply((UpgradeDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String targetVersion;
        private Boolean performCheckOnly;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.targetVersion(model.targetVersion);
            this.performCheckOnly(model.performCheckOnly);
            this.advancedOptions(model.advancedOptions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Boolean getPerformCheckOnly() {
            return this.performCheckOnly;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (this.advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradeDomainRequest build() {
            return new UpgradeDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeDomainRequest> {
        public Builder domainName(String var1);

        public Builder targetVersion(String var1);

        public Builder performCheckOnly(Boolean var1);

        public Builder advancedOptions(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

