/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.DirectQueryDataSourceType;
import software.amazon.awssdk.services.opensearch.model.DirectQueryOpenSearchARNListCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDirectQueryDataSourceRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, UpdateDirectQueryDataSourceRequest> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceName").getter(UpdateDirectQueryDataSourceRequest.getter(UpdateDirectQueryDataSourceRequest::dataSourceName)).setter(UpdateDirectQueryDataSourceRequest.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSourceName").build()}).build();
    private static final SdkField<DirectQueryDataSourceType> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceType").getter(UpdateDirectQueryDataSourceRequest.getter(UpdateDirectQueryDataSourceRequest::dataSourceType)).setter(UpdateDirectQueryDataSourceRequest.setter(Builder::dataSourceType)).constructor(DirectQueryDataSourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateDirectQueryDataSourceRequest.getter(UpdateDirectQueryDataSourceRequest::description)).setter(UpdateDirectQueryDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> OPEN_SEARCH_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpenSearchArns").getter(UpdateDirectQueryDataSourceRequest.getter(UpdateDirectQueryDataSourceRequest::openSearchArns)).setter(UpdateDirectQueryDataSourceRequest.setter(Builder::openSearchArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenSearchArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD, DATA_SOURCE_TYPE_FIELD, DESCRIPTION_FIELD, OPEN_SEARCH_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSourceName", DATA_SOURCE_NAME_FIELD);
            this.put("DataSourceType", DATA_SOURCE_TYPE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("OpenSearchArns", OPEN_SEARCH_ARNS_FIELD);
        }
    });
    private final String dataSourceName;
    private final DirectQueryDataSourceType dataSourceType;
    private final String description;
    private final List<String> openSearchArns;

    private UpdateDirectQueryDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceName = builder.dataSourceName;
        this.dataSourceType = builder.dataSourceType;
        this.description = builder.description;
        this.openSearchArns = builder.openSearchArns;
    }

    public final String dataSourceName() {
        return this.dataSourceName;
    }

    public final DirectQueryDataSourceType dataSourceType() {
        return this.dataSourceType;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasOpenSearchArns() {
        return this.openSearchArns != null && !(this.openSearchArns instanceof SdkAutoConstructList);
    }

    public final List<String> openSearchArns() {
        return this.openSearchArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpenSearchArns() ? this.openSearchArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectQueryDataSourceRequest)) {
            return false;
        }
        UpdateDirectQueryDataSourceRequest other = (UpdateDirectQueryDataSourceRequest)((Object)obj);
        return Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.dataSourceType(), other.dataSourceType()) && Objects.equals(this.description(), other.description()) && this.hasOpenSearchArns() == other.hasOpenSearchArns() && Objects.equals(this.openSearchArns(), other.openSearchArns());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDirectQueryDataSourceRequest").add("DataSourceName", (Object)this.dataSourceName()).add("DataSourceType", (Object)this.dataSourceType()).add("Description", (Object)this.description()).add("OpenSearchArns", this.hasOpenSearchArns() ? this.openSearchArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "DataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceType()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OpenSearchArns": {
                return Optional.ofNullable(clazz.cast(this.openSearchArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectQueryDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDirectQueryDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String dataSourceName;
        private DirectQueryDataSourceType dataSourceType;
        private String description;
        private List<String> openSearchArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectQueryDataSourceRequest model) {
            super(model);
            this.dataSourceName(model.dataSourceName);
            this.dataSourceType(model.dataSourceType);
            this.description(model.description);
            this.openSearchArns(model.openSearchArns);
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final DirectQueryDataSourceType.Builder getDataSourceType() {
            return this.dataSourceType != null ? this.dataSourceType.toBuilder() : null;
        }

        public final void setDataSourceType(DirectQueryDataSourceType.BuilderImpl dataSourceType) {
            this.dataSourceType = dataSourceType != null ? dataSourceType.build() : null;
        }

        @Override
        public final Builder dataSourceType(DirectQueryDataSourceType dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getOpenSearchArns() {
            if (this.openSearchArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.openSearchArns;
        }

        public final void setOpenSearchArns(Collection<String> openSearchArns) {
            this.openSearchArns = DirectQueryOpenSearchARNListCopier.copy(openSearchArns);
        }

        @Override
        public final Builder openSearchArns(Collection<String> openSearchArns) {
            this.openSearchArns = DirectQueryOpenSearchARNListCopier.copy(openSearchArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openSearchArns(String ... openSearchArns) {
            this.openSearchArns(Arrays.asList(openSearchArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectQueryDataSourceRequest build() {
            return new UpdateDirectQueryDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDirectQueryDataSourceRequest> {
        public Builder dataSourceName(String var1);

        public Builder dataSourceType(DirectQueryDataSourceType var1);

        default public Builder dataSourceType(Consumer<DirectQueryDataSourceType.Builder> dataSourceType) {
            return this.dataSourceType((DirectQueryDataSourceType)((DirectQueryDataSourceType.Builder)DirectQueryDataSourceType.builder().applyMutation(dataSourceType)).build());
        }

        public Builder description(String var1);

        public Builder openSearchArns(Collection<String> var1);

        public Builder openSearchArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

