/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VersionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VersionStatus> {
    private static final SdkField<String> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Options").getter(VersionStatus.getter(VersionStatus::options)).setter(VersionStatus.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(VersionStatus.getter(VersionStatus::status)).setter(VersionStatus.setter(Builder::status)).constructor(OptionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VersionStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String options;
    private final OptionStatus status;

    private VersionStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public final String options() {
        return this.options;
    }

    public final OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionStatus)) {
            return false;
        }
        VersionStatus other = (VersionStatus)obj;
        return Objects.equals(this.options(), other.options()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"VersionStatus").add("Options", (Object)this.options()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Options", OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VersionStatus, T> g) {
        return obj -> g.apply((VersionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final String getOptions() {
            return this.options;
        }

        public final void setOptions(String options) {
            this.options = options;
        }

        @Override
        public final Builder options(String options) {
            this.options = options;
            return this;
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public VersionStatus build() {
            return new VersionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VersionStatus> {
        public Builder options(String var1);

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().applyMutation(status)).build());
        }
    }
}

