/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationResponse extends OpenSearchResponse implements
        ToCopyableBuilder<CreateApplicationResponse.Builder, CreateApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateApplicationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSource>> builder(MarshallingType.LIST)
            .memberName("dataSources")
            .getter(getter(CreateApplicationResponse::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IamIdentityCenterOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField
            .<IamIdentityCenterOptions> builder(MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions")
            .getter(getter(CreateApplicationResponse::iamIdentityCenterOptions))
            .setter(setter(Builder::iamIdentityCenterOptions)).constructor(IamIdentityCenterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build())
            .build();

    private static final SdkField<List<AppConfig>> APP_CONFIGS_FIELD = SdkField
            .<List<AppConfig>> builder(MarshallingType.LIST)
            .memberName("appConfigs")
            .getter(getter(CreateApplicationResponse::appConfigs))
            .setter(setter(Builder::appConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tagList")
            .getter(getter(CreateApplicationResponse::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateApplicationResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_FIELD, NAME_FIELD, ARN_FIELD, DATA_SOURCES_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, APP_CONFIGS_FIELD,
                    TAG_LIST_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final List<DataSource> dataSources;

    private final IamIdentityCenterOptions iamIdentityCenterOptions;

    private final List<AppConfig> appConfigs;

    private final List<Tag> tagList;

    private final Instant createdAt;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.dataSources = builder.dataSources;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.appConfigs = builder.appConfigs;
        this.tagList = builder.tagList;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * Unique identifier for the created OpenSearch Application.
     * </p>
     * 
     * @return Unique identifier for the created OpenSearch Application.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Name of the created OpenSearch Application.
     * </p>
     * 
     * @return Name of the created OpenSearch Application.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Data sources associated with the created OpenSearch Application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return Data sources associated with the created OpenSearch Application.
     */
    public final List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * Settings of IAM Identity Center for the created OpenSearch Application.
     * </p>
     * 
     * @return Settings of IAM Identity Center for the created OpenSearch Application.
     */
    public final IamIdentityCenterOptions iamIdentityCenterOptions() {
        return iamIdentityCenterOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppConfigs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAppConfigs() {
        return appConfigs != null && !(appConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configurations of the OpenSearch Application, inlcuding admin configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppConfigs} method.
     * </p>
     * 
     * @return Configurations of the OpenSearch Application, inlcuding admin configuration.
     */
    public final List<AppConfig> appConfigs() {
        return appConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    /**
     * <p>
     * Timestamp when the OpenSearch Application was created.
     * </p>
     * 
     * @return Timestamp when the OpenSearch Application was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppConfigs() ? appConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && Objects.equals(iamIdentityCenterOptions(), other.iamIdentityCenterOptions())
                && hasAppConfigs() == other.hasAppConfigs() && Objects.equals(appConfigs(), other.appConfigs())
                && hasTagList() == other.hasTagList() && Objects.equals(tagList(), other.tagList())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("DataSources", hasDataSources() ? dataSources() : null)
                .add("IamIdentityCenterOptions", iamIdentityCenterOptions())
                .add("AppConfigs", hasAppConfigs() ? appConfigs() : null).add("TagList", hasTagList() ? tagList() : null)
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "iamIdentityCenterOptions":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterOptions()));
        case "appConfigs":
            return Optional.ofNullable(clazz.cast(appConfigs()));
        case "tagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("appConfigs", APP_CONFIGS_FIELD);
        map.put("tagList", TAG_LIST_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationResponse> {
        /**
         * <p>
         * Unique identifier for the created OpenSearch Application.
         * </p>
         * 
         * @param id
         *        Unique identifier for the created OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Name of the created OpenSearch Application.
         * </p>
         * 
         * @param name
         *        Name of the created OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Data sources associated with the created OpenSearch Application.
         * </p>
         * 
         * @param dataSources
         *        Data sources associated with the created OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * Data sources associated with the created OpenSearch Application.
         * </p>
         * 
         * @param dataSources
         *        Data sources associated with the created OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * Data sources associated with the created OpenSearch Application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(List<DataSource>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<DataSource>)
         */
        Builder dataSources(Consumer<DataSource.Builder>... dataSources);

        /**
         * <p>
         * Settings of IAM Identity Center for the created OpenSearch Application.
         * </p>
         * 
         * @param iamIdentityCenterOptions
         *        Settings of IAM Identity Center for the created OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterOptions(IamIdentityCenterOptions iamIdentityCenterOptions);

        /**
         * <p>
         * Settings of IAM Identity Center for the created OpenSearch Application.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamIdentityCenterOptions.Builder}
         * avoiding the need to create one manually via {@link IamIdentityCenterOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamIdentityCenterOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #iamIdentityCenterOptions(IamIdentityCenterOptions)}.
         * 
         * @param iamIdentityCenterOptions
         *        a consumer that will call methods on {@link IamIdentityCenterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentityCenterOptions(IamIdentityCenterOptions)
         */
        default Builder iamIdentityCenterOptions(Consumer<IamIdentityCenterOptions.Builder> iamIdentityCenterOptions) {
            return iamIdentityCenterOptions(IamIdentityCenterOptions.builder().applyMutation(iamIdentityCenterOptions).build());
        }

        /**
         * <p>
         * Configurations of the OpenSearch Application, inlcuding admin configuration.
         * </p>
         * 
         * @param appConfigs
         *        Configurations of the OpenSearch Application, inlcuding admin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigs(Collection<AppConfig> appConfigs);

        /**
         * <p>
         * Configurations of the OpenSearch Application, inlcuding admin configuration.
         * </p>
         * 
         * @param appConfigs
         *        Configurations of the OpenSearch Application, inlcuding admin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigs(AppConfig... appConfigs);

        /**
         * <p>
         * Configurations of the OpenSearch Application, inlcuding admin configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.AppConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #appConfigs(List<AppConfig>)}.
         * 
         * @param appConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appConfigs(java.util.Collection<AppConfig>)
         */
        Builder appConfigs(Consumer<AppConfig.Builder>... appConfigs);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.opensearch.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        /**
         * <p>
         * Timestamp when the OpenSearch Application was created.
         * </p>
         * 
         * @param createdAt
         *        Timestamp when the OpenSearch Application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();

        private IamIdentityCenterOptions iamIdentityCenterOptions;

        private List<AppConfig> appConfigs = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            dataSources(model.dataSources);
            iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            appConfigs(model.appConfigs);
            tagList(model.tagList);
            createdAt(model.createdAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final IamIdentityCenterOptions.Builder getIamIdentityCenterOptions() {
            return iamIdentityCenterOptions != null ? iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(IamIdentityCenterOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(IamIdentityCenterOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final List<AppConfig.Builder> getAppConfigs() {
            List<AppConfig.Builder> result = AppConfigsCopier.copyToBuilder(this.appConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppConfigs(Collection<AppConfig.BuilderImpl> appConfigs) {
            this.appConfigs = AppConfigsCopier.copyFromBuilder(appConfigs);
        }

        @Override
        public final Builder appConfigs(Collection<AppConfig> appConfigs) {
            this.appConfigs = AppConfigsCopier.copy(appConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(AppConfig... appConfigs) {
            appConfigs(Arrays.asList(appConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(Consumer<AppConfig.Builder>... appConfigs) {
            appConfigs(Stream.of(appConfigs).map(c -> AppConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
