/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the request parameters to the <code>DissociatePackage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DissociatePackageRequest extends OpenSearchRequest implements
        ToCopyableBuilder<DissociatePackageRequest.Builder, DissociatePackageRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(DissociatePackageRequest::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PackageID").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DissociatePackageRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            DOMAIN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageID;

    private final String domainName;

    private DissociatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * Internal ID of the package to dissociate from the domain. Use <code>ListPackagesForDomain</code> to find this
     * value.
     * </p>
     * 
     * @return Internal ID of the package to dissociate from the domain. Use <code>ListPackagesForDomain</code> to find
     *         this value.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * <p>
     * Name of the domain to dissociate the package from.
     * </p>
     * 
     * @return Name of the domain to dissociate the package from.
     */
    public final String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DissociatePackageRequest)) {
            return false;
        }
        DissociatePackageRequest other = (DissociatePackageRequest) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(domainName(), other.domainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DissociatePackageRequest").add("PackageID", packageID()).add("DomainName", domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DissociatePackageRequest, T> g) {
        return obj -> g.apply((DissociatePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DissociatePackageRequest> {
        /**
         * <p>
         * Internal ID of the package to dissociate from the domain. Use <code>ListPackagesForDomain</code> to find this
         * value.
         * </p>
         * 
         * @param packageID
         *        Internal ID of the package to dissociate from the domain. Use <code>ListPackagesForDomain</code> to
         *        find this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * Name of the domain to dissociate the package from.
         * </p>
         * 
         * @param domainName
         *        Name of the domain to dissociate the package from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String packageID;

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DissociatePackageRequest model) {
            super(model);
            packageID(model.packageID);
            domainName(model.domainName);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DissociatePackageRequest build() {
            return new DissociatePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
