/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for specifying node type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeOption implements SdkPojo, Serializable, ToCopyableBuilder<NodeOption.Builder, NodeOption> {
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(NodeOption::nodeTypeAsString)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<NodeConfig> NODE_CONFIG_FIELD = SdkField.<NodeConfig> builder(MarshallingType.SDK_POJO)
            .memberName("NodeConfig").getter(getter(NodeOption::nodeConfig)).setter(setter(Builder::nodeConfig))
            .constructor(NodeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_TYPE_FIELD,
            NODE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeType;

    private final NodeConfig nodeConfig;

    private NodeOption(BuilderImpl builder) {
        this.nodeType = builder.nodeType;
        this.nodeConfig = builder.nodeConfig;
    }

    /**
     * <p>
     * Container for node type like coordinating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeOptionsNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return Container for node type like coordinating.
     * @see NodeOptionsNodeType
     */
    public final NodeOptionsNodeType nodeType() {
        return NodeOptionsNodeType.fromValue(nodeType);
    }

    /**
     * <p>
     * Container for node type like coordinating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeOptionsNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return Container for node type like coordinating.
     * @see NodeOptionsNodeType
     */
    public final String nodeTypeAsString() {
        return nodeType;
    }

    /**
     * <p>
     * Container for specifying configuration of any node type.
     * </p>
     * 
     * @return Container for specifying configuration of any node type.
     */
    public final NodeConfig nodeConfig() {
        return nodeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOption)) {
            return false;
        }
        NodeOption other = (NodeOption) obj;
        return Objects.equals(nodeTypeAsString(), other.nodeTypeAsString()) && Objects.equals(nodeConfig(), other.nodeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeOption").add("NodeType", nodeTypeAsString()).add("NodeConfig", nodeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeTypeAsString()));
        case "NodeConfig":
            return Optional.ofNullable(clazz.cast(nodeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("NodeConfig", NODE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeOption, T> g) {
        return obj -> g.apply((NodeOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeOption> {
        /**
         * <p>
         * Container for node type like coordinating.
         * </p>
         * 
         * @param nodeType
         *        Container for node type like coordinating.
         * @see NodeOptionsNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeOptionsNodeType
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * Container for node type like coordinating.
         * </p>
         * 
         * @param nodeType
         *        Container for node type like coordinating.
         * @see NodeOptionsNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeOptionsNodeType
         */
        Builder nodeType(NodeOptionsNodeType nodeType);

        /**
         * <p>
         * Container for specifying configuration of any node type.
         * </p>
         * 
         * @param nodeConfig
         *        Container for specifying configuration of any node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeConfig(NodeConfig nodeConfig);

        /**
         * <p>
         * Container for specifying configuration of any node type.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeConfig.Builder} avoiding the need to
         * create one manually via {@link NodeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #nodeConfig(NodeConfig)}.
         * 
         * @param nodeConfig
         *        a consumer that will call methods on {@link NodeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeConfig(NodeConfig)
         */
        default Builder nodeConfig(Consumer<NodeConfig.Builder> nodeConfig) {
            return nodeConfig(NodeConfig.builder().applyMutation(nodeConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String nodeType;

        private NodeConfig nodeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOption model) {
            nodeType(model.nodeType);
            nodeConfig(model.nodeConfig);
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeOptionsNodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final NodeConfig.Builder getNodeConfig() {
            return nodeConfig != null ? nodeConfig.toBuilder() : null;
        }

        public final void setNodeConfig(NodeConfig.BuilderImpl nodeConfig) {
            this.nodeConfig = nodeConfig != null ? nodeConfig.build() : null;
        }

        @Override
        public final Builder nodeConfig(NodeConfig nodeConfig) {
            this.nodeConfig = nodeConfig;
            return this;
        }

        @Override
        public NodeOption build() {
            return new NodeOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
