/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamIdentityCenterOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamIdentityCenterOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(IamIdentityCenterOptionsInput.getter(IamIdentityCenterOptionsInput::enabled)).setter(IamIdentityCenterOptionsInput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<String> IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamIdentityCenterInstanceArn").getter(IamIdentityCenterOptionsInput.getter(IamIdentityCenterOptionsInput::iamIdentityCenterInstanceArn)).setter(IamIdentityCenterOptionsInput.setter(Builder::iamIdentityCenterInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterInstanceArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRoleForIdentityCenterApplicationArn").getter(IamIdentityCenterOptionsInput.getter(IamIdentityCenterOptionsInput::iamRoleForIdentityCenterApplicationArn)).setter(IamIdentityCenterOptionsInput.setter(Builder::iamRoleForIdentityCenterApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleForIdentityCenterApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD, IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IamIdentityCenterOptionsInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String iamIdentityCenterInstanceArn;
    private final String iamRoleForIdentityCenterApplicationArn;

    private IamIdentityCenterOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.iamIdentityCenterInstanceArn = builder.iamIdentityCenterInstanceArn;
        this.iamRoleForIdentityCenterApplicationArn = builder.iamRoleForIdentityCenterApplicationArn;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String iamIdentityCenterInstanceArn() {
        return this.iamIdentityCenterInstanceArn;
    }

    public final String iamRoleForIdentityCenterApplicationArn() {
        return this.iamRoleForIdentityCenterApplicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleForIdentityCenterApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamIdentityCenterOptionsInput)) {
            return false;
        }
        IamIdentityCenterOptionsInput other = (IamIdentityCenterOptionsInput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.iamIdentityCenterInstanceArn(), other.iamIdentityCenterInstanceArn()) && Objects.equals(this.iamRoleForIdentityCenterApplicationArn(), other.iamRoleForIdentityCenterApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"IamIdentityCenterOptionsInput").add("Enabled", (Object)this.enabled()).add("IamIdentityCenterInstanceArn", (Object)this.iamIdentityCenterInstanceArn()).add("IamRoleForIdentityCenterApplicationArn", (Object)this.iamRoleForIdentityCenterApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "iamIdentityCenterInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterInstanceArn()));
            }
            case "iamRoleForIdentityCenterApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleForIdentityCenterApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("iamIdentityCenterInstanceArn", IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("iamRoleForIdentityCenterApplicationArn", IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamIdentityCenterOptionsInput, T> g) {
        return obj -> g.apply((IamIdentityCenterOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String iamIdentityCenterInstanceArn;
        private String iamRoleForIdentityCenterApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IamIdentityCenterOptionsInput model) {
            this.enabled(model.enabled);
            this.iamIdentityCenterInstanceArn(model.iamIdentityCenterInstanceArn);
            this.iamRoleForIdentityCenterApplicationArn(model.iamRoleForIdentityCenterApplicationArn);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getIamIdentityCenterInstanceArn() {
            return this.iamIdentityCenterInstanceArn;
        }

        public final void setIamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
        }

        @Override
        public final Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
            return this;
        }

        public final String getIamRoleForIdentityCenterApplicationArn() {
            return this.iamRoleForIdentityCenterApplicationArn;
        }

        public final void setIamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
            this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
        }

        @Override
        public final Builder iamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
            this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
            return this;
        }

        public IamIdentityCenterOptionsInput build() {
            return new IamIdentityCenterOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamIdentityCenterOptionsInput> {
        public Builder enabled(Boolean var1);

        public Builder iamIdentityCenterInstanceArn(String var1);

        public Builder iamRoleForIdentityCenterApplicationArn(String var1);
    }
}

