/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the SAML application configured for the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SAMLOptionsOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<SAMLOptionsOutput.Builder, SAMLOptionsOutput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(SAMLOptionsOutput::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<SAMLIdp> IDP_FIELD = SdkField.<SAMLIdp> builder(MarshallingType.SDK_POJO).memberName("Idp")
            .getter(getter(SAMLOptionsOutput::idp)).setter(setter(Builder::idp)).constructor(SAMLIdp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Idp").build()).build();

    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubjectKey").getter(getter(SAMLOptionsOutput::subjectKey)).setter(setter(Builder::subjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()).build();

    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RolesKey").getter(getter(SAMLOptionsOutput::rolesKey)).setter(setter(Builder::rolesKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionTimeoutMinutes").getter(getter(SAMLOptionsOutput::sessionTimeoutMinutes))
            .setter(setter(Builder::sessionTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IDP_FIELD,
            SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, SESSION_TIMEOUT_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final SAMLIdp idp;

    private final String subjectKey;

    private final String rolesKey;

    private final Integer sessionTimeoutMinutes;

    private SAMLOptionsOutput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.idp = builder.idp;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
    }

    /**
     * <p>
     * True if SAML is enabled.
     * </p>
     * 
     * @return True if SAML is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Describes the SAML identity provider's information.
     * </p>
     * 
     * @return Describes the SAML identity provider's information.
     */
    public final SAMLIdp idp() {
        return idp;
    }

    /**
     * <p>
     * The key used for matching the SAML subject attribute.
     * </p>
     * 
     * @return The key used for matching the SAML subject attribute.
     */
    public final String subjectKey() {
        return subjectKey;
    }

    /**
     * <p>
     * The key used for matching the SAML roles attribute.
     * </p>
     * 
     * @return The key used for matching the SAML roles attribute.
     */
    public final String rolesKey() {
        return rolesKey;
    }

    /**
     * <p>
     * The duration, in minutes, after which a user session becomes inactive.
     * </p>
     * 
     * @return The duration, in minutes, after which a user session becomes inactive.
     */
    public final Integer sessionTimeoutMinutes() {
        return sessionTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(idp());
        hashCode = 31 * hashCode + Objects.hashCode(subjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(rolesKey());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAMLOptionsOutput)) {
            return false;
        }
        SAMLOptionsOutput other = (SAMLOptionsOutput) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(idp(), other.idp())
                && Objects.equals(subjectKey(), other.subjectKey()) && Objects.equals(rolesKey(), other.rolesKey())
                && Objects.equals(sessionTimeoutMinutes(), other.sessionTimeoutMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SAMLOptionsOutput").add("Enabled", enabled()).add("Idp", idp()).add("SubjectKey", subjectKey())
                .add("RolesKey", rolesKey()).add("SessionTimeoutMinutes", sessionTimeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Idp":
            return Optional.ofNullable(clazz.cast(idp()));
        case "SubjectKey":
            return Optional.ofNullable(clazz.cast(subjectKey()));
        case "RolesKey":
            return Optional.ofNullable(clazz.cast(rolesKey()));
        case "SessionTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(sessionTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("Idp", IDP_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        map.put("SessionTimeoutMinutes", SESSION_TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAMLOptionsOutput, T> g) {
        return obj -> g.apply((SAMLOptionsOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SAMLOptionsOutput> {
        /**
         * <p>
         * True if SAML is enabled.
         * </p>
         * 
         * @param enabled
         *        True if SAML is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Describes the SAML identity provider's information.
         * </p>
         * 
         * @param idp
         *        Describes the SAML identity provider's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idp(SAMLIdp idp);

        /**
         * <p>
         * Describes the SAML identity provider's information.
         * </p>
         * This is a convenience method that creates an instance of the {@link SAMLIdp.Builder} avoiding the need to
         * create one manually via {@link SAMLIdp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAMLIdp.Builder#build()} is called immediately and its result is
         * passed to {@link #idp(SAMLIdp)}.
         * 
         * @param idp
         *        a consumer that will call methods on {@link SAMLIdp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idp(SAMLIdp)
         */
        default Builder idp(Consumer<SAMLIdp.Builder> idp) {
            return idp(SAMLIdp.builder().applyMutation(idp).build());
        }

        /**
         * <p>
         * The key used for matching the SAML subject attribute.
         * </p>
         * 
         * @param subjectKey
         *        The key used for matching the SAML subject attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectKey(String subjectKey);

        /**
         * <p>
         * The key used for matching the SAML roles attribute.
         * </p>
         * 
         * @param rolesKey
         *        The key used for matching the SAML roles attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolesKey(String rolesKey);

        /**
         * <p>
         * The duration, in minutes, after which a user session becomes inactive.
         * </p>
         * 
         * @param sessionTimeoutMinutes
         *        The duration, in minutes, after which a user session becomes inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutMinutes(Integer sessionTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private SAMLIdp idp;

        private String subjectKey;

        private String rolesKey;

        private Integer sessionTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SAMLOptionsOutput model) {
            enabled(model.enabled);
            idp(model.idp);
            subjectKey(model.subjectKey);
            rolesKey(model.rolesKey);
            sessionTimeoutMinutes(model.sessionTimeoutMinutes);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final SAMLIdp.Builder getIdp() {
            return idp != null ? idp.toBuilder() : null;
        }

        public final void setIdp(SAMLIdp.BuilderImpl idp) {
            this.idp = idp != null ? idp.build() : null;
        }

        @Override
        public final Builder idp(SAMLIdp idp) {
            this.idp = idp;
            return this;
        }

        public final String getSubjectKey() {
            return subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        public final String getRolesKey() {
            return rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        public final Integer getSessionTimeoutMinutes() {
            return sessionTimeoutMinutes;
        }

        public final void setSessionTimeoutMinutes(Integer sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
        }

        @Override
        public final Builder sessionTimeoutMinutes(Integer sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            return this;
        }

        @Override
        public SAMLOptionsOutput build() {
            return new SAMLOptionsOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
