/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddDirectQueryDataSourceRequest extends OpenSearchRequest implements
        ToCopyableBuilder<AddDirectQueryDataSourceRequest.Builder, AddDirectQueryDataSourceRequest> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceName").getter(getter(AddDirectQueryDataSourceRequest::dataSourceName))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceName").build()).build();

    private static final SdkField<DirectQueryDataSourceType> DATA_SOURCE_TYPE_FIELD = SdkField
            .<DirectQueryDataSourceType> builder(MarshallingType.SDK_POJO).memberName("DataSourceType")
            .getter(getter(AddDirectQueryDataSourceRequest::dataSourceType)).setter(setter(Builder::dataSourceType))
            .constructor(DirectQueryDataSourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AddDirectQueryDataSourceRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> OPEN_SEARCH_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OpenSearchArns")
            .getter(getter(AddDirectQueryDataSourceRequest::openSearchArns))
            .setter(setter(Builder::openSearchArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenSearchArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagList")
            .getter(getter(AddDirectQueryDataSourceRequest::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD,
            DATA_SOURCE_TYPE_FIELD, DESCRIPTION_FIELD, OPEN_SEARCH_ARNS_FIELD, TAG_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataSourceName;

    private final DirectQueryDataSourceType dataSourceType;

    private final String description;

    private final List<String> openSearchArns;

    private final List<Tag> tagList;

    private AddDirectQueryDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceName = builder.dataSourceName;
        this.dataSourceType = builder.dataSourceType;
        this.description = builder.description;
        this.openSearchArns = builder.openSearchArns;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * A unique, user-defined label to identify the data source within your OpenSearch Service environment.
     * </p>
     * 
     * @return A unique, user-defined label to identify the data source within your OpenSearch Service environment.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The supported Amazon Web Services service that you want to use as the source for direct queries in OpenSearch
     * Service.
     * </p>
     * 
     * @return The supported Amazon Web Services service that you want to use as the source for direct queries in
     *         OpenSearch Service.
     */
    public final DirectQueryDataSourceType dataSourceType() {
        return dataSourceType;
    }

    /**
     * <p>
     * An optional text field for providing additional context and details about the data source.
     * </p>
     * 
     * @return An optional text field for providing additional context and details about the data source.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpenSearchArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOpenSearchArns() {
        return openSearchArns != null && !(openSearchArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the direct query
     * data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpenSearchArns} method.
     * </p>
     * 
     * @return A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the direct
     *         query data source.
     */
    public final List<String> openSearchArns() {
        return openSearchArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpenSearchArns() ? openSearchArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddDirectQueryDataSourceRequest)) {
            return false;
        }
        AddDirectQueryDataSourceRequest other = (AddDirectQueryDataSourceRequest) obj;
        return Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(dataSourceType(), other.dataSourceType()) && Objects.equals(description(), other.description())
                && hasOpenSearchArns() == other.hasOpenSearchArns() && Objects.equals(openSearchArns(), other.openSearchArns())
                && hasTagList() == other.hasTagList() && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddDirectQueryDataSourceRequest").add("DataSourceName", dataSourceName())
                .add("DataSourceType", dataSourceType()).add("Description", description())
                .add("OpenSearchArns", hasOpenSearchArns() ? openSearchArns() : null)
                .add("TagList", hasTagList() ? tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "DataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OpenSearchArns":
            return Optional.ofNullable(clazz.cast(openSearchArns()));
        case "TagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSourceName", DATA_SOURCE_NAME_FIELD);
        map.put("DataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OpenSearchArns", OPEN_SEARCH_ARNS_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddDirectQueryDataSourceRequest, T> g) {
        return obj -> g.apply((AddDirectQueryDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddDirectQueryDataSourceRequest> {
        /**
         * <p>
         * A unique, user-defined label to identify the data source within your OpenSearch Service environment.
         * </p>
         * 
         * @param dataSourceName
         *        A unique, user-defined label to identify the data source within your OpenSearch Service environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The supported Amazon Web Services service that you want to use as the source for direct queries in OpenSearch
         * Service.
         * </p>
         * 
         * @param dataSourceType
         *        The supported Amazon Web Services service that you want to use as the source for direct queries in
         *        OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceType(DirectQueryDataSourceType dataSourceType);

        /**
         * <p>
         * The supported Amazon Web Services service that you want to use as the source for direct queries in OpenSearch
         * Service.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectQueryDataSourceType.Builder}
         * avoiding the need to create one manually via {@link DirectQueryDataSourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectQueryDataSourceType.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceType(DirectQueryDataSourceType)}.
         * 
         * @param dataSourceType
         *        a consumer that will call methods on {@link DirectQueryDataSourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceType(DirectQueryDataSourceType)
         */
        default Builder dataSourceType(Consumer<DirectQueryDataSourceType.Builder> dataSourceType) {
            return dataSourceType(DirectQueryDataSourceType.builder().applyMutation(dataSourceType).build());
        }

        /**
         * <p>
         * An optional text field for providing additional context and details about the data source.
         * </p>
         * 
         * @param description
         *        An optional text field for providing additional context and details about the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the direct
         * query data source.
         * </p>
         * 
         * @param openSearchArns
         *        A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the
         *        direct query data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchArns(Collection<String> openSearchArns);

        /**
         * <p>
         * A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the direct
         * query data source.
         * </p>
         * 
         * @param openSearchArns
         *        A list of Amazon Resource Names (ARNs) for the OpenSearch collections that are associated with the
         *        direct query data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchArns(String... openSearchArns);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.opensearch.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String dataSourceName;

        private DirectQueryDataSourceType dataSourceType;

        private String description;

        private List<String> openSearchArns = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddDirectQueryDataSourceRequest model) {
            super(model);
            dataSourceName(model.dataSourceName);
            dataSourceType(model.dataSourceType);
            description(model.description);
            openSearchArns(model.openSearchArns);
            tagList(model.tagList);
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final DirectQueryDataSourceType.Builder getDataSourceType() {
            return dataSourceType != null ? dataSourceType.toBuilder() : null;
        }

        public final void setDataSourceType(DirectQueryDataSourceType.BuilderImpl dataSourceType) {
            this.dataSourceType = dataSourceType != null ? dataSourceType.build() : null;
        }

        @Override
        public final Builder dataSourceType(DirectQueryDataSourceType dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getOpenSearchArns() {
            if (openSearchArns instanceof SdkAutoConstructList) {
                return null;
            }
            return openSearchArns;
        }

        public final void setOpenSearchArns(Collection<String> openSearchArns) {
            this.openSearchArns = DirectQueryOpenSearchARNListCopier.copy(openSearchArns);
        }

        @Override
        public final Builder openSearchArns(Collection<String> openSearchArns) {
            this.openSearchArns = DirectQueryOpenSearchARNListCopier.copy(openSearchArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openSearchArns(String... openSearchArns) {
            openSearchArns(Arrays.asList(openSearchArns));
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddDirectQueryDataSourceRequest build() {
            return new AddDirectQueryDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
