/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeVpcEndpointAccessRequest extends OpenSearchRequest implements
        ToCopyableBuilder<AuthorizeVpcEndpointAccessRequest.Builder, AuthorizeVpcEndpointAccessRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AuthorizeVpcEndpointAccessRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(AuthorizeVpcEndpointAccessRequest::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(AuthorizeVpcEndpointAccessRequest::serviceAsString)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ACCOUNT_FIELD, SERVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String account;

    private final String service;

    private AuthorizeVpcEndpointAccessRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.account = builder.account;
        this.service = builder.service;
    }

    /**
     * <p>
     * The name of the OpenSearch Service domain to provide access to.
     * </p>
     * 
     * @return The name of the OpenSearch Service domain to provide access to.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to grant access to.
     * </p>
     * 
     * @return The Amazon Web Services account ID to grant access to.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The Amazon Web Services service SP to grant access to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link AWSServicePrincipal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service SP to grant access to.
     * @see AWSServicePrincipal
     */
    public final AWSServicePrincipal service() {
        return AWSServicePrincipal.fromValue(service);
    }

    /**
     * <p>
     * The Amazon Web Services service SP to grant access to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link AWSServicePrincipal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service SP to grant access to.
     * @see AWSServicePrincipal
     */
    public final String serviceAsString() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeVpcEndpointAccessRequest)) {
            return false;
        }
        AuthorizeVpcEndpointAccessRequest other = (AuthorizeVpcEndpointAccessRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(account(), other.account())
                && Objects.equals(serviceAsString(), other.serviceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizeVpcEndpointAccessRequest").add("DomainName", domainName()).add("Account", account())
                .add("Service", serviceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "Service":
            return Optional.ofNullable(clazz.cast(serviceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Account", ACCOUNT_FIELD);
        map.put("Service", SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeVpcEndpointAccessRequest, T> g) {
        return obj -> g.apply((AuthorizeVpcEndpointAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AuthorizeVpcEndpointAccessRequest> {
        /**
         * <p>
         * The name of the OpenSearch Service domain to provide access to.
         * </p>
         * 
         * @param domainName
         *        The name of the OpenSearch Service domain to provide access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The Amazon Web Services account ID to grant access to.
         * </p>
         * 
         * @param account
         *        The Amazon Web Services account ID to grant access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The Amazon Web Services service SP to grant access to.
         * </p>
         * 
         * @param service
         *        The Amazon Web Services service SP to grant access to.
         * @see AWSServicePrincipal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSServicePrincipal
         */
        Builder service(String service);

        /**
         * <p>
         * The Amazon Web Services service SP to grant access to.
         * </p>
         * 
         * @param service
         *        The Amazon Web Services service SP to grant access to.
         * @see AWSServicePrincipal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSServicePrincipal
         */
        Builder service(AWSServicePrincipal service);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String account;

        private String service;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeVpcEndpointAccessRequest model) {
            super(model);
            domainName(model.domainName);
            account(model.account);
            service(model.service);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(AWSServicePrincipal service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeVpcEndpointAccessRequest build() {
            return new AuthorizeVpcEndpointAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
