/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data sources that are associated with an OpenSearch Application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSource implements SdkPojo, Serializable, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceArn").getter(getter(DataSource::dataSourceArn)).setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceArn").build()).build();

    private static final SdkField<String> DATA_SOURCE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceDescription").getter(getter(DataSource::dataSourceDescription))
            .setter(setter(Builder::dataSourceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD,
            DATA_SOURCE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceArn;

    private final String dataSourceDescription;

    private DataSource(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.dataSourceDescription = builder.dataSourceDescription;
    }

    /**
     * Returns the value of the DataSourceArn property for this object.
     * 
     * @return The value of the DataSourceArn property for this object.
     */
    public final String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * <p>
     * Detailed description of a data source.
     * </p>
     * 
     * @return Detailed description of a data source.
     */
    public final String dataSourceDescription() {
        return dataSourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        return Objects.equals(dataSourceArn(), other.dataSourceArn())
                && Objects.equals(dataSourceDescription(), other.dataSourceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSource").add("DataSourceArn", dataSourceArn())
                .add("DataSourceDescription", dataSourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "dataSourceDescription":
            return Optional.ofNullable(clazz.cast(dataSourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSourceArn", DATA_SOURCE_ARN_FIELD);
        map.put("dataSourceDescription", DATA_SOURCE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSource> {
        /**
         * Sets the value of the DataSourceArn property for this object.
         *
         * @param dataSourceArn
         *        The new value for the DataSourceArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * Detailed description of a data source.
         * </p>
         * 
         * @param dataSourceDescription
         *        Detailed description of a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceDescription(String dataSourceDescription);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceArn;

        private String dataSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            dataSourceArn(model.dataSourceArn);
            dataSourceDescription(model.dataSourceDescription);
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getDataSourceDescription() {
            return dataSourceDescription;
        }

        public final void setDataSourceDescription(String dataSourceDescription) {
            this.dataSourceDescription = dataSourceDescription;
        }

        @Override
        public final Builder dataSourceDescription(String dataSourceDescription) {
            this.dataSourceDescription = dataSourceDescription;
            return this;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
