/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceType implements SdkPojo, Serializable, ToCopyableBuilder<DataSourceType.Builder, DataSourceType> {
    private static final SdkField<S3GlueDataCatalog> S3_GLUE_DATA_CATALOG_FIELD = SdkField
            .<S3GlueDataCatalog> builder(MarshallingType.SDK_POJO).memberName("S3GlueDataCatalog")
            .getter(getter(DataSourceType::s3GlueDataCatalog)).setter(setter(Builder::s3GlueDataCatalog))
            .constructor(S3GlueDataCatalog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3GlueDataCatalog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_GLUE_DATA_CATALOG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3GlueDataCatalog s3GlueDataCatalog;

    private final Type type;

    private DataSourceType(BuilderImpl builder) {
        this.s3GlueDataCatalog = builder.s3GlueDataCatalog;
        this.type = builder.type;
    }

    /**
     * <p>
     * An Amazon S3 data source.
     * </p>
     * 
     * @return An Amazon S3 data source.
     */
    public final S3GlueDataCatalog s3GlueDataCatalog() {
        return s3GlueDataCatalog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3GlueDataCatalog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceType)) {
            return false;
        }
        DataSourceType other = (DataSourceType) obj;
        return Objects.equals(s3GlueDataCatalog(), other.s3GlueDataCatalog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceType").add("S3GlueDataCatalog", s3GlueDataCatalog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3GlueDataCatalog":
            return Optional.ofNullable(clazz.cast(s3GlueDataCatalog()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3GlueDataCatalog()} initialized to the given value.
     *
     * <p>
     * An Amazon S3 data source.
     * </p>
     * 
     * @param s3GlueDataCatalog
     *        An Amazon S3 data source.
     */
    public static DataSourceType fromS3GlueDataCatalog(S3GlueDataCatalog s3GlueDataCatalog) {
        return builder().s3GlueDataCatalog(s3GlueDataCatalog).build();
    }

    /**
     * Create an instance of this class with {@link #s3GlueDataCatalog()} initialized to the given value.
     *
     * <p>
     * An Amazon S3 data source.
     * </p>
     * 
     * @param s3GlueDataCatalog
     *        An Amazon S3 data source.
     */
    public static DataSourceType fromS3GlueDataCatalog(Consumer<S3GlueDataCatalog.Builder> s3GlueDataCatalog) {
        S3GlueDataCatalog.Builder builder = S3GlueDataCatalog.builder();
        s3GlueDataCatalog.accept(builder);
        return fromS3GlueDataCatalog(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3GlueDataCatalog", S3_GLUE_DATA_CATALOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceType, T> g) {
        return obj -> g.apply((DataSourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceType> {
        /**
         * <p>
         * An Amazon S3 data source.
         * </p>
         * 
         * @param s3GlueDataCatalog
         *        An Amazon S3 data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3GlueDataCatalog(S3GlueDataCatalog s3GlueDataCatalog);

        /**
         * <p>
         * An Amazon S3 data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3GlueDataCatalog.Builder} avoiding the
         * need to create one manually via {@link S3GlueDataCatalog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3GlueDataCatalog.Builder#build()} is called immediately and its
         * result is passed to {@link #s3GlueDataCatalog(S3GlueDataCatalog)}.
         * 
         * @param s3GlueDataCatalog
         *        a consumer that will call methods on {@link S3GlueDataCatalog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3GlueDataCatalog(S3GlueDataCatalog)
         */
        default Builder s3GlueDataCatalog(Consumer<S3GlueDataCatalog.Builder> s3GlueDataCatalog) {
            return s3GlueDataCatalog(S3GlueDataCatalog.builder().applyMutation(s3GlueDataCatalog).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3GlueDataCatalog s3GlueDataCatalog;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceType model) {
            s3GlueDataCatalog(model.s3GlueDataCatalog);
        }

        public final S3GlueDataCatalog.Builder getS3GlueDataCatalog() {
            return s3GlueDataCatalog != null ? s3GlueDataCatalog.toBuilder() : null;
        }

        public final void setS3GlueDataCatalog(S3GlueDataCatalog.BuilderImpl s3GlueDataCatalog) {
            Object oldValue = this.s3GlueDataCatalog;
            this.s3GlueDataCatalog = s3GlueDataCatalog != null ? s3GlueDataCatalog.build() : null;
            handleUnionValueChange(Type.S3_GLUE_DATA_CATALOG, oldValue, this.s3GlueDataCatalog);
        }

        @Override
        public final Builder s3GlueDataCatalog(S3GlueDataCatalog s3GlueDataCatalog) {
            Object oldValue = this.s3GlueDataCatalog;
            this.s3GlueDataCatalog = s3GlueDataCatalog;
            handleUnionValueChange(Type.S3_GLUE_DATA_CATALOG, oldValue, this.s3GlueDataCatalog);
            return this;
        }

        @Override
        public DataSourceType build() {
            return new DataSourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataSourceType#type()
     */
    public enum Type {
        S3_GLUE_DATA_CATALOG,

        UNKNOWN_TO_SDK_VERSION
    }
}
